/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.dependency;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class DependencyVisitor
extends ClassVisitor {
    private MVisitor mv;
    private AVisitor av;
    private SVisitor sv;
    private FVisitor fv;
    private Set<String> packages = new HashSet<String>();
    private Map<String, Map<String, Integer>> groups = new HashMap<String, Map<String, Integer>>();
    private Map<String, Integer> current;

    public DependencyVisitor() {
        super(458752);
        this.mv = new MVisitor();
        this.av = new AVisitor();
        this.sv = new SVisitor();
        this.fv = new FVisitor();
    }

    public Map<String, Map<String, Integer>> getGlobals() {
        return this.groups;
    }

    public Set<String> getPackages() {
        return this.packages;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String p = this.getGroupKey(name);
        this.current = this.groups.get(p);
        if (this.current == null) {
            this.current = new HashMap<String, Integer>();
            this.groups.put(p, this.current);
        }
        if (signature == null) {
            this.addInternalName(superName);
            this.addInternalNames(interfaces);
        } else {
            this.addSignature(signature);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.addDesc(desc);
        return this.av;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (signature == null) {
            this.addDesc(desc);
        } else {
            this.addTypeSignature(signature);
        }
        if (value instanceof Type) {
            this.addType((Type)value);
        }
        return this.fv;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (signature == null) {
            this.addMethodDesc(desc);
        } else {
            this.addSignature(signature);
        }
        this.addInternalNames(exceptions);
        return this.mv;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    private String getGroupKey(String name) {
        int n = name.lastIndexOf(47);
        if (n > -1) {
            name = name.substring(0, n);
        }
        this.packages.add(name);
        return name;
    }

    private void addName(String name) {
        if (name == null) {
            return;
        }
        String p = this.getGroupKey(name);
        if (this.current.containsKey(p)) {
            this.current.put(p, this.current.get(p) + 1);
        } else {
            this.current.put(p, 1);
        }
    }

    private void addInternalName(String name) {
        if (name != null) {
            this.addType(Type.getObjectType((String)name));
        }
    }

    private void addInternalNames(String[] names) {
        for (int i = 0; names != null && i < names.length; ++i) {
            this.addInternalName(names[i]);
        }
    }

    private void addDesc(String desc) {
        this.addType(Type.getType((String)desc));
    }

    private void addMethodDesc(String desc) {
        this.addType(Type.getReturnType((String)desc));
        Type[] types = Type.getArgumentTypes((String)desc);
        for (int i = 0; i < types.length; ++i) {
            this.addType(types[i]);
        }
    }

    private void addType(Type t) {
        switch (t.getSort()) {
            case 9: {
                this.addType(t.getElementType());
                break;
            }
            case 10: {
                this.addName(t.getInternalName());
                break;
            }
        }
    }

    private void addSignature(String signature) {
        if (signature != null) {
            new SignatureReader(signature).accept((SignatureVisitor)this.sv);
        }
    }

    private void addTypeSignature(String signature) {
        if (signature != null) {
            new SignatureReader(signature).acceptType((SignatureVisitor)this.sv);
        }
    }

    private class FVisitor
    extends FieldVisitor {
        public FVisitor() {
            super(458752);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            DependencyVisitor.this.addDesc(desc);
            return DependencyVisitor.this.av;
        }
    }

    public class SVisitor
    extends SignatureVisitor {
        private String signatureClassName;

        public SVisitor() {
            super(458752);
        }

        public SignatureVisitor visitClassBound() {
            return this;
        }

        public SignatureVisitor visitInterfaceBound() {
            return this;
        }

        public SignatureVisitor visitSuperclass() {
            return this;
        }

        public SignatureVisitor visitInterface() {
            return this;
        }

        public SignatureVisitor visitParameterType() {
            return this;
        }

        public SignatureVisitor visitReturnType() {
            return this;
        }

        public SignatureVisitor visitExceptionType() {
            return this;
        }

        public SignatureVisitor visitArrayType() {
            return this;
        }

        public void visitClassType(String name) {
            this.signatureClassName = name;
            DependencyVisitor.this.addInternalName(name);
        }

        public void visitInnerClassType(String name) {
            this.signatureClassName = this.signatureClassName + "$" + name;
            DependencyVisitor.this.addInternalName(this.signatureClassName);
        }

        public SignatureVisitor visitTypeArgument(char wildcard) {
            return this;
        }
    }

    private class AVisitor
    extends AnnotationVisitor {
        public AVisitor() {
            super(458752);
        }

        public void visit(String name, Object value) {
            if (value instanceof Type) {
                DependencyVisitor.this.addType((Type)value);
            }
        }

        public void visitEnum(String name, String desc, String value) {
            DependencyVisitor.this.addDesc(desc);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            DependencyVisitor.this.addDesc(desc);
            return this;
        }

        public AnnotationVisitor visitArray(String name) {
            return this;
        }
    }

    private class MVisitor
    extends MethodVisitor {
        public MVisitor() {
            super(458752);
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            DependencyVisitor.this.addDesc(desc);
            return DependencyVisitor.this.av;
        }

        public void visitTypeInsn(int opcode, String type) {
            DependencyVisitor.this.addType(Type.getObjectType((String)type));
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            DependencyVisitor.this.addInternalName(owner);
            DependencyVisitor.this.addDesc(desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            DependencyVisitor.this.addInternalName(owner);
            DependencyVisitor.this.addMethodDesc(desc);
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                DependencyVisitor.this.addType((Type)cst);
            }
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            DependencyVisitor.this.addDesc(desc);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            DependencyVisitor.this.addTypeSignature(signature);
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return DependencyVisitor.this.av;
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            DependencyVisitor.this.addInternalName(type);
        }
    }
}

