/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.dependency;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.fuin.units4j.dependency.Dependency;
import org.fuin.utils4j.ToDebugStringCapable;
import org.fuin.utils4j.Utils4J;

@XmlRootElement(name="package")
public final class Package<DEP_TYPE extends Dependency>
implements ToDebugStringCapable,
Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="name")
    private String name;
    @XmlAttribute(name="comment")
    private String comment;
    @XmlAnyElement(lax=true)
    private List<DEP_TYPE> dependencies;

    protected Package() {
    }

    public Package(String name) {
        this(name, null);
    }

    public Package(String name, String comment) {
        Utils4J.checkNotNull((String)"name", (Object)name);
        this.name = name;
        this.comment = comment;
        this.dependencies = null;
    }

    public final String getName() {
        return this.name;
    }

    public final List<DEP_TYPE> getDependencies() {
        if (this.dependencies == null) {
            return Collections.emptyList();
        }
        return this.dependencies;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Package other = (Package)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public final String getComment() {
        return this.comment;
    }

    public final String toString() {
        return this.name;
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name=" + this.name + ", ");
        sb.append("comment=" + this.comment + ", ");
        sb.append("dependencies={");
        List<DEP_TYPE> list = this.getDependencies();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(list.get(i));
        }
        sb.append("}");
        return sb.toString();
    }
}

