/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.dependency;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.fuin.units4j.dependency.Dependencies;
import org.fuin.units4j.dependency.Dependency;
import org.fuin.units4j.dependency.DependsOn;
import org.fuin.units4j.dependency.NotDependsOn;
import org.fuin.units4j.dependency.Package;
import org.fuin.utils4j.JaxbUtils;
import org.fuin.utils4j.Utils4J;

public final class Utils {
    private Utils() {
        throw new UnsupportedOperationException("This utility class is not intended to be instanciated!");
    }

    static JAXBContext createJaxbContext() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{Dependencies.class, Package.class, DependsOn.class, NotDependsOn.class, Dependency.class});
        }
        catch (JAXBException ex) {
            throw new RuntimeException("Failed to create JAXB context", ex);
        }
    }

    public static Dependencies load(File file) {
        Dependencies dependencies;
        Utils4J.checkNotNull((String)"file", (Object)file);
        Utils4J.checkValidFile((File)file);
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            dependencies = Utils.load(inputStream);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)inputStream).close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        ((InputStream)inputStream).close();
        return dependencies;
    }

    public static Dependencies load(InputStream inputStream) {
        Utils4J.checkNotNull((String)"inputStream", (Object)inputStream);
        return (Dependencies)JaxbUtils.unmarshal((JAXBContext)Utils.createJaxbContext(), (Reader)new InputStreamReader(inputStream, Charset.forName("utf-8")), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dependencies load(Class<?> clasz, String resourcePathAndName) {
        Dependencies dependencies;
        Utils4J.checkNotNull((String)"clasz", clasz);
        Utils4J.checkNotNull((String)"resourcePathAndName", (Object)resourcePathAndName);
        URL url = clasz.getResource(resourcePathAndName);
        if (url == null) {
            throw new RuntimeException("Resource '" + resourcePathAndName + "' not found!");
        }
        InputStream in = url.openStream();
        try {
            dependencies = Utils.load(in);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to unmarshal from " + resourcePathAndName, ex);
            }
        }
        in.close();
        return dependencies;
    }

    public static void save(File file, Dependencies dependencies) {
        Utils4J.checkNotNull((String)"file", (Object)file);
        Utils4J.checkValidFile((File)file);
        try (FileWriter writer = new FileWriter(file);){
            JaxbUtils.marshal((JAXBContext)Utils.createJaxbContext(), (Object)dependencies, null, (Writer)writer);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to marshal: " + dependencies, ex);
        }
    }

    static <T> String toXml(T obj, boolean standalone, boolean formattedOutput) {
        String string;
        Marshaller marshaller = Utils.createJaxbContext().createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)(!standalone ? 1 : 0));
        marshaller.setProperty("jaxb.formatted.output", (Object)formattedOutput);
        StringWriter sw = new StringWriter();
        try {
            marshaller.marshal(obj, (Writer)sw);
            string = sw.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    sw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | JAXBException ex) {
                throw new RuntimeException("Failed to marshal: " + obj, ex);
            }
        }
        sw.close();
        return string;
    }

    public static DependsOn findAllowedByName(List<DependsOn> allowed, String pkgName) {
        if (allowed == null) {
            return null;
        }
        Utils4J.checkNotNull((String)"pkgName", (Object)pkgName);
        for (int i = 0; i < allowed.size(); ++i) {
            DependsOn dep = allowed.get(i);
            if (!pkgName.startsWith(dep.getPackageName())) continue;
            if (dep.isIncludeSubPackages()) {
                return dep;
            }
            if (!pkgName.equals(dep.getPackageName())) continue;
            return dep;
        }
        return null;
    }

    public static NotDependsOn findForbiddenByName(List<NotDependsOn> forbidden, String pkgName) {
        if (forbidden == null) {
            return null;
        }
        Utils4J.checkNotNull((String)"pkgName", (Object)pkgName);
        for (int i = 0; i < forbidden.size(); ++i) {
            NotDependsOn dep = forbidden.get(i);
            if (!pkgName.startsWith(dep.getPackageName())) continue;
            if (dep.isIncludeSubPackages()) {
                return dep;
            }
            if (!pkgName.equals(dep.getPackageName())) continue;
            return dep;
        }
        return null;
    }
}

