/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.graph.LegacyMapHelper;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Table;
import org.gephi.project.api.Workspace;
import org.gephi.project.spi.WorkspaceXMLPersistenceProvider;

public class LegacyAttributeRowsPersistenceProvider
implements WorkspaceXMLPersistenceProvider {
    private static final String ELEMENT_ROWS = "attributerows";
    private static final String ELEMENT_NODE_ROW = "noderow";
    private static final String ELEMENT_EDGE_ROW = "edgerow";
    private static final String ELEMENT_VALUE = "attvalue";

    public void writeXML(XMLStreamWriter writer, Workspace workspace) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void readXML(XMLStreamReader reader, Workspace workspace) {
        GraphModel model = (GraphModel)workspace.getLookup().lookup(GraphModel.class);
        if (model == null) {
            throw new IllegalStateException("The graphModel is null");
        }
        LegacyMapHelper helper = (LegacyMapHelper)workspace.getLookup().lookup(LegacyMapHelper.class);
        if (helper != null) {
            try {
                this.readRows(reader, model, helper);
            }
            catch (XMLStreamException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                workspace.remove((Object)helper);
            }
        }
    }

    public String getIdentifier() {
        return ELEMENT_ROWS;
    }

    public void readRows(XMLStreamReader reader, GraphModel graphModel, LegacyMapHelper mapHelper) throws XMLStreamException {
        Graph graph = graphModel.getGraph();
        boolean end = false;
        while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    String id;
                    String name = reader.getLocalName();
                    if (ELEMENT_NODE_ROW.equalsIgnoreCase(name)) {
                        id = reader.getAttributeValue(null, "for");
                        Node node = graph.getNode((Object)id);
                        this.readRow(reader, (Element)node, graphModel.getNodeTable(), mapHelper);
                        break;
                    }
                    if (!ELEMENT_EDGE_ROW.equalsIgnoreCase(name)) break;
                    id = reader.getAttributeValue(null, "for");
                    Edge edge = graph.getEdge((Object)id);
                    this.readRow(reader, (Element)edge, graphModel.getEdgeTable(), mapHelper);
                    break;
                }
                case 2: {
                    if (!ELEMENT_ROWS.equalsIgnoreCase(reader.getLocalName())) break;
                    end = true;
                }
            }
        }
    }

    public void readRow(XMLStreamReader reader, Element element, Table table, LegacyMapHelper mapHelper) throws XMLStreamException {
        Integer index = null;
        String value = "";
        boolean end = false;
        while (reader.hasNext() && !end) {
            int t = reader.next();
            switch (t) {
                case 1: {
                    String name = reader.getLocalName();
                    if (!ELEMENT_VALUE.equalsIgnoreCase(name)) break;
                    index = Integer.parseInt(reader.getAttributeValue(null, "index"));
                    break;
                }
                case 4: {
                    if (reader.isWhiteSpace() || index == null) break;
                    value = value + reader.getText();
                    break;
                }
                case 2: {
                    if (ELEMENT_NODE_ROW.equalsIgnoreCase(reader.getLocalName()) || ELEMENT_EDGE_ROW.equalsIgnoreCase(reader.getLocalName())) {
                        end = true;
                    }
                    if (!value.isEmpty() && index != null) {
                        Column col;
                        String id;
                        String string = id = table.getElementClass().equals(Node.class) ? mapHelper.nodeIndexToIds.get(index) : mapHelper.edgeIndexToIds.get(index);
                        if (id != null && (col = table.getColumn(id)) != null && !col.isReadOnly()) {
                            try {
                                Object val = AttributeUtils.parse((String)value, (Class)col.getTypeClass());
                                element.setAttribute(col, val);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    value = "";
                    index = null;
                }
            }
        }
    }
}

