/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.Binding;
import org.glassfish.hk2.Context;
import org.glassfish.hk2.Descriptor;
import org.glassfish.hk2.PreDestroy;
import org.glassfish.hk2.Provider;
import org.jvnet.hk2.component.DescriptorImpl;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.RunLevelException;
import org.jvnet.hk2.tracing.TracingThreadLocal;
import org.jvnet.hk2.tracing.TracingUtilities;
import sun.misc.BASE64Decoder;

public abstract class AbstractInhabitantImpl<T>
implements Inhabitant<T>,
Binding<T> {
    protected static final Logger logger = Logger.getLogger(AbstractInhabitantImpl.class.getName());
    private Collection<Inhabitant> companions;
    protected final Descriptor descriptor;

    public AbstractInhabitantImpl(Descriptor descriptorOfSelf) {
        this.descriptor = null == descriptorOfSelf ? null : new DescriptorImpl(descriptorOfSelf, false);
    }

    protected static Descriptor getDescriptorFor(Inhabitant<?> i) {
        if (AbstractInhabitantImpl.class.isInstance(i)) {
            return ((AbstractInhabitantImpl)AbstractInhabitantImpl.class.cast(i)).getDescriptor();
        }
        return null;
    }

    public Provider<T> getProvider(Context ctx) {
        return this;
    }

    public Provider<T> getProvider() {
        return this.getProvider(null);
    }

    public boolean matches(Descriptor matchTo) {
        if (null == matchTo) {
            return true;
        }
        return DescriptorImpl.matches(matchTo, this.descriptor);
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "-" + System.identityHashCode(this) + "(" + this.getDescriptor() + ")\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T get() {
        try {
            Object t;
            if (TracingUtilities.isEnabled()) {
                TracingThreadLocal.get().push(this);
            }
            try {
                t = this.get(this);
            }
            catch (RunLevelException e) {
                logger.log(Level.FINER, "swallowing error", (Throwable)((Object)e));
                T t2 = null;
                if (TracingUtilities.isEnabled()) {
                    TracingThreadLocal.get().pop();
                }
                return t2;
            }
            return t;
        }
        finally {
            if (TracingUtilities.isEnabled()) {
                TracingThreadLocal.get().pop();
            }
        }
    }

    public <U> U getByType(Class<U> type) {
        return (U)this.get();
    }

    @Override
    public <T> T getSerializedMetadata(final Class<T> type, String key) {
        String v = this.metadata().getOne(key);
        if (v == null) {
            return null;
        }
        try {
            ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(new BASE64Decoder().decodeBuffer(v))){
                final ClassLoader cl;
                {
                    super(x0);
                    this.cl = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                        @Override
                        public ClassLoader run() {
                            return type.getClassLoader();
                        }
                    }) : type.getClassLoader();
                }

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String name = desc.getName();
                    try {
                        return Class.forName(name, false, this.cl);
                    }
                    catch (ClassNotFoundException ex) {
                        return super.resolveClass(desc);
                    }
                }
            };
            return type.cast(is.readObject());
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    @Override
    public final <T> T getSerializedMetadata(Class<T> type) {
        return this.getSerializedMetadata(type, type.getName());
    }

    @Override
    public Inhabitant lead() {
        return null;
    }

    @Override
    public final Collection<Inhabitant> companions() {
        if (this.companions == null) {
            return Collections.emptyList();
        }
        return this.companions;
    }

    @Override
    public final void setCompanions(Collection<Inhabitant> companions) {
        this.companions = companions;
    }

    protected final void dispose(T object) {
        if (object instanceof PreDestroy) {
            logger.log(Level.FINER, "calling PreDestroy on {0}", object);
            ((PreDestroy)object).preDestroy();
        }
    }

    public <V extends Annotation> V getAnnotation(Class<V> annotation) {
        return AbstractInhabitantImpl.getAnnotation(this.type(), annotation, false);
    }

    public static <V extends Annotation> V getAnnotation(Class<?> annotated, Class<V> annotation, boolean walkParentChain) {
        V v = annotated.getAnnotation(annotation);
        if (null != v) {
            return v;
        }
        for (Annotation a : annotated.getAnnotations()) {
            v = a.annotationType().getAnnotation(annotation);
            if (null == v) continue;
            return v;
        }
        if (walkParentChain && null != (annotated = annotated.getSuperclass())) {
            return AbstractInhabitantImpl.getAnnotation(annotated, annotation, true);
        }
        return null;
    }

    public Collection<Annotation> getAnnotations() {
        throw new UnsupportedOperationException();
    }
}

