/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.AbstractCreatorImpl;
import com.sun.hk2.component.Hk2ThreadContext;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;

public class ConstructorCreator<T>
extends AbstractCreatorImpl<T> {
    public ConstructorCreator(Class<? extends T> type, Habitat habitat, MultiMap<String, String> metadata) {
        super(type, habitat, metadata);
    }

    @Override
    public T create(Inhabitant onBehalfOf) throws ComponentException {
        try {
            return this.type.newInstance();
        }
        catch (InstantiationException e) {
            throw new ComponentException("Failed to create " + this.type, e);
        }
        catch (IllegalAccessException e) {
            try {
                Constructor ctor = this.type.getDeclaredConstructor(null);
                ctor.setAccessible(true);
                return ctor.newInstance(null);
            }
            catch (Exception exception) {
                throw new ComponentException("Failed to create " + this.type, e);
            }
        }
        catch (LinkageError e) {
            throw new ComponentException("Failed to create " + this.type, e);
        }
        catch (RuntimeException e) {
            throw new ComponentException("Failed to create " + this.type, e);
        }
    }

    @Override
    public void initialize(final T t, final Inhabitant onBehalfOf) throws ComponentException {
        super.initialize(t, onBehalfOf);
        if (this.habitat.isContextualFactoriesPresent()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (System.getSecurityManager() != null) {
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                ConstructorCreator.this.inject(ConstructorCreator.this.habitat, t, onBehalfOf);
                                return null;
                            }
                        });
                    } else {
                        ConstructorCreator.this.inject(ConstructorCreator.this.habitat, t, onBehalfOf);
                    }
                }
            };
            Hk2ThreadContext.captureACCandRun(runnable);
        } else if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ConstructorCreator.this.inject(ConstructorCreator.this.habitat, t, onBehalfOf);
                    return null;
                }
            });
        } else {
            this.inject(this.habitat, t, onBehalfOf);
        }
    }
}

