/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component.classmodel;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.classmodel.ClassPath;
import org.jvnet.hk2.component.classmodel.ClassPathAdvisor;

public class FileCachingClassPathAdvisor
implements ClassPathAdvisor {
    private final Logger logger = Logger.getLogger(FileCachingClassPathAdvisor.class.getName());
    public static final String TAG_SYS_PROP = "classpathadvisor.cache.file";
    public static final String HK2_CLASS_PATH_ADVISOR_CACHE_FILE = ".hk2ClassPathAdvisorCache.properties";
    private final String defaultCacheFileName = new File(System.getProperty("java.io.tmpdir"), ".hk2ClassPathAdvisorCache.properties").toString();
    private final String cacheFileName;
    private final File cacheFile;
    private Properties cache;

    public FileCachingClassPathAdvisor() {
        this.cacheFileName = System.getProperty(TAG_SYS_PROP, this.defaultCacheFileName);
        this.cacheFile = new File(this.cacheFileName);
    }

    public FileCachingClassPathAdvisor(String cacheFileName) {
        this.cacheFileName = cacheFileName;
        this.cacheFile = new File(cacheFileName);
    }

    @Override
    public void starting(ClassPath inhabitantsClassPath) {
        this.logger.log(Level.INFO, "reading cache {0}", this.cacheFileName);
        this.cache = new Properties();
        if (this.cacheFile.exists()) {
            try {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.cacheFile));
                this.cache.load(is);
                ((InputStream)is).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void finishing(Set<URI> significant, Set<URI> insignificant) {
        String key;
        String oldVal;
        String newVal;
        File file;
        this.logger.log(Level.INFO, "Non-Contributing URIs are: {0}", insignificant);
        this.logger.log(Level.INFO, "Contributing URIs are: {0}", significant);
        boolean dirty = false;
        for (URI uri : insignificant) {
            file = new File(uri);
            if (!file.exists() || file.isDirectory()) continue;
            newVal = this.entryFor(uri, false);
            dirty |= !newVal.equals(oldVal = (String)this.cache.put(key = uri.toString().toLowerCase(), newVal));
            this.logger.log(Level.FINE, "putting: {0} with {1}; oldVal was {2}", new Object[]{key, newVal, oldVal});
        }
        for (URI uri : significant) {
            file = new File(uri);
            if (!file.exists() || file.isDirectory()) continue;
            newVal = this.entryFor(uri, true);
            dirty |= !newVal.equals(oldVal = (String)this.cache.put(key = uri.toString().toLowerCase(), newVal));
            this.logger.log(Level.FINE, "putting: {0} with {1}; oldVal was {2}", new Object[]{key, newVal, oldVal});
        }
        if (dirty) {
            this.logger.log(Level.INFO, "writing cache {0}", this.cacheFile);
            try {
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.cacheFile));
                this.cache.store(os, null);
                ((OutputStream)os).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String entryFor(URI uri, boolean significant) {
        StringBuilder sb = new StringBuilder();
        sb.append(significant ? "1" : "0").append(",");
        File file = new File(uri);
        if (file.exists()) {
            sb.append(file.lastModified()).append(",").append(file.length());
        } else {
            sb.append("-1").append(",").append("-1");
        }
        return sb.toString();
    }

    @Override
    public boolean accept(File file) {
        assert (null != this.cache);
        URI uri = file.toURI();
        String cachedVal = this.cache.getProperty(uri.toString().toLowerCase());
        if (null != cachedVal) {
            String compareSig = cachedVal.substring(0, 1);
            boolean significant = compareSig.equals("1");
            String compareVal = this.entryFor(uri, significant);
            if (compareVal.equals(cachedVal)) {
                this.logger.log(Level.FINE, "cache for {0} indicates significance val {1}", new Object[]{uri, compareSig});
                return significant;
            }
            this.logger.log(Level.FINE, "cache is dirty for {0}", uri);
            return true;
        }
        this.logger.log(Level.FINE, "cache does not contain {0}", uri);
        return true;
    }
}

