/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.metadata.generator;

import jakarta.inject.Named;
import jakarta.inject.Qualifier;
import jakarta.inject.Scope;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.Metadata;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ProxyForSameScope;
import org.glassfish.hk2.api.Rank;
import org.glassfish.hk2.api.UseProxy;
import org.glassfish.hk2.api.Visibility;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

public class ServiceUtilities {
    public static List<DescriptorImpl> getDescriptorsFromClass(TypeElement clazz, ProcessingEnvironment processingEnvironment) {
        if (clazz == null || !ElementKind.CLASS.equals((Object)clazz.getKind())) {
            return Collections.emptyList();
        }
        Elements elements = processingEnvironment.getElementUtils();
        Set<Modifier> modifiers = clazz.getModifiers();
        if (modifiers.contains((Object)Modifier.ABSTRACT)) {
            throw new IllegalArgumentException("The class " + elements.getBinaryName(clazz) + " is abstract.  @Service may only be put on concrete classes");
        }
        Set<String> contracts = ServiceUtilities.getAllContracts(clazz, processingEnvironment);
        if (contracts.contains(Factory.class.getName())) {
            return ServiceUtilities.getDescriptorFromFactoryClass(clazz, contracts, processingEnvironment);
        }
        DescriptorImpl retVal = new DescriptorImpl();
        retVal.setImplementation(ServiceUtilities.nameToString(elements.getBinaryName(clazz)));
        ServiceUtilities.generateFromClass(retVal, clazz, contracts, processingEnvironment);
        return Collections.singletonList(retVal);
    }

    private static List<DescriptorImpl> getDescriptorFromFactoryClass(TypeElement clazz, Set<String> contracts, ProcessingEnvironment processingEnvironment) {
        TypeElement methodReturnElement;
        LinkedList<DescriptorImpl> retVal = new LinkedList<DescriptorImpl>();
        Elements elements = processingEnvironment.getElementUtils();
        DescriptorImpl factoryItself = new DescriptorImpl();
        factoryItself.setImplementation(ServiceUtilities.nameToString(elements.getBinaryName(clazz)));
        ServiceUtilities.generateFromClass(factoryItself, clazz, contracts, processingEnvironment);
        retVal.add(factoryItself);
        ExecutableElement provideMethodEE = null;
        for (Element element : processingEnvironment.getElementUtils().getAllMembers(clazz)) {
            ExecutableElement executable;
            if (!ElementKind.METHOD.equals((Object)element.getKind()) || !"provide".equals(ServiceUtilities.nameToString((executable = (ExecutableElement)element).getSimpleName()))) continue;
            provideMethodEE = executable;
            break;
        }
        if (provideMethodEE == null) {
            return retVal;
        }
        TypeMirror methodReturnMirror = provideMethodEE.getReturnType();
        Element element = processingEnvironment.getTypeUtils().asElement(methodReturnMirror);
        if (element instanceof TypeElement) {
            methodReturnElement = (TypeElement)element;
        } else if (element instanceof TypeParameterElement) {
            methodReturnElement = ServiceUtilities.findFactory(clazz, clazz, null, null, processingEnvironment);
        } else {
            throw new AssertionError((Object)("Unknown type for provide method: " + element));
        }
        DescriptorImpl provideDescriptor = new DescriptorImpl();
        provideDescriptor.setDescriptorType(DescriptorType.PROVIDE_METHOD);
        provideDescriptor.setImplementation(ServiceUtilities.nameToString(elements.getBinaryName(clazz)));
        Set<String> methodContracts = ServiceUtilities.getAllContracts(methodReturnElement, processingEnvironment);
        for (String methodContract : methodContracts) {
            provideDescriptor.addAdvertisedContract(methodContract);
        }
        ServiceUtilities.generateFromClass(provideDescriptor, provideMethodEE, methodContracts, processingEnvironment);
        retVal.add(provideDescriptor);
        return retVal;
    }

    private static TypeElement findFactory(TypeElement originalClazz, TypeElement clazz, List<? extends TypeMirror> hardenedClassTypes, Map<Name, TypeMirror> classTypeMap, ProcessingEnvironment environment) {
        List<? extends TypeMirror> superClassDeclaredTypes;
        Elements elements = environment.getElementUtils();
        for (TypeMirror typeMirror : clazz.getInterfaces()) {
            DeclaredType dtIFace;
            Iterator<? extends TypeMirror> iterator;
            TypeElement iFaceElement = (TypeElement)environment.getTypeUtils().asElement(typeMirror);
            String iFaceQualifiedName = ServiceUtilities.nameToString(elements.getBinaryName(iFaceElement));
            if (!Factory.class.getName().equals(iFaceQualifiedName) || !(iterator = (dtIFace = (DeclaredType)typeMirror).getTypeArguments().iterator()).hasNext()) continue;
            TypeMirror typeMirror2 = iterator.next();
            Element element = environment.getTypeUtils().asElement(typeMirror2);
            if (element instanceof TypeElement) {
                return (TypeElement)element;
            }
            if (hardenedClassTypes == null) {
                throw new AssertionError((Object)("Error analyzing " + originalClazz + ": Unspecified generic type of Factory in " + clazz + " interface " + typeMirror));
            }
            if (!(element instanceof TypeParameterElement)) {
                throw new AssertionError((Object)("Error analyzing " + originalClazz + ": Unknown generic type of Factory: " + (Object)((Object)element.getKind()) + " of element " + element));
            }
            TypeParameterElement tpe = (TypeParameterElement)element;
            boolean found = false;
            int count = 0;
            for (TypeParameterElement typeParameterElement : clazz.getTypeParameters()) {
                if (tpe.equals(typeParameterElement)) {
                    found = true;
                    break;
                }
                ++count;
            }
            if (!found) {
                throw new AssertionError((Object)("Error analyzing " + originalClazz + ":  Internal error: mismatch between candidates (" + clazz.getTypeParameters() + ") and subclass (" + hardenedClassTypes + ")"));
            }
            TypeMirror transposedMirror = hardenedClassTypes.get(count);
            Element element2 = environment.getTypeUtils().asElement(transposedMirror);
            if (!(element2 instanceof TypeElement)) {
                throw new AssertionError((Object)("Error analyzing " + originalClazz + ": Factory type not specified fully, cannot analyze " + clazz + " interface " + typeMirror + " type " + element2));
            }
            return (TypeElement)element2;
        }
        DeclaredType superClassDeclaredType = (DeclaredType)clazz.getSuperclass();
        TypeElement typeElement = (TypeElement)environment.getTypeUtils().asElement(superClassDeclaredType);
        List<? extends TypeMirror> hardenedList = superClassDeclaredTypes = superClassDeclaredType.getTypeArguments();
        if (hardenedClassTypes != null) {
            ArrayList<? extends TypeMirror> translatedList = new ArrayList<TypeMirror>(superClassDeclaredTypes.size());
            for (TypeMirror typeMirror : superClassDeclaredType.getTypeArguments()) {
                Name name = environment.getTypeUtils().asElement(typeMirror).getSimpleName();
                TypeMirror replacement = classTypeMap.get(name);
                if (replacement == null) {
                    translatedList.add(typeMirror);
                    continue;
                }
                translatedList.add(replacement);
            }
            hardenedList = translatedList;
        }
        LinkedHashMap<Name, TypeMirror> typeMap = new LinkedHashMap<Name, TypeMirror>();
        int position = 0;
        for (TypeParameterElement typeParameterElement : typeElement.getTypeParameters()) {
            typeMap.put(typeParameterElement.getSimpleName(), hardenedList.get(position));
            ++position;
        }
        return ServiceUtilities.findFactory(originalClazz, typeElement, hardenedList, typeMap, environment);
    }

    private static void generateFromClass(DescriptorImpl retVal, Element clazz, Set<String> contracts, ProcessingEnvironment processingEnvironment) {
        for (String contract : contracts) {
            retVal.addAdvertisedContract(contract);
        }
        LinkedHashMap<String, List<String>> metadata = new LinkedHashMap<String, List<String>>();
        retVal.setScope(ServiceUtilities.getScope(clazz, metadata, processingEnvironment));
        String name = ServiceUtilities.getName(clazz, processingEnvironment);
        if (name != null) {
            retVal.setName(name);
        }
        for (String qualifier : ServiceUtilities.getAllQualifiers(clazz, metadata, processingEnvironment)) {
            retVal.addQualifier(qualifier);
        }
        retVal.setDescriptorVisibility(ServiceUtilities.getVisibility(clazz, processingEnvironment));
        retVal.setRanking(ServiceUtilities.getRank(clazz, processingEnvironment));
        retVal.setProxiable(ServiceUtilities.getUseProxy(clazz, processingEnvironment));
        retVal.setProxyForSameScope(ServiceUtilities.getProxyForSameScope(clazz, processingEnvironment));
        String analyzer = ServiceUtilities.getAnalyzer(clazz, processingEnvironment);
        if (analyzer != null) {
            retVal.setClassAnalysisName(analyzer);
        }
        ServiceUtilities.getServiceMetadata(clazz, metadata, processingEnvironment);
        retVal.setMetadata(metadata);
    }

    private static String getScope(Element clazz, LinkedHashMap<String, List<String>> metadata, ProcessingEnvironment processingEnv) {
        List<? extends AnnotationMirror> annotationMirrors = clazz.getAnnotationMirrors();
        Elements elements = processingEnv.getElementUtils();
        String foundScope = null;
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            DeclaredType dt = annotationMirror.getAnnotationType();
            TypeElement annotationType = (TypeElement)dt.asElement();
            if (annotationType.getAnnotation(Scope.class) == null) continue;
            if (foundScope != null) {
                String qName = "provide";
                if (clazz instanceof TypeElement) {
                    qName = ServiceUtilities.nameToString(elements.getBinaryName((TypeElement)clazz));
                }
                throw new AssertionError((Object)("A service with implementation " + qName + " has at least two scopes: " + foundScope + " and " + elements.getBinaryName(annotationType)));
            }
            foundScope = ServiceUtilities.nameToString(elements.getBinaryName(annotationType));
            ServiceUtilities.getMetadataFromAnnotation(annotationMirror, annotationType, metadata, processingEnv);
        }
        if (foundScope != null) {
            return foundScope;
        }
        if (clazz instanceof ExecutableElement) {
            return PerLookup.class.getName();
        }
        return Singleton.class.getName();
    }

    private static String getName(Element clazz, ProcessingEnvironment processingEnvironment) {
        if (clazz.getAnnotation(Named.class) != null) {
            AnnotationMirror namedMirror = ServiceUtilities.getAnnotation(clazz, Named.class.getName(), processingEnvironment);
            AnnotationValue namedValue = ServiceUtilities.getValueFromAnnotation(namedMirror, processingEnvironment);
            String value = (String)namedValue.getValue();
            if ("".equals(value)) {
                if (clazz instanceof ExecutableElement) {
                    throw new AssertionError((Object)("A provide method is annotated with @Named but in Factory " + clazz.getEnclosingElement()));
                }
                return ServiceUtilities.nameToString(clazz.getSimpleName());
            }
            return value;
        }
        AnnotationMirror serviceMirror = ServiceUtilities.getAnnotation(clazz, Service.class.getName(), processingEnvironment);
        if (serviceMirror == null) {
            return null;
        }
        AnnotationValue serviceValue = ServiceUtilities.getValueFromAnnotation(serviceMirror, "name", processingEnvironment);
        String value = (String)serviceValue.getValue();
        if ("".equals(value)) {
            return null;
        }
        return value;
    }

    private static Set<String> getAllQualifiers(Element clazz, LinkedHashMap<String, List<String>> metadata, ProcessingEnvironment processingEnv) {
        LinkedHashSet<String> retVal = new LinkedHashSet<String>();
        Elements elements = processingEnv.getElementUtils();
        List<? extends AnnotationMirror> annotations = clazz.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            DeclaredType dt = annotationMirror.getAnnotationType();
            TypeElement dtElement = (TypeElement)dt.asElement();
            if (dtElement.getAnnotation(Qualifier.class) == null) continue;
            retVal.add(ServiceUtilities.nameToString(elements.getBinaryName(dtElement)));
            ServiceUtilities.getMetadataFromAnnotation(annotationMirror, dtElement, metadata, processingEnv);
        }
        return retVal;
    }

    private static DescriptorVisibility getVisibility(Element clazz, ProcessingEnvironment processingEnv) {
        AnnotationMirror mirror = ServiceUtilities.getAnnotation(clazz, Visibility.class.getName(), processingEnv);
        if (mirror == null) {
            return DescriptorVisibility.NORMAL;
        }
        AnnotationValue annoValue = ServiceUtilities.getValueFromAnnotation(mirror, processingEnv);
        if (annoValue == null) {
            return DescriptorVisibility.NORMAL;
        }
        VariableElement enumValue = (VariableElement)annoValue.getValue();
        String simpleName = ServiceUtilities.nameToString(enumValue.getSimpleName());
        if (simpleName == null) {
            return DescriptorVisibility.NORMAL;
        }
        if ("LOCAL".equals(simpleName)) {
            return DescriptorVisibility.LOCAL;
        }
        return DescriptorVisibility.NORMAL;
    }

    private static int getRank(Element clazz, ProcessingEnvironment processingEnv) {
        AnnotationMirror mirror = ServiceUtilities.getAnnotation(clazz, Rank.class.getName(), processingEnv);
        if (mirror == null) {
            TypeElement typeClazz;
            TypeMirror mirrorSuper;
            if (ElementKind.CLASS.equals((Object)clazz.getKind()) && (mirrorSuper = (typeClazz = (TypeElement)clazz).getSuperclass()) != null) {
                Element elementSuper = processingEnv.getTypeUtils().asElement(mirrorSuper);
                if (elementSuper == null) {
                    return 0;
                }
                return ServiceUtilities.getRank(elementSuper, processingEnv);
            }
            return 0;
        }
        AnnotationValue annoValue = ServiceUtilities.getValueFromAnnotation(mirror, processingEnv);
        if (annoValue == null) {
            return 0;
        }
        Integer r = (Integer)annoValue.getValue();
        return r;
    }

    private static Boolean getUseProxy(Element clazz, ProcessingEnvironment processingEnv) {
        AnnotationMirror mirror = ServiceUtilities.getAnnotation(clazz, UseProxy.class.getName(), processingEnv);
        if (mirror == null) {
            return null;
        }
        AnnotationValue annoValue = ServiceUtilities.getValueFromAnnotation(mirror, processingEnv);
        if (annoValue == null) {
            return null;
        }
        return (Boolean)annoValue.getValue();
    }

    private static Boolean getProxyForSameScope(Element clazz, ProcessingEnvironment processingEnv) {
        AnnotationMirror mirror = ServiceUtilities.getAnnotation(clazz, ProxyForSameScope.class.getName(), processingEnv);
        if (mirror == null) {
            return null;
        }
        AnnotationValue annoValue = ServiceUtilities.getValueFromAnnotation(mirror, processingEnv);
        if (annoValue == null) {
            return null;
        }
        return (Boolean)annoValue.getValue();
    }

    private static String getAnalyzer(Element clazz, ProcessingEnvironment processingEnv) {
        AnnotationMirror mirror = ServiceUtilities.getAnnotation(clazz, Service.class.getName(), processingEnv);
        if (mirror == null) {
            return null;
        }
        AnnotationValue annoValue = ServiceUtilities.getValueFromAnnotation(mirror, "analyzer", processingEnv);
        if (annoValue == null) {
            return null;
        }
        String retVal = (String)annoValue.getValue();
        if ("default".equals(retVal)) {
            return null;
        }
        return retVal;
    }

    private static void getServiceMetadata(Element clazz, Map<String, List<String>> metadata, ProcessingEnvironment processingEnv) {
        AnnotationMirror mirror = ServiceUtilities.getAnnotation(clazz, Service.class.getName(), processingEnv);
        if (mirror == null) {
            return;
        }
        AnnotationValue annoValue = ServiceUtilities.getValueFromAnnotation(mirror, "metadata", processingEnv);
        if (annoValue == null) {
            return;
        }
        String retVal = (String)annoValue.getValue();
        if ("".equals(retVal)) {
            return;
        }
        ReflectionHelper.parseServiceMetadataString((String)retVal, metadata);
    }

    private static Set<String> getAllContracts(TypeElement clazz, ProcessingEnvironment processingEnvironment) {
        if (clazz == null) {
            return Collections.emptySet();
        }
        Elements elements = processingEnvironment.getElementUtils();
        ContractsProvided provided = clazz.getAnnotation(ContractsProvided.class);
        if (provided != null) {
            LinkedHashSet<String> retVal = new LinkedHashSet<String>();
            AnnotationMirror contractsProvided = ServiceUtilities.getAnnotation(clazz, ContractsProvided.class.getName(), processingEnvironment);
            AnnotationValue annoValue = ServiceUtilities.getValueFromAnnotation(contractsProvided, processingEnvironment);
            List arrayValues = (List)annoValue.getValue();
            for (AnnotationValue providedValues : arrayValues) {
                TypeMirror providedMirror = (TypeMirror)providedValues.getValue();
                TypeElement providedElement = (TypeElement)processingEnvironment.getTypeUtils().asElement(providedMirror);
                retVal.add(ServiceUtilities.nameToString(elements.getBinaryName(providedElement)));
            }
            return retVal;
        }
        LinkedHashSet<String> retVal = new LinkedHashSet<String>();
        retVal.add(ServiceUtilities.nameToString(elements.getBinaryName(clazz)));
        ServiceUtilities.getAllSubContracts(clazz, processingEnvironment, retVal, new LinkedHashSet<String>());
        return retVal;
    }

    private static void getAllSubContracts(TypeElement clazz, ProcessingEnvironment processingEnvironment, LinkedHashSet<String> contracts, LinkedHashSet<String> cycleDetector) {
        Elements elements = processingEnvironment.getElementUtils();
        if (clazz == null || ServiceUtilities.nameToString(elements.getBinaryName(clazz)).equals(Object.class.getName())) {
            return;
        }
        if (cycleDetector.contains(ServiceUtilities.nameToString(elements.getBinaryName(clazz)))) {
            return;
        }
        cycleDetector.add(ServiceUtilities.nameToString(elements.getBinaryName(clazz)));
        List<? extends TypeMirror> interfaceMirrors = clazz.getInterfaces();
        for (TypeMirror typeMirror : interfaceMirrors) {
            TypeElement iFace = (TypeElement)processingEnvironment.getTypeUtils().asElement(typeMirror);
            if (ServiceUtilities.isAContract(iFace)) {
                contracts.add(ServiceUtilities.nameToString(elements.getBinaryName(iFace)));
            }
            ServiceUtilities.getAllSubContracts(iFace, processingEnvironment, contracts, cycleDetector);
        }
        TypeMirror superClazzMirror = clazz.getSuperclass();
        if (superClazzMirror != null) {
            TypeElement typeElement = (TypeElement)processingEnvironment.getTypeUtils().asElement(superClazzMirror);
            if (ServiceUtilities.isAContract(typeElement)) {
                contracts.add(ServiceUtilities.nameToString(elements.getBinaryName(typeElement)));
            }
            ServiceUtilities.getAllSubContracts(typeElement, processingEnvironment, contracts, cycleDetector);
        }
    }

    private static void getMetadataFromAnnotation(AnnotationMirror annotation, TypeElement annotationType, LinkedHashMap<String, List<String>> metadata, ProcessingEnvironment processingEnvironment) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> methods = annotation.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : methods.entrySet()) {
            String metadataKey;
            AnnotationValue metadataAnnotationKey;
            ExecutableElement ee = entry.getKey();
            AnnotationMirror metadataMirror = ServiceUtilities.getAnnotation(ee, Metadata.class.getName(), processingEnvironment);
            if (metadataMirror == null || (metadataAnnotationKey = ServiceUtilities.getValueFromAnnotation(metadataMirror, processingEnvironment)) == null || (metadataKey = (String)metadataAnnotationKey.getValue()) == null) continue;
            AnnotationValue methodAnnotationValue = entry.getValue();
            Object methodObjectValue = methodAnnotationValue.getValue();
            if (methodObjectValue instanceof List) {
                List annoList = (List)methodObjectValue;
                for (AnnotationValue annoListValue : annoList) {
                    Object aValue = annoListValue.getValue();
                    ServiceUtilities.addToMetadataMap(metadataKey, aValue.toString(), metadata);
                }
                continue;
            }
            ServiceUtilities.addToMetadataMap(metadataKey, methodObjectValue.toString(), metadata);
        }
    }

    private static void addToMetadataMap(String key, String value, Map<String, List<String>> metadata) {
        List<String> values = metadata.get(key);
        if (values == null) {
            values = new LinkedList<String>();
            metadata.put(key, values);
        }
        values.add(value);
    }

    private static boolean isAContract(TypeElement element) {
        if (element == null) {
            return false;
        }
        Contract contract = element.getAnnotation(Contract.class);
        return contract != null;
    }

    public static String nameToString(Name name) {
        if (name == null) {
            return null;
        }
        return name.toString();
    }

    private static AnnotationMirror getAnnotation(Element clazz, String clazzName, ProcessingEnvironment processingEnv) {
        Elements elements = processingEnv.getElementUtils();
        List<? extends AnnotationMirror> annotationMirrors = clazz.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            DeclaredType dt = annotationMirror.getAnnotationType();
            TypeElement dtElement = (TypeElement)dt.asElement();
            if (!clazzName.equals(ServiceUtilities.nameToString(elements.getBinaryName(dtElement)))) continue;
            return annotationMirror;
        }
        return null;
    }

    private static AnnotationValue getValueFromAnnotation(AnnotationMirror annotation, String methodName, ProcessingEnvironment processingEnv) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = processingEnv.getElementUtils().getElementValuesWithDefaults(annotation);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entries : values.entrySet()) {
            ExecutableElement executable = entries.getKey();
            AnnotationValue annoValue = entries.getValue();
            if (!methodName.equals(ServiceUtilities.nameToString(executable.getSimpleName()))) continue;
            return annoValue;
        }
        return null;
    }

    private static AnnotationValue getValueFromAnnotation(AnnotationMirror annotation, ProcessingEnvironment processingEnv) {
        return ServiceUtilities.getValueFromAnnotation(annotation, "value", processingEnv);
    }
}

