/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.spring;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceHandle;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;

@Singleton
public class AutowiredInjectResolver
implements InjectionResolver<Autowired> {
    private static final Logger LOGGER = Logger.getLogger(AutowiredInjectResolver.class.getName());
    private volatile ApplicationContext ctx;

    public AutowiredInjectResolver(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public Object resolve(Injectee injectee, ServiceHandle<?> root) {
        Qualifier an;
        AnnotatedElement parent = injectee.getParent();
        String beanName = null;
        if (parent != null && (an = parent.getAnnotation(Qualifier.class)) != null) {
            beanName = an.value();
        }
        return this.getBeanFromSpringContext(beanName, injectee);
    }

    private Object getBeanFromSpringContext(String beanName, Injectee injectee) {
        try {
            DependencyDescriptor dependencyDescriptor = this.createSpringDependencyDescriptor(injectee);
            HashSet<String> autowiredBeanNames = new HashSet<String>(1);
            autowiredBeanNames.add(beanName);
            return this.ctx.getAutowireCapableBeanFactory().resolveDependency(dependencyDescriptor, null, autowiredBeanNames, null);
        }
        catch (NoSuchBeanDefinitionException e) {
            LOGGER.warning(e.getMessage());
            throw e;
        }
    }

    private DependencyDescriptor createSpringDependencyDescriptor(Injectee injectee) {
        AnnotatedElement annotatedElement = injectee.getParent();
        if (annotatedElement.getClass().isAssignableFrom(Field.class)) {
            return new DependencyDescriptor((Field)annotatedElement, !injectee.isOptional());
        }
        return new DependencyDescriptor(new MethodParameter((Constructor)annotatedElement, injectee.getPosition()), !injectee.isOptional());
    }

    public boolean isConstructorParameterIndicator() {
        return false;
    }

    public boolean isMethodParameterIndicator() {
        return false;
    }
}

