/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.spring;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.hk2.utilities.binding.BindingBuilder;
import org.glassfish.hk2.utilities.binding.ServiceBindingBuilder;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.spi.ComponentProvider;
import org.glassfish.jersey.server.spring.AutowiredInjectResolver;
import org.glassfish.jersey.server.spring.LocalizationMessages;
import org.jvnet.hk2.spring.bridge.api.SpringBridge;
import org.jvnet.hk2.spring.bridge.api.SpringIntoHK2Bridge;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringComponentProvider
implements ComponentProvider {
    private static final Logger LOGGER = Logger.getLogger(SpringComponentProvider.class.getName());
    private static final String DEFAULT_CONTEXT_CONFIG_LOCATION = "applicationContext.xml";
    private static final String PARAM_CONTEXT_CONFIG_LOCATION = "contextConfigLocation";
    private static final String PARAM_SPRING_CONTEXT = "contextConfig";
    private volatile ServiceLocator locator;
    private volatile ApplicationContext ctx;

    public void initialize(ServiceLocator locator) {
        ServletContext sc;
        this.locator = locator;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(LocalizationMessages.CTX_LOOKUP_STARTED());
        }
        this.ctx = (sc = (ServletContext)locator.getService(ServletContext.class, new Annotation[0])) != null ? WebApplicationContextUtils.getWebApplicationContext((ServletContext)sc) : this.createSpringContext();
        if (this.ctx == null) {
            LOGGER.severe(LocalizationMessages.CTX_LOOKUP_FAILED());
            return;
        }
        LOGGER.config(LocalizationMessages.CTX_LOOKUP_SUCESSFUL());
        SpringBridge.getSpringBridge().initializeSpringBridge(locator);
        SpringIntoHK2Bridge springBridge = (SpringIntoHK2Bridge)locator.getService(SpringIntoHK2Bridge.class, new Annotation[0]);
        springBridge.bridgeSpringBeanFactory((BeanFactory)this.ctx);
        ServiceLocatorUtilities.addOneConstant((ServiceLocator)locator, (Object)new AutowiredInjectResolver(this.ctx));
        ServiceLocatorUtilities.addOneConstant((ServiceLocator)locator, (Object)this.ctx, (String)"SpringContext", (Type[])new Type[]{ApplicationContext.class});
        LOGGER.config(LocalizationMessages.SPRING_COMPONENT_PROVIDER_INITIALIZED());
    }

    public boolean bind(Class<?> component, Set<Class<?>> providerContracts) {
        if (this.ctx == null) {
            return false;
        }
        if (AnnotationUtils.findAnnotation(component, Component.class) != null) {
            DynamicConfiguration c = Injections.getConfiguration((ServiceLocator)this.locator);
            String[] beanNames = this.ctx.getBeanNamesForType(component);
            if (beanNames == null || beanNames.length != 1) {
                LOGGER.severe(LocalizationMessages.NONE_OR_MULTIPLE_BEANS_AVAILABLE(component));
                return false;
            }
            String beanName = beanNames[0];
            ServiceBindingBuilder bb = Injections.newFactoryBinder((Factory)new SpringManagedBeanFactory(this.ctx, this.locator, beanName));
            bb.to(component);
            if (providerContracts != null) {
                for (Class<?> providerContract : providerContracts) {
                    bb.to(providerContract);
                }
            }
            Injections.addBinding((BindingBuilder)bb, (DynamicConfiguration)c);
            c.commit();
            LOGGER.config(LocalizationMessages.BEAN_REGISTERED(beanName));
            return true;
        }
        return false;
    }

    public void done() {
    }

    private ApplicationContext createSpringContext() {
        ApplicationHandler applicationHandler = (ApplicationHandler)this.locator.getService(ApplicationHandler.class, new Annotation[0]);
        ApplicationContext springContext = (ApplicationContext)applicationHandler.getConfiguration().getProperty(PARAM_SPRING_CONTEXT);
        if (springContext == null) {
            String contextConfigLocation = (String)applicationHandler.getConfiguration().getProperty(PARAM_CONTEXT_CONFIG_LOCATION);
            springContext = this.createXmlSpringConfiguration(contextConfigLocation);
        }
        return springContext;
    }

    private ApplicationContext createXmlSpringConfiguration(String contextConfigLocation) {
        if (contextConfigLocation == null) {
            contextConfigLocation = DEFAULT_CONTEXT_CONFIG_LOCATION;
        }
        this.ctx = new ClassPathXmlApplicationContext(new String[]{contextConfigLocation, "jersey-spring-applicationContext.xml"});
        return this.ctx;
    }

    private static class SpringManagedBeanFactory
    implements Factory {
        private final ApplicationContext ctx;
        private final ServiceLocator locator;
        private final String beanName;

        private SpringManagedBeanFactory(ApplicationContext ctx, ServiceLocator locator, String beanName) {
            this.ctx = ctx;
            this.locator = locator;
            this.beanName = beanName;
        }

        public Object provide() {
            Object bean = this.ctx.getBean(this.beanName);
            this.locator.inject(bean);
            return bean;
        }

        public void dispose(Object instance) {
        }
    }
}

