/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.istack.FinalArrayList;
import com.sun.xml.bind.api.Bridge;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBufferException;
import com.sun.xml.stream.buffer.XMLStreamBufferMark;
import com.sun.xml.stream.buffer.XMLStreamBufferSource;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferCreator;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.message.AbstractHeaderImpl;
import com.sun.xml.ws.message.Util;
import com.sun.xml.ws.security.opt.api.NamespaceContextInfo;
import com.sun.xml.ws.security.opt.api.SecuredHeader;
import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.ws.security.opt.impl.util.XMLStreamReaderFactory;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSecuredHeader
extends AbstractHeaderImpl
implements SecuredHeader,
NamespaceContextInfo {
    private static final String SOAP_1_1_MUST_UNDERSTAND = "mustUnderstand";
    private static final String SOAP_1_2_MUST_UNDERSTAND = "mustUnderstand";
    private static final String SOAP_1_1_ROLE = "actor";
    private static final String SOAP_1_2_ROLE = "role";
    private static final String SOAP_1_2_RELAY = "relay";
    private XMLStreamBuffer completeHeader;
    private boolean isMustUnderstand;
    private SOAPVersion soapVersion = null;
    private Vector idValues = new Vector(2);
    private HashMap<String, String> shNSDecls = new HashMap();
    private HashMap<String, String> nsDecls = null;
    private String role;
    private boolean isRelay;
    private String localName;
    private String namespaceURI = "";
    private String id = "";
    private final FinalArrayList<Attribute> attributes;
    private boolean hasED = false;

    public GenericSecuredHeader(XMLStreamReader reader, SOAPVersion soapVersion, StreamReaderBufferCreator creator, HashMap nsDecl, XMLInputFactory staxIF, boolean encHeaderContent) throws XMLStreamBufferException, XMLStreamException {
        this.shNSDecls = nsDecl;
        this.soapVersion = soapVersion;
        if (reader.getNamespaceURI() != null) {
            this.namespaceURI = reader.getNamespaceURI();
        }
        this.localName = reader.getLocalName();
        this.attributes = this.processHeaderAttributes(reader);
        this.completeHeader = new XMLStreamBufferMark(this.nsDecls, creator);
        creator.createElementFragment(XMLStreamReaderFactory.createFilteredXMLStreamReader(reader, new IDProcessor()), true);
        this.nsDecls.putAll(this.shNSDecls);
        if (this.id.length() > 0) {
            this.idValues.add(this.id);
        }
        if (encHeaderContent) {
            this.checkEncryptedData();
        }
    }

    public boolean hasEncData() {
        return this.hasED;
    }

    private void checkEncryptedData() throws XMLStreamException {
        XMLStreamReader reader = this.readHeader();
        while (StreamUtil.moveToNextElement(reader)) {
            if (!"EncryptedData".equals(reader.getLocalName()) || !"http://www.w3.org/2001/04/xmlenc#".equals(reader.getNamespaceURI())) continue;
            this.hasED = true;
            String encId = reader.getAttributeValue(null, "Id");
            if (encId == null || encId.length() <= 0) break;
            this.idValues.add(encId);
            break;
        }
    }

    private FinalArrayList<Attribute> processHeaderAttributes(XMLStreamReader reader) {
        if (this.soapVersion == SOAPVersion.SOAP_11) {
            return this.process11Header(reader);
        }
        return this.process12Header(reader);
    }

    private FinalArrayList<Attribute> process12Header(XMLStreamReader reader) {
        int i;
        FinalArrayList atts = null;
        this.role = this.soapVersion.implicitRole;
        this.nsDecls = new HashMap();
        this.nsDecls = new HashMap();
        if (reader.getNamespaceCount() > 0) {
            for (i = 0; i < reader.getNamespaceCount(); ++i) {
                this.nsDecls.put(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
            }
        }
        for (i = 0; i < reader.getAttributeCount(); ++i) {
            String lName = reader.getAttributeLocalName(i);
            String nsURI = reader.getAttributeNamespace(i);
            String value = reader.getAttributeValue(i);
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".equals(nsURI) && "Id".intern().equals(lName)) {
                this.id = value;
            } else if (nsURI == null && "Id".intern().equals(lName)) {
                this.id = value;
            }
            if ("http://schemas.xmlsoap.org/soap/envelope/".equals(nsURI)) {
                if ("mustUnderstand".equals(lName)) {
                    this.isMustUnderstand = Util.parseBool(value);
                } else if (SOAP_1_1_ROLE.equals(lName) && value != null && value.length() > 0) {
                    this.role = value;
                }
            }
            if (atts == null) {
                atts = new FinalArrayList();
            }
            atts.add((Object)new Attribute(nsURI, lName, value));
        }
        return atts;
    }

    private final FinalArrayList<Attribute> process11Header(XMLStreamReader reader) {
        FinalArrayList atts = null;
        this.role = this.soapVersion.implicitRole;
        this.nsDecls = new HashMap();
        if (reader.getNamespaceCount() > 0) {
            for (int j = 0; j < reader.getNamespaceCount(); ++j) {
                this.nsDecls.put(reader.getNamespacePrefix(j), reader.getNamespaceURI(j));
            }
        }
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String lName = reader.getAttributeLocalName(i);
            String nsURI = reader.getAttributeNamespace(i);
            String value = reader.getAttributeValue(i);
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".equals(nsURI) && "Id".intern().equals(lName)) {
                this.id = value;
            } else if (nsURI == null && "Id".intern().equals(lName)) {
                this.id = value;
            }
            if ("http://www.w3.org/2003/05/soap-envelope".equals(nsURI)) {
                if ("mustUnderstand".equals(lName)) {
                    this.isMustUnderstand = Util.parseBool(value);
                } else if (SOAP_1_2_ROLE.equals(lName)) {
                    if (value != null && value.length() > 0) {
                        this.role = value;
                    }
                } else if (SOAP_1_2_RELAY.equals(lName)) {
                    this.isRelay = Util.parseBool(value);
                }
            }
            if (atts == null) {
                atts = new FinalArrayList();
            }
            atts.add((Object)new Attribute(nsURI, lName, value));
        }
        return atts;
    }

    @Override
    public boolean hasID(String id) {
        return this.idValues.contains(id);
    }

    @Override
    public final boolean isIgnorable(SOAPVersion soapVersion, Set<String> roles) {
        if (!this.isMustUnderstand) {
            return true;
        }
        return !roles.contains(this.role);
    }

    @Override
    public String getRole(SOAPVersion soapVersion) {
        assert (this.role != null);
        return this.role;
    }

    @Override
    public boolean isRelay() {
        return this.isRelay;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public String getLocalPart() {
        return this.localName;
    }

    @Override
    public String getAttribute(String nsUri, String localName) {
        if (this.attributes != null) {
            for (int i = this.attributes.size() - 1; i >= 0; --i) {
                Attribute a = (Attribute)this.attributes.get(i);
                if (!a.localName.equals(localName) || !a.nsUri.equals(nsUri)) continue;
                return a.value;
            }
        }
        return null;
    }

    @Override
    public XMLStreamReader readHeader() throws XMLStreamException {
        return this.completeHeader.readAsXMLStreamReader();
    }

    @Override
    public void writeTo(XMLStreamWriter w) throws XMLStreamException {
        try {
            this.completeHeader.writeToXMLStreamWriter(w);
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void writeTo(SOAPMessage saaj) throws SOAPException {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            XMLStreamBufferSource source = new XMLStreamBufferSource(this.completeHeader);
            DOMResult result = new DOMResult();
            t.transform(source, result);
            Node d = result.getNode();
            if (d.getNodeType() == 9) {
                d = d.getFirstChild();
            }
            SOAPHeader header = saaj.getSOAPHeader();
            Node node = header.getOwnerDocument().importNode(d, true);
            header.appendChild(node);
        }
        catch (Exception e) {
            throw new SOAPException((Throwable)e);
        }
    }

    @Override
    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        this.completeHeader.writeTo(contentHandler);
    }

    @Override
    public String getStringContent() {
        try {
            XMLStreamReader xsr = this.readHeader();
            xsr.nextTag();
            return xsr.getElementText();
        }
        catch (XMLStreamException e) {
            return null;
        }
    }

    private static String fixNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    @Override
    public <T> T readAsJAXB(Unmarshaller um) throws JAXBException {
        try {
            return (T)um.unmarshal((XMLStreamReader)((Object)this.completeHeader.readAsXMLStreamReader()));
        }
        catch (XMLStreamException e) {
            throw new JAXBException((Throwable)e);
        }
        catch (Exception e) {
            throw new JAXBException((Throwable)e);
        }
    }

    @Override
    public <T> T readAsJAXB(Bridge<T> bridge) throws JAXBException {
        try {
            return (T)bridge.unmarshal((XMLStreamReader)((Object)this.completeHeader.readAsXMLStreamReader()));
        }
        catch (XMLStreamException e) {
            throw new JAXBException((Throwable)e);
        }
        catch (Exception e) {
            throw new JAXBException((Throwable)e);
        }
    }

    @Override
    public HashMap<String, String> getInscopeNSContext() {
        return this.nsDecls;
    }

    class IDProcessor
    implements StreamFilter {
        boolean elementRead = false;

        IDProcessor() {
        }

        public boolean accept(XMLStreamReader reader) {
            String id;
            if (reader.getEventType() == 2 && reader.getLocalName().equals(GenericSecuredHeader.this.localName) && reader.getNamespaceURI().equals(GenericSecuredHeader.this.namespaceURI)) {
                this.elementRead = true;
            }
            if (!this.elementRead && reader.getEventType() == 1 && (id = reader.getAttributeValue("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id")) != null && id.length() > 0) {
                GenericSecuredHeader.this.idValues.add(id);
            }
            return true;
        }
    }

    protected static final class Attribute {
        final String nsUri;
        final String localName;
        final String value;

        public Attribute(String nsUri, String localName, String value) {
            this.nsUri = GenericSecuredHeader.fixNull(nsUri);
            this.localName = localName;
            this.value = value;
        }
    }
}

