/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction.jts.recovery;

import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.DistributedStateCache;
import com.sun.enterprise.ee.cms.core.FailureRecoverySignal;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.transaction.api.ResourceRecoveryManager;
import com.sun.enterprise.transaction.jts.api.DelegatedTransactionRecoveryFence;
import com.sun.enterprise.transaction.jts.recovery.RecoveryLockFile;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.DefaultTransactionService;
import com.sun.jts.jta.TransactionServiceProperties;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.jvnet.hk2.component.Habitat;

public class GMSCallBack
implements CallBack {
    private static final String component = "TRANSACTION-RECOVERY-SERVICE";
    private static final String TXLOGLOCATION = "TX_LOG_DIR";
    private static final String MEMBER_DETAILS = "MEMBERDETAILS";
    static Logger _logger = LogDomains.getLogger(TransactionServiceProperties.class, (String)"javax.enterprise.system.core.transaction");
    private Servers servers;
    private Habitat habitat;
    private int waitTime;
    private DelegatedTransactionRecoveryFence fence;
    private GroupManagementService gms;
    private final long startTime;
    private static final Object lock = new Object();

    public GMSCallBack(int waitTime, Habitat habitat) {
        GMSAdapter gmsAdapter;
        GMSAdapterService gmsAdapterService = (GMSAdapterService)habitat.getComponent(GMSAdapterService.class);
        if (gmsAdapterService != null && (gmsAdapter = gmsAdapterService.getGMSAdapter()) != null) {
            gmsAdapter.registerFailureRecoveryListener(component, (CallBack)this);
            this.habitat = habitat;
            this.servers = (Servers)habitat.getComponent(Servers.class);
            this.waitTime = waitTime;
            Properties props = TransactionServiceProperties.getJTSProperties(habitat, false);
            String instanceName = props.getProperty("com.sun.jts.instancename");
            String logdir = props.getProperty("com.sun.jts.logDirectory");
            if (Configuration.getORB() == null) {
                DefaultTransactionService.setServerName(props);
                this.fence = RecoveryLockFile.getDelegatedTransactionRecoveryFence(this);
            }
            this.gms = gmsAdapter.getModule();
            try {
                _logger.log(Level.INFO, "Storing GMS instance " + instanceName + " data " + TXLOGLOCATION + " : " + logdir);
                this.gms.updateMemberDetails(instanceName, (Serializable)((Object)TXLOGLOCATION), (Serializable)((Object)logdir));
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "jts.error_updating_gms", e);
            }
        }
        this.startTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNotification(Signal signal) {
        if (signal instanceof FailureRecoverySignal) {
            long timestamp = System.currentTimeMillis();
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "[GMSCallBack] failure recovery signal: " + signal);
            }
            try {
                Thread.sleep((long)this.waitTime * 1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            String instance = signal.getMemberToken();
            String logdir = null;
            Map failedMemberDetails = signal.getMemberDetails();
            if (failedMemberDetails != null) {
                logdir = (String)failedMemberDetails.get(TXLOGLOCATION);
            }
            Object object = lock;
            synchronized (object) {
                _logger.log(Level.INFO, "[GMSCallBack] Recovering for instance: " + instance + " logdir: " + logdir);
                this.doRecovery(logdir, instance, timestamp);
                while (logdir != null) {
                    logdir = this.finishDelegatedRecovery(logdir, timestamp);
                }
                _logger.log(Level.INFO, "[GMSCallBack] Finished recovery for instance: " + instance);
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[GMSCallBack] ignoring signal: " + signal);
        }
    }

    String finishDelegatedRecovery(String logdir) {
        return this.finishDelegatedRecovery(logdir, this.startTime);
    }

    String finishDelegatedRecovery(String logdir, long timestamp) {
        String delegatedLogDir = null;
        String instance = this.fence.getInstanceRecoveredFor(logdir, timestamp);
        if (_logger.isLoggable(Level.INFO)) {
            _logger.log(Level.INFO, "[GMSCallBack] Instance " + instance + " need to finish delegated recovering");
        }
        if (instance != null) {
            DistributedStateCache dsc = this.gms.getGroupHandle().getDistributedStateCache();
            Map memberDetails = dsc.getFromCacheForPattern(MEMBER_DETAILS, instance);
            delegatedLogDir = (String)memberDetails.get(TXLOGLOCATION);
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "[GMSCallBack] Tx log dir for instance " + instance + " is " + delegatedLogDir);
            }
            this.doRecovery(delegatedLogDir, instance, timestamp);
        }
        return delegatedLogDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRecovery(String logdir, String instance, long timestamp) {
        if (this.isInstanceRunning(instance)) {
            return;
        }
        if (logdir == null) {
            _logger.log(Level.WARNING, "jts.error_getting_member_details", instance);
            return;
        }
        if (this.fence.isFenceRaised(logdir, instance, timestamp)) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "Instance " + instance + " is already recovering");
            }
            return;
        }
        try {
            this.fence.raiseFence(logdir, instance);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Transaction log directory for " + instance + " is " + logdir);
                _logger.log(Level.FINE, "Starting transaction recovery of " + instance);
            }
            ResourceRecoveryManager recoveryManager = (ResourceRecoveryManager)this.habitat.getComponent(ResourceRecoveryManager.class);
            recoveryManager.recoverIncompleteTx(true, logdir, instance, true);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Transaction recovery of " + instance + " is completed");
            }
        }
        catch (Throwable e) {
            _logger.log(Level.WARNING, "jts.recovery_error", e);
        }
        finally {
            this.fence.lowerFence(logdir, instance);
        }
    }

    private boolean isInstanceRunning(String instance) {
        boolean rs = false;
        for (Server server : this.servers.getServer()) {
            if (!instance.equals(server.getName())) continue;
            rs = server.isRunning();
            break;
        }
        return rs;
    }
}

