/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.CoordinatorLog;
import com.sun.jts.CosTransactions.CoordinatorLogPool;
import com.sun.jts.CosTransactions.LogFile;
import com.sun.jts.CosTransactions.ProxyChecker;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.utils.LogFormatter;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.ORB;
import org.omg.CosTransactions.TransactionFactory;
import org.omg.PortableServer.POA;

public class Configuration {
    private static String serverName = null;
    private static byte[] serverNameByteArray = null;
    private static ORB orb = null;
    private static Properties prop = null;
    private static TransactionFactory factory = null;
    private static boolean localFactory = false;
    private static boolean recoverable = false;
    private static ProxyChecker checker = null;
    private static LogFile logFile = null;
    private static Hashtable poas = new Hashtable();
    private static String dbLogResource = null;
    private static boolean disableFileLogging = false;
    private static Hashtable logPathToServernametable = new Hashtable();
    private static Hashtable logPathToFiletable = new Hashtable();
    private static int retries = -1;
    public static final String COMMIT_ONE_PHASE_DURING_RECOVERY = "commit-one-phase-during-recovery";
    public static final int LAO_PREPARE_OK = 123456;
    public static final long COMMIT_RETRY_WAIT = 60000L;
    private static boolean isAppClient = true;
    static Logger _logger = LogDomains.getLogger(Configuration.class, (String)"javax.enterprise.system.core.transaction");
    private static boolean traceOn = false;
    public static final String TRACE_DIRECTORY = "com.sun.jts.traceDirectory";
    public static final String LOG_DIRECTORY = "com.sun.jts.logDirectory";
    public static final String DB_LOG_RESOURCE = "com.sun.jts.logResource";
    public static final String ERR_LOGGING = "com.sun.jts.errorLogging";
    public static final String MANUAL_RECOVERY = "com.sun.jts.ManualRecovery";
    public static final String COMMIT_RETRY = "com.sun.jts.commitRetry";
    public static final String HEURISTIC_DIRECTION = "com.sun.jts.heuristicDirection";
    public static final String KEYPOINT_COUNT = "com.sun.jts.keypointCount";
    public static final String INSTANCE_NAME = "com.sun.jts.instancename";
    public static final String TIMEOUT_INTERVAL = "com.sun.jts.timeoutInterval";
    public static final String JTS_SUBDIRECTORY = "jts";
    public static final int DIRECTORY_OK = 0;
    public static final int DEFAULT_USED = 1;
    public static final int DEFAULT_INVALID = 2;
    public static final int EXPECTED_CONCURRENT_TRANSACTIONS = 10000;
    public static final int EXPECTED_CONCURRENT_THREADS = 100;

    public static String getDirectory(String envDir, String defaultSubdirectory, int[] result) {
        String envValue = null;
        if (prop != null) {
            envValue = prop.getProperty(envDir);
        }
        result[0] = 0;
        if (envValue == null || envValue.length() == 0 || !new File(envValue).isDirectory()) {
            result[0] = 1;
            envValue = "." + File.separator + defaultSubdirectory;
            if (!new File(envValue).isDirectory()) {
                result[0] = 2;
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            String dirType = "";
            switch (result[0]) {
                case 2: {
                    dirType = "used default, but is invalid";
                    break;
                }
                case 1: {
                    dirType = "used default";
                    break;
                }
                case 0: {
                    dirType = "provided in configuration";
                    break;
                }
                default: {
                    dirType = "invalid type";
                }
            }
            _logger.logp(Level.FINE, "Configuration", "getDirectory()", "Using directory = " + envValue + " : " + dirType);
        }
        return envValue;
    }

    public static final void setServerName(String name, boolean recoverableServer) {
        serverName = name;
        serverNameByteArray = name == null ? null : serverName.getBytes();
        recoverable = recoverableServer;
        if (recoverable) {
            RecoveryManager.createRecoveryFile(serverName);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.logp(Level.FINE, "Configuration", "setServerName()", " serverName = " + serverName + "; isRecoverable = " + recoverable);
        }
    }

    public static final String getServerName() {
        String result = serverName;
        return result;
    }

    public static final void setServerName(String logPath, String name) {
        logPathToServernametable.put(logPath, name);
    }

    public static final String getServerName(String logPath) {
        return (String)logPathToServernametable.get(logPath);
    }

    public static final byte[] getServerNameByteArray() {
        byte[] result = serverNameByteArray;
        return result;
    }

    public static final void setProperties(Properties newProp) {
        if (prop == null) {
            prop = newProp;
        } else if (newProp != null) {
            prop.putAll((Map<?, ?>)newProp);
        }
        if (_logger.isLoggable(Level.FINE)) {
            String propertiesList = LogFormatter.convertPropsToString(prop);
            _logger.logp(Level.FINE, "Configuration", "setProperties()", " Properties set are :" + propertiesList);
        }
        if (prop != null) {
            dbLogResource = prop.getProperty(DB_LOG_RESOURCE);
            String retryLimit = prop.getProperty(COMMIT_RETRY);
            if (retryLimit != null) {
                int retriesInMinutes = Integer.parseInt(retryLimit, 10);
                retries = (long)retriesInMinutes % 60L == 0L ? (int)((long)retriesInMinutes / 60L) : (int)((long)retriesInMinutes / 60L) + 1;
            }
        }
    }

    public static final String getPropertyValue(String envValue) {
        String result = null;
        if (prop != null) {
            result = prop.getProperty(envValue);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Property :" + envValue + " has the value : " + result);
            }
        }
        return result;
    }

    public static final void setORB(ORB newORB) {
        orb = newORB;
    }

    public static final ORB getORB() {
        return orb;
    }

    public static final void setFactory(TransactionFactory newFactory, boolean localTxFactory) {
        factory = newFactory;
        localFactory = localTxFactory;
    }

    public static final TransactionFactory getFactory() {
        return factory;
    }

    public static final boolean isLocalFactory() {
        boolean result = localFactory;
        return result;
    }

    public static final boolean isRecoverable() {
        boolean result = recoverable;
        return result;
    }

    public static final void setProxyChecker(ProxyChecker newChecker) {
        checker = newChecker;
    }

    public static final ProxyChecker getProxyChecker() {
        return checker;
    }

    public static final void setLogFile(LogFile newLogFile) {
        logFile = newLogFile;
    }

    public static final LogFile getLogFile() {
        return logFile;
    }

    public static final void setLogFile(String logPath, LogFile newLogFile) {
        logPathToFiletable.put(logPath, newLogFile);
    }

    public static final LogFile getLogFile(String logPath) {
        if (logPath == null) {
            return null;
        }
        return (LogFile)logPathToFiletable.get(logPath);
    }

    public static final void setPOA(String type, POA poa) {
        poas.put(type, poa);
    }

    public static final POA getPOA(String type) {
        POA result = (POA)poas.get(type);
        return result;
    }

    public static final boolean isTraceEnabled() {
        return traceOn;
    }

    public static final void enableTrace() {
        traceOn = true;
    }

    public static final void disableTrace() {
        traceOn = false;
    }

    public static void setKeypointTrigger(int keypoint) {
        CoordinatorLogPool.getCoordinatorLog();
        CoordinatorLog.setKeypointTrigger(keypoint);
    }

    public static void setCommitRetryVar(String commitRetryString) {
        if (commitRetryString != null) {
            int retriesInMinutes = Integer.parseInt(commitRetryString, 10);
            retries = (long)retriesInMinutes % 60L == 0L ? (int)((long)retriesInMinutes / 60L) : (int)((long)retriesInMinutes / 60L) + 1;
        }
    }

    public static int getRetries() {
        return retries;
    }

    public static void setAsAppClientConatiner(boolean value) {
        isAppClient = value;
    }

    public static boolean isAppClientContainer() {
        return isAppClient;
    }

    static boolean isDBLoggingEnabled() {
        return dbLogResource != null;
    }

    public static void disableFileLogging() {
        disableFileLogging = true;
    }

    static boolean isFileLoggingDisabled() {
        return disableFileLogging;
    }
}

