/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.CurrentTransaction;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Environment;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.TSIdentification;
import org.omg.CORBA.TSIdentificationPackage.AlreadyIdentified;
import org.omg.CORBA.TSIdentificationPackage.NotAvailable;
import org.omg.CORBA.WrongTransaction;
import org.omg.CosTSPortability.Receiver;
import org.omg.CosTSPortability.Sender;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHolder;

class SenderReceiver
implements Sender,
Receiver {
    private static SenderReceiver sendRec = new SenderReceiver();
    static Logger _logger = LogDomains.getLogger(SenderReceiver.class, (String)"javax.enterprise.system.core.transaction");

    SenderReceiver() {
    }

    public void sending_request(int id, PropagationContextHolder holder) throws TRANSACTION_ROLLEDBACK, TRANSACTION_REQUIRED {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "In sending_request:" + id + "," + holder.value.current.otid.formatID);
        }
        CurrentTransaction.sendingRequest(id, holder);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Out sending_request:" + id + "," + holder.value.current.otid.formatID);
        }
    }

    public void received_reply(int id, PropagationContext context, Environment ex) throws WrongTransaction {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "In received_reply:" + id + "," + context.current.otid.formatID);
        }
        CurrentTransaction.receivedReply(id, context, ex);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Out received_reply:" + id + "," + context.current.otid.formatID);
        }
    }

    public void received_request(int id, PropagationContext context) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "In received_request:" + id + "," + context.current.otid.formatID);
        }
        CurrentTransaction.receivedRequest(id, context);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Out received_request:" + id + "," + context.current.otid.formatID);
        }
    }

    public void sending_reply(int id, PropagationContextHolder holder) throws INVALID_TRANSACTION, TRANSACTION_ROLLEDBACK {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "In sending_reply:" + id + "," + holder.value.current.otid.formatID);
        }
        CurrentTransaction.sendingReply(id, holder);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Out sending_reply:" + id + "," + holder.value.current.otid.formatID);
        }
    }

    static void identify(TSIdentification ident) {
        try {
            ident.identify_sender((Sender)sendRec);
            ident.identify_receiver((Receiver)sendRec);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Sender/Receiver " + sendRec + " successfully identified");
            }
        }
        catch (AlreadyIdentified exc) {
            _logger.log(Level.FINE, "jts.already_indetified_communication_manager");
        }
        catch (NotAvailable exc) {
            _logger.log(Level.WARNING, "jts.unable_to_indetify_communication_manager");
        }
    }

    private void debugMessage(String msg, int id, PropagationContext ctx) {
        _logger.log(Level.FINE, msg + ";" + id);
        if (ctx == null) {
            _logger.log(Level.FINE, "");
        } else {
            _logger.log(Level.FINE, "," + ctx.current.otid.formatID);
        }
    }
}

