/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jts.admin.cli;

import com.sun.enterprise.transaction.api.ResourceRecoveryManager;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.jts.admin.cli.RecoverTransactionsBase;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_recover-transactions-internal")
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE})
@ExecuteOn(value={RuntimeType.INSTANCE})
@Scoped(value=PerLookup.class)
public class RecoverTransactionsInternal
extends RecoverTransactionsBase
implements AdminCommand {
    @Param(name="target", optional=false)
    String destinationServer;
    @Inject
    ResourceRecoveryManager recoveryManager;

    public void execute(AdminCommandContext context) {
        String error;
        ActionReport report = context.getActionReport();
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("==> internal target: " + this.destinationServer + " ... server: " + this.serverToRecover);
        }
        if ((error = this.validate(this.destinationServer, false)) != null) {
            report.setMessage(error);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            boolean result = !this.serverToRecover.equals(this.destinationServer) ? this.recoveryManager.recoverIncompleteTx(true, this.transactionLogDir) : this.recoveryManager.recoverIncompleteTx(false, null);
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("==> recovery completed successfuly: " + result);
            }
            if (!result) {
                throw new IllegalStateException();
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, localStrings.getString("recover.transactions.failed"), e);
            report.setMessage(localStrings.getString("recover.transactions.failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

