/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.logging.Logger;
import org.graalvm.buildtools.utils.SharedConstants;

public abstract class NativeImageConfigurationUtils
implements SharedConstants {
    public static final String NATIVE_TESTS_EXE = "native-tests" + EXECUTABLE_EXTENSION;
    public static final String MAVEN_GROUP_ID = "org.graalvm.buildtools";
    public static Path nativeImageExeCache;
    public static Path nativeImageExeCacheSupportingToolchain;

    public static Path getJavaHomeNativeImage(String javaHomeVariable, Boolean failFast, Logger logger) throws MojoExecutionException {
        String graalHome = System.getenv(javaHomeVariable);
        if (graalHome == null) {
            return null;
        }
        Path graalHomePath = Paths.get(graalHome, new String[0]);
        Path nativeImageExe = graalHomePath.resolve("bin").resolve(NATIVE_IMAGE_EXE);
        Path guExe = graalHomePath.resolve("bin").resolve(GU_EXE);
        if (Files.exists(guExe, new LinkOption[0]) && !Files.exists(nativeImageExe, new LinkOption[0])) {
            ProcessBuilder processBuilder = new ProcessBuilder(guExe.toString(), "install", "native-image");
            processBuilder.inheritIO();
            try {
                Process nativeImageFetchingProcess = processBuilder.start();
                if (nativeImageFetchingProcess.waitFor() != 0) {
                    throw new MojoExecutionException("native-image was not found, and '" + GU_EXE + "' tool failed to install it.");
                }
            }
            catch (IOException | InterruptedException | MojoExecutionException e) {
                throw new MojoExecutionException("Determining GraalVM installation failed with message: " + e.getMessage());
            }
        }
        if (!Files.exists(nativeImageExe, new LinkOption[0])) {
            if (failFast.booleanValue()) {
                throw new MojoExecutionException("native-image is not installed in your " + javaHomeVariable + ".This probably means that the JDK at '" + String.valueOf(graalHomePath) + "' is not a GraalVM distribution. The GraalVM Native Maven Plugin requires GRAALVM_HOME or JAVA_HOME to be a GraalVM distribution.");
            }
            return null;
        }
        if (logger != null) {
            logger.info("Found GraalVM installation from " + javaHomeVariable + " variable.");
        }
        return nativeImageExe;
    }

    public static Path getNativeImageFromPath() {
        Optional<Path> exePath = Stream.of(System.getenv("PATH").split(Pattern.quote(File.pathSeparator))).map(x$0 -> Paths.get(x$0, new String[0])).filter(path -> Files.exists(path.resolve(NATIVE_IMAGE_EXE), new LinkOption[0])).findFirst();
        return exePath.map(path -> path.resolve(NATIVE_IMAGE_EXE)).orElse(null);
    }

    public static Path getNativeImageSupportingToolchain(Logger logger, ToolchainManager toolchainManager, MavenSession session, boolean enforceToolchain) throws MojoExecutionException {
        if (nativeImageExeCacheSupportingToolchain != null) {
            return nativeImageExeCacheSupportingToolchain;
        }
        Path nativeImage = NativeImageConfigurationUtils.getToolchainNativeImage(logger, toolchainManager, session, enforceToolchain);
        if (nativeImage != null) {
            nativeImageExeCacheSupportingToolchain = nativeImage;
            nativeImageExeCache = nativeImage;
            return nativeImage;
        }
        return NativeImageConfigurationUtils.getNativeImage(logger);
    }

    public static Path getToolchainNativeImage(Logger logger, ToolchainManager toolchainManager, MavenSession session, boolean enforceToolchain) throws MojoExecutionException {
        Toolchain toolchain = toolchainManager.getToolchainFromBuildContext("jdk", session);
        if (toolchain != null) {
            String javaPath = toolchain.findTool("java");
            if (javaPath != null) {
                Path nativeImagePath = Paths.get(javaPath, new String[0]).getParent().resolve(NATIVE_IMAGE_EXE).toAbsolutePath();
                if (!Files.exists(nativeImagePath, new LinkOption[0])) {
                    String message = "No " + NATIVE_IMAGE_EXE + " found in the jdk toolchain configuration: " + String.valueOf(nativeImagePath.getParent().getParent());
                    if (enforceToolchain) {
                        throw new MojoExecutionException(message);
                    }
                    logger.warn(message);
                    return null;
                }
                return nativeImagePath;
            }
            throw new MojoExecutionException("No java found the toolchain configuration.");
        }
        String message = "No jdk toolchain configuration found";
        if (enforceToolchain) {
            throw new MojoExecutionException("No jdk toolchain configuration found");
        }
        logger.warn("No jdk toolchain configuration found");
        return null;
    }

    public static Path getNativeImage(Logger logger) throws MojoExecutionException {
        if (nativeImageExeCache != null) {
            return nativeImageExeCache;
        }
        Path nativeImage = NativeImageConfigurationUtils.getJavaHomeNativeImage("GRAALVM_HOME", false, logger);
        if (nativeImage == null) {
            nativeImage = NativeImageConfigurationUtils.getJavaHomeNativeImage("JAVA_HOME", true, logger);
        }
        if (nativeImage == null && (nativeImage = NativeImageConfigurationUtils.getNativeImageFromPath()) != null && logger != null) {
            logger.info("Found GraalVM installation from PATH variable.");
        }
        if (nativeImage == null) {
            throw new RuntimeException("The 'native-image' tool was not found on your system. Make sure that the JAVA_HOME or GRAALVM_HOME environment variables point to a GraalVM JDK, or that 'native-image' is on the system path.");
        }
        nativeImageExeCache = nativeImage;
        return nativeImage;
    }
}

