/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.compiler;

import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilationTask;
import java.util.function.Supplier;

public interface TruffleCompilerListener {
    public void onGraalTierFinished(TruffleCompilable var1, GraphInfo var2);

    public void onTruffleTierFinished(TruffleCompilable var1, TruffleCompilationTask var2, GraphInfo var3);

    default public void onSuccess(TruffleCompilable compilable, TruffleCompilationTask task, GraphInfo graph, CompilationResultInfo compilationResultInfo, int tier) {
    }

    @Deprecated(since="24.1")
    default public void onFailure(TruffleCompilable compilable, String reason, boolean bailout, boolean permanentBailout, int tier) {
        this.onFailure(compilable, reason, bailout, permanentBailout, tier, null);
    }

    default public void onFailure(TruffleCompilable compilable, String reason, boolean bailout, boolean permanentBailout, int tier, Supplier<String> lazyStackTrace) {
    }

    default public void onCompilationRetry(TruffleCompilable compilable, TruffleCompilationTask task) {
    }

    public static interface CompilationResultInfo {
        default public long getCompilationId() {
            return -1L;
        }

        public int getTargetCodeSize();

        public int getTotalFrameSize();

        public int getExceptionHandlersCount();

        public int getInfopointsCount();

        public String[] getInfopoints();

        public int getMarksCount();

        public int getDataPatchesCount();
    }

    public static interface GraphInfo {
        public int getNodeCount();

        public String[] getNodeTypes(boolean var1);
    }
}

