/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.IsolateSourceCache;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

final class GuestSourceCache
implements IsolateSourceCache {
    private final AtomicInteger sourceSequencer = new AtomicInteger();
    private final Map<Long, Object> sourceByHandle = new ConcurrentHashMap<Long, Object>();

    GuestSourceCache() {
    }

    @Override
    public long translate(Object object) {
        long l2 = this.sourceSequencer.getAndIncrement();
        this.sourceByHandle.put(l2, object);
        return l2;
    }

    @Override
    public Object unhand(long l2) {
        Object object = this.sourceByHandle.get(l2);
        if (object == null) {
            throw new IllegalArgumentException("No source for handle 0x" + Long.toHexString(l2));
        }
        return object;
    }

    @Override
    public void release(long l2) {
        this.sourceByHandle.remove(l2);
    }

    @Override
    public Set<Object> getCachedSources() {
        throw new UnsupportedOperationException("Not supported");
    }
}

