/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry;

import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.testing.Test;
import org.gradle.testretry.internal.config.TestTaskConfigurer;

public class TestRetryPlugin
implements Plugin<Project> {
    private final ObjectFactory objectFactory;
    private final ProviderFactory providerFactory;

    @Inject
    TestRetryPlugin(ObjectFactory objectFactory, ProviderFactory providerFactory) {
        this.objectFactory = objectFactory;
        this.providerFactory = providerFactory;
    }

    public void apply(Project project) {
        if (TestRetryPlugin.pluginAlreadyApplied(project)) {
            return;
        }
        project.getTasks().withType(Test.class).configureEach(task -> TestTaskConfigurer.configureTestTask(task, this.objectFactory, this.providerFactory));
    }

    private static boolean pluginAlreadyApplied(Project project) {
        return project.getPlugins().stream().anyMatch(plugin -> plugin.getClass().getName().equals(TestRetryPlugin.class.getName()));
    }
}

