/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.executer;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.testretry.internal.executer.RoundResult;
import org.gradle.testretry.internal.executer.TestDescriptorImpl;
import org.gradle.testretry.internal.executer.TestNames;
import org.gradle.testretry.internal.executer.framework.TestFrameworkStrategy;
import org.gradle.testretry.internal.filter.ClassRetryMatcher;
import org.gradle.testretry.internal.filter.RetryFilter;
import org.gradle.testretry.internal.testsreader.TestsReader;
import org.gradle.util.GradleVersion;

final class RetryTestResultProcessor
implements TestResultProcessor {
    private final TestFrameworkStrategy testFrameworkStrategy;
    private final RetryFilter filter;
    private final ClassRetryMatcher classRetryMatcher;
    private final TestsReader testsReader;
    private final TestResultProcessor delegate;
    private final int maxFailures;
    private final boolean failOnSkippedAfterRetry;
    private boolean lastRetry;
    private boolean hasRetryFilteredFailures;
    private Method failureMethod;
    private final Map<Object, TestDescriptorInternal> activeDescriptorsById = new HashMap<Object, TestDescriptorInternal>();
    private final Map<Object, Object> parentIdByDescriptorId = new HashMap<Object, Object>();
    private final Set<String> testClassesSeenInCurrentRound = new HashSet<String>();
    private TestNames currentRoundFailedTests = new TestNames();
    private TestNames previousRoundFailedTests = new TestNames();
    private Object rootTestDescriptorId;

    RetryTestResultProcessor(TestFrameworkStrategy testFrameworkStrategy, RetryFilter filter, ClassRetryMatcher classRetryMatcher, TestsReader testsReader, TestResultProcessor delegate, int maxFailures, boolean failOnSkippedAfterRetry) {
        this.testFrameworkStrategy = testFrameworkStrategy;
        this.filter = filter;
        this.classRetryMatcher = classRetryMatcher;
        this.testsReader = testsReader;
        this.delegate = delegate;
        this.maxFailures = maxFailures;
        this.failOnSkippedAfterRetry = failOnSkippedAfterRetry;
    }

    public void started(TestDescriptorInternal descriptor, TestStartEvent testStartEvent) {
        if (this.rootTestDescriptorId == null) {
            this.rootTestDescriptorId = descriptor.getId();
            this.activeDescriptorsById.put(descriptor.getId(), descriptor);
            this.delegate.started(descriptor, testStartEvent);
        } else if (!descriptor.getId().equals(this.rootTestDescriptorId)) {
            this.activeDescriptorsById.put(descriptor.getId(), descriptor);
            this.parentIdByDescriptorId.put(descriptor.getId(), testStartEvent.getParentId());
            this.registerSeenTestClass(descriptor);
            this.delegate.started(descriptor, testStartEvent);
        }
    }

    public void completed(Object testId, TestCompleteEvent testCompleteEvent) {
        if (testId.equals(this.rootTestDescriptorId)) {
            if (this.currentRoundFailedTests.isEmpty() && !this.previousRoundFailedTests.isEmpty()) {
                this.ignoreExpectedUnretriedTests();
            }
            if (!this.lastRun()) {
                return;
            }
        } else {
            TestDescriptorInternal descriptor = this.activeDescriptorsById.remove(testId);
            if (descriptor != null && descriptor.getClassName() != null) {
                boolean shouldRetrySkippedTestThatPreviouslyFailed;
                String name;
                String className = descriptor.getClassName();
                boolean failedInPreviousRound = this.previousRoundFailedTests.remove(className, name = descriptor.getName());
                boolean bl = shouldRetrySkippedTestThatPreviouslyFailed = failedInPreviousRound && testCompleteEvent.getResultType() == TestResult.ResultType.SKIPPED && this.failOnSkippedAfterRetry;
                if (shouldRetrySkippedTestThatPreviouslyFailed) {
                    this.addRetry(descriptor);
                }
                if (this.isLifecycleFailure(className, name)) {
                    this.previousRoundFailedTests.remove(className, n -> {
                        if (this.isLifecycleFailure(className, (String)n)) {
                            this.currentRoundFailedTests.add(className, (String)n);
                        }
                        return true;
                    });
                }
                if (this.isClassDescriptor(descriptor)) {
                    this.previousRoundFailedTests.remove(className, n -> {
                        if (this.isLifecycleFailure(className, (String)n)) {
                            this.emitFakePassedEvent(descriptor, testCompleteEvent, (String)n);
                            return true;
                        }
                        return false;
                    });
                }
            }
        }
        this.delegate.completed(testId, testCompleteEvent);
    }

    private void ignoreExpectedUnretriedTests() {
        Map<String, Set> expectedUnretriedTests = this.previousRoundFailedTests.stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Set)entry.getValue()).stream().filter(test -> this.testFrameworkStrategy.isExpectedUnretriedTest((String)entry.getKey(), (String)test)).collect(Collectors.toSet())));
        expectedUnretriedTests.forEach((className, tests) -> this.previousRoundFailedTests.remove((String)className, tests::contains));
    }

    private boolean isLifecycleFailure(String className, String name) {
        return this.testFrameworkStrategy.isLifecycleFailureTest(this.testsReader, className, name);
    }

    private void registerSeenTestClass(TestDescriptorInternal descriptor) {
        String maybeTestClassName = descriptor.getClassName();
        if (maybeTestClassName != null) {
            this.testClassesSeenInCurrentRound.add(maybeTestClassName);
        }
    }

    private void addRetry(TestDescriptorInternal descriptor) {
        Optional<TestDescriptorInternal> classMatchingClassRetryFilter = this.firstClassMatchingClassRetryFilter(descriptor);
        if (classMatchingClassRetryFilter.isPresent()) {
            this.currentRoundFailedTests.addClass(classMatchingClassRetryFilter.get().getClassName());
        } else {
            this.currentRoundFailedTests.add(descriptor.getClassName(), descriptor.getName());
        }
    }

    private Optional<TestDescriptorInternal> firstClassMatchingClassRetryFilter(TestDescriptorInternal descriptor) {
        Object parentId = this.parentIdByDescriptorId.get(descriptor.getId());
        if (parentId == null) {
            return Optional.empty();
        }
        TestDescriptorInternal parentDescriptor = this.activeDescriptorsById.get(parentId);
        if (parentDescriptor == null) {
            return Optional.empty();
        }
        Optional<TestDescriptorInternal> parentClassToRetryEntirely = this.firstClassMatchingClassRetryFilter(parentDescriptor);
        if (parentClassToRetryEntirely.isPresent()) {
            return parentClassToRetryEntirely;
        }
        String className = descriptor.getClassName();
        if (className != null && this.classRetryMatcher.retryWholeClass(className)) {
            return Optional.of(descriptor);
        }
        return Optional.empty();
    }

    private void emitFakePassedEvent(TestDescriptorInternal parent, TestCompleteEvent parentEvent, String name) {
        Object syntheticTestId = new Object();
        TestDescriptorImpl syntheticDescriptor = new TestDescriptorImpl(syntheticTestId, parent, name);
        long timestamp = parentEvent.getEndTime();
        this.delegate.started((TestDescriptorInternal)syntheticDescriptor, new TestStartEvent(timestamp, parent.getId()));
        this.delegate.completed(syntheticTestId, new TestCompleteEvent(timestamp));
    }

    private boolean isClassDescriptor(TestDescriptorInternal descriptor) {
        return descriptor.getClassName() != null && descriptor.getClassName().equals(descriptor.getName());
    }

    public void output(Object testId, TestOutputEvent testOutputEvent) {
        this.delegate.output(testId, testOutputEvent);
    }

    public void failure(Object testId, Throwable throwable) {
        this.failure(testId);
        try {
            Method failureMethod = this.lookupFailureMethod();
            failureMethod.invoke((Object)this.delegate, testId, throwable);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private Method lookupFailureMethod() throws ReflectiveOperationException {
        if (this.failureMethod == null) {
            this.failureMethod = this.delegate.getClass().getMethod("failure", Object.class, Throwable.class);
        }
        return this.failureMethod;
    }

    public void failure(Object testId, TestFailure result) {
        this.failure(testId);
        this.delegate.failure(testId, result);
    }

    private void failure(Object testId) {
        String className;
        TestDescriptorInternal descriptor = this.activeDescriptorsById.get(testId);
        if (descriptor != null && (className = descriptor.getClassName()) != null) {
            if (this.filter.canRetry(className)) {
                this.addRetry(descriptor);
            } else {
                this.hasRetryFilteredFailures = true;
            }
        }
    }

    private boolean lastRun() {
        return this.currentRoundFailedTests.isEmpty() || this.hasNonRetriedTests() || this.lastRetry || this.currentRoundFailedTestsExceedsMaxFailures();
    }

    private boolean hasNonRetriedTests() {
        return !this.cleanedUpFailedTestsOfPreviousRound().isEmpty();
    }

    private boolean currentRoundFailedTestsExceedsMaxFailures() {
        return this.maxFailures > 0 && this.currentRoundFailedTests.size() >= this.maxFailures;
    }

    public RoundResult getResult() {
        return new RoundResult(this.currentRoundFailedTests, this.cleanedUpFailedTestsOfPreviousRound(), this.lastRun(), this.hasRetryFilteredFailures, this.testClassesSeenInCurrentRound);
    }

    private TestNames cleanedUpFailedTestsOfPreviousRound() {
        boolean isGradle50 = GradleVersion.current().getBaseVersion().equals(GradleVersion.version((String)"5.0"));
        if (isGradle50 && !this.testClassesSeenInCurrentRound.isEmpty() && this.previousRoundFailedTests.hasClassesWithoutTestNames()) {
            TestNames testNames = new TestNames();
            this.previousRoundFailedTests.stream().forEach(entry -> {
                String testClass = (String)entry.getKey();
                Set testMethods = (Set)entry.getValue();
                if (testMethods.isEmpty()) {
                    if (!this.testClassesSeenInCurrentRound.contains(testClass)) {
                        testNames.addClass(testClass);
                    }
                } else {
                    testNames.addAll(testClass, testMethods);
                }
            });
            return testNames;
        }
        return this.previousRoundFailedTests;
    }

    public void reset(boolean lastRetry) {
        if (this.lastRun()) {
            throw new IllegalStateException("processor has completed");
        }
        this.lastRetry = lastRetry;
        this.testClassesSeenInCurrentRound.clear();
        this.previousRoundFailedTests = this.currentRoundFailedTests;
        this.currentRoundFailedTests = new TestNames();
        this.activeDescriptorsById.clear();
        this.parentIdByDescriptorId.clear();
    }
}

