/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.executer.framework;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.testretry.internal.executer.TestFilterBuilder;
import org.gradle.testretry.internal.executer.TestFrameworkTemplate;
import org.gradle.testretry.internal.executer.TestNames;
import org.gradle.testretry.internal.executer.framework.JunitTestFrameworkStrategy;
import org.gradle.testretry.internal.executer.framework.SpockParameterClassVisitor;
import org.gradle.testretry.internal.executer.framework.TestFrameworkStrategy;
import org.gradle.testretry.internal.executer.framework.TestNgClassVisitor;
import org.gradle.testretry.internal.testsreader.TestsReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseJunitTestFrameworkStrategy
implements TestFrameworkStrategy {
    public static final Logger LOGGER = LoggerFactory.getLogger(JunitTestFrameworkStrategy.class);
    private static final Pattern PARAMETERIZED_SUFFIX_PATTERN = Pattern.compile("(?:\\([^)]*?\\))?(?:\\[[^]]*?])?$");
    private static final String ERROR_SYNTHETIC_TESTNG_CLASS_NAME = "UnknownClass";
    static final Set<String> ERROR_SYNTHETIC_TEST_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("classMethod", "executionError", "initializationError", "unnecessary Mockito stubbings")));

    BaseJunitTestFrameworkStrategy() {
    }

    @Override
    public boolean isLifecycleFailureTest(TestsReader testsReader, String className, String testName) {
        return ERROR_SYNTHETIC_TEST_NAMES.contains(testName);
    }

    @Override
    public boolean isExpectedUnretriedTest(String className, String test) {
        return ERROR_SYNTHETIC_TESTNG_CLASS_NAME.equals(className);
    }

    protected DefaultTestFilter testFilterFor(TestNames failedTests, boolean canRunParameterizedSpockMethods, TestFrameworkTemplate template, Set<String> testClassesSeenInCurrentRound) {
        TestFilterBuilder filter = template.filterBuilder();
        this.addFilters(filter, template.testsReader, failedTests, canRunParameterizedSpockMethods, testClassesSeenInCurrentRound);
        return filter.build();
    }

    protected void addFilters(TestFilterBuilder filters, TestsReader testsReader, TestNames failedTests, boolean canRunParameterizedSpockMethods, Set<String> testClassesSeenInCurrentRound) {
        failedTests.stream().forEach(entry -> {
            String className = (String)entry.getKey();
            Set tests = (Set)entry.getValue();
            if (tests.isEmpty()) {
                filters.clazz(className);
                return;
            }
            if (tests.stream().anyMatch(ERROR_SYNTHETIC_TEST_NAMES::contains)) {
                if (ERROR_SYNTHETIC_TESTNG_CLASS_NAME.equals(className)) {
                    testClassesSeenInCurrentRound.forEach(filters::clazz);
                } else {
                    filters.clazz(className);
                }
                return;
            }
            if (this.processSpockTest(filters, testsReader, canRunParameterizedSpockMethods, className, tests)) {
                return;
            }
            if (this.processTestNGTest(filters, testsReader, className, tests)) {
                return;
            }
            tests.forEach(name -> this.addPotentiallyParameterizedSuffixed(filters, className, (String)name));
        });
    }

    private boolean processSpockTest(TestFilterBuilder filters, TestsReader testsReader, boolean canRunParameterizedSpockMethods, String className, Set<String> tests) {
        try {
            Optional resultOpt = testsReader.readTestClassDirClass(className, () -> new SpockParameterClassVisitor(tests, testsReader));
            if (resultOpt.isPresent()) {
                Map result = (Map)resultOpt.get();
                if (result.isEmpty()) {
                    return false;
                }
                if (canRunParameterizedSpockMethods) {
                    result.forEach((test, matches) -> {
                        if (matches.isEmpty()) {
                            this.addPotentiallyParameterizedSuffixed(filters, className, (String)test);
                        } else {
                            matches.forEach(match -> filters.test(className, (String)match));
                        }
                    });
                } else {
                    boolean allLiteralMethodMatches = result.entrySet().stream().allMatch(e2 -> ((List)e2.getValue()).size() == 1 && ((String)((List)e2.getValue()).get(0)).equals(e2.getKey()));
                    if (allLiteralMethodMatches) {
                        tests.forEach(test -> filters.test(className, (String)test));
                    } else {
                        filters.clazz(className);
                    }
                }
                return true;
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Unable to determine if class {} contains Spock @Unroll parameterizations", (Object)className, (Object)t);
        }
        return false;
    }

    private boolean processTestNGTest(TestFilterBuilder filters, TestsReader testsReader, String className, Set<String> tests) {
        try {
            Optional resultOpt = testsReader.readTestClassDirClass(className, TestNgClassVisitor::new);
            if (resultOpt.isPresent()) {
                TestNgClassVisitor.ClassInfo result = (TestNgClassVisitor.ClassInfo)resultOpt.get();
                tests.forEach(test -> {
                    this.addPotentiallyParameterizedSuffixed(filters, className, (String)test);
                    result.dependsOn((String)test).forEach(dependency -> filters.test(className, (String)dependency));
                });
                return true;
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Unable to determine dependency between methods of a TestNG test class {}", (Object)className, (Object)t);
        }
        return false;
    }

    private void addPotentiallyParameterizedSuffixed(TestFilterBuilder filters, String className, String name) {
        String strippedParameterName = PARAMETERIZED_SUFFIX_PATTERN.matcher(name).replaceAll("");
        filters.test(className, strippedParameterName);
        filters.test(className, name);
    }
}

