/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.multitenancy;

import grails.gorm.multitenancy.Tenants;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.grails.datastore.gorm.GormEnhancer;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.engine.event.AbstractPersistenceEvent;
import org.grails.datastore.mapping.engine.event.PersistenceEventListener;
import org.grails.datastore.mapping.engine.event.PreInsertEvent;
import org.grails.datastore.mapping.engine.event.PreUpdateEvent;
import org.grails.datastore.mapping.engine.event.ValidationEvent;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.types.TenantId;
import org.grails.datastore.mapping.multitenancy.MultiTenantCapableDatastore;
import org.grails.datastore.mapping.multitenancy.exceptions.TenantException;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.event.PreQueryEvent;
import org.springframework.context.ApplicationEvent;

public class MultiTenantEventListener
implements PersistenceEventListener {
    protected final Datastore datastore;
    public static final List<Class<? extends ApplicationEvent>> SUPPORTED_EVENTS = Arrays.asList(PreQueryEvent.class, ValidationEvent.class, PreInsertEvent.class, PreUpdateEvent.class);

    public MultiTenantEventListener(Datastore datastore) {
        this.datastore = datastore;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return SUPPORTED_EVENTS.contains(eventType);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return Datastore.class.isAssignableFrom(sourceType);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        Class<?> eventClass = event.getClass();
        if (this.supportsEventType(eventClass)) {
            AbstractPersistenceEvent preInsertEvent;
            PersistentEntity entity;
            Datastore datastore = (Datastore)event.getSource();
            if (event instanceof PreQueryEvent) {
                PreQueryEvent preQueryEvent = (PreQueryEvent)event;
                Query query = preQueryEvent.getQuery();
                PersistentEntity entity2 = query.getEntity();
                if (entity2.isMultiTenant()) {
                    TenantId tenantId;
                    if (datastore == null) {
                        datastore = GormEnhancer.findDatastore(entity2.getJavaClass());
                    }
                    if (this.supportsSourceType(datastore.getClass()) && this.datastore.equals(datastore) && (tenantId = entity2.getTenantId()) != null) {
                        Serializable currentId = datastore instanceof MultiTenantCapableDatastore ? Tenants.currentId((MultiTenantCapableDatastore)datastore) : Tenants.currentId(datastore.getClass());
                        query.eq(tenantId.getName(), (Object)currentId);
                    }
                }
            } else if ((event instanceof ValidationEvent || event instanceof PreInsertEvent || event instanceof PreUpdateEvent) && (entity = (preInsertEvent = (AbstractPersistenceEvent)event).getEntity()).isMultiTenant()) {
                Serializable currentId;
                TenantId tenantId = entity.getTenantId();
                if (datastore == null) {
                    datastore = GormEnhancer.findDatastore(entity.getJavaClass());
                }
                if (this.supportsSourceType(datastore.getClass()) && this.datastore.equals(datastore) && (currentId = datastore instanceof MultiTenantCapableDatastore ? Tenants.currentId((MultiTenantCapableDatastore)datastore) : Tenants.currentId(datastore.getClass())) != null) {
                    try {
                        preInsertEvent.getEntityAccess().setProperty(tenantId.getName(), (Object)currentId);
                    }
                    catch (Exception e) {
                        throw new TenantException("Could not assigned tenant id [" + currentId + "] to property [" + tenantId + "], probably due to a type mismatch. You should return a type from the tenant resolver that matches the property type of the tenant id!: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    public int getOrder() {
        return 0x3FFFFFFF;
    }
}

