/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.BitSet;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.SupportFeaturesUtils;
import org.apache.ignite.internal.managers.discovery.IgniteDiscoverySpi;
import org.apache.ignite.internal.processors.ru.IgniteRollingUpgradeStatus;
import org.apache.ignite.internal.processors.ru.RollingUpgradeStatus;
import org.apache.ignite.internal.processors.schedule.IgniteNoopScheduleProcessor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.jetbrains.annotations.Nullable;

public final class IgniteFeatures
extends Enum<IgniteFeatures> {
    public static final /* enum */ IgniteFeatures TCP_COMMUNICATION_SPI_HANDSHAKE_WAIT_MESSAGE = new IgniteFeatures(0);
    public static final /* enum */ IgniteFeatures CACHE_METRICS_V2 = new IgniteFeatures(1);
    public static final /* enum */ IgniteFeatures DATA_PACKET_COMPRESSION = new IgniteFeatures(3);
    public static final /* enum */ IgniteFeatures DIFFERENT_REBALANCE_POOL_SIZE = new IgniteFeatures(4);
    public static final /* enum */ IgniteFeatures SPLITTED_CACHE_CONFIGURATIONS = new IgniteFeatures(5);
    public static final /* enum */ IgniteFeatures TRANSACTION_OWNER_THREAD_DUMP_PROVIDING = new IgniteFeatures(6);
    public static final /* enum */ IgniteFeatures TX_INFO_COMMAND = new IgniteFeatures(7);
    public static final /* enum */ IgniteFeatures FIND_AND_DELETE_GARBAGE_COMMAND = new IgniteFeatures(8);
    public static final /* enum */ IgniteFeatures CLUSTER_READ_ONLY_MODE = new IgniteFeatures(9);
    public static final /* enum */ IgniteFeatures SUSPEND_RESUME_PESSIMISTIC_TX = new IgniteFeatures(10);
    public static final /* enum */ IgniteFeatures DISTRIBUTED_METASTORAGE = new IgniteFeatures(11);
    public static final /* enum */ IgniteFeatures TX_TRACKING_UPDATE_COUNTER = new IgniteFeatures(12);
    public static final /* enum */ IgniteFeatures IGNITE_SECURITY_PROCESSOR = new IgniteFeatures(13);
    public static final /* enum */ IgniteFeatures TCP_DISCOVERY_MESSAGE_NODE_COMPACT_REPRESENTATION = new IgniteFeatures(14);
    public static final /* enum */ IgniteFeatures INDEXING = new IgniteFeatures(15);
    public static final /* enum */ IgniteFeatures CLUSTER_ID_AND_TAG = new IgniteFeatures(16);
    public static final /* enum */ IgniteFeatures LRT_SYSTEM_USER_TIME_DUMP_SETTINGS = new IgniteFeatures(18);
    public static final /* enum */ IgniteFeatures DR_DATA_NODE_SMART_THROTTLING = new IgniteFeatures(19);
    public static final /* enum */ IgniteFeatures WC_DR_EVENTS = new IgniteFeatures(20);
    public static final /* enum */ IgniteFeatures DISTRIBUTED_ROLLING_UPGRADE_MODE = new IgniteFeatures(21);
    public static final /* enum */ IgniteFeatures WC_SNAPSHOT_CHAIN_MODE = new IgniteFeatures(22);
    public static final /* enum */ IgniteFeatures BASELINE_AUTO_ADJUSTMENT = new IgniteFeatures(23);
    public static final /* enum */ IgniteFeatures WC_SCHEDULING_NOT_AVAILABLE = new IgniteFeatures(24);
    public static final /* enum */ IgniteFeatures DR_CONTROL_UTILITY = new IgniteFeatures(25);
    public static final /* enum */ IgniteFeatures TRACING = new IgniteFeatures(26);
    public static final /* enum */ IgniteFeatures WC_DR_CLEAR_SENDER_STORE = new IgniteFeatures(29);
    public static final /* enum */ IgniteFeatures DISTRIBUTED_CHANGE_LONG_OPERATIONS_DUMP_TIMEOUT = new IgniteFeatures(30);
    public static final /* enum */ IgniteFeatures WC_GET_CACHE_VALUE = new IgniteFeatures(31);
    public static final /* enum */ IgniteFeatures PME_FREE_SWITCH = new IgniteFeatures(32);
    public static final /* enum */ IgniteFeatures VOLATILE_DATA_STRUCTURES_REGION = new IgniteFeatures(33);
    public static final /* enum */ IgniteFeatures PARTITION_RECONCILIATION = new IgniteFeatures(34);
    public static final /* enum */ IgniteFeatures INVERSE_TCP_CONNECTION = new IgniteFeatures(35);
    public static final /* enum */ IgniteFeatures CHECK_INDEX_INLINE_SIZES = new IgniteFeatures(36);
    public static final /* enum */ IgniteFeatures DISTRIBUTED_TX_COLLISIONS_DUMP = new IgniteFeatures(37);
    public static final /* enum */ IgniteFeatures METASTORAGE_LONG_KEYS = new IgniteFeatures(38);
    public static final /* enum */ IgniteFeatures REMOVE_METADATA = new IgniteFeatures(39);
    public static final /* enum */ IgniteFeatures SHUTDOWN_POLICY = new IgniteFeatures(40);
    public static final /* enum */ IgniteFeatures IGNITE_SECURITY_PROCESSOR_V2 = new IgniteFeatures(41);
    public static final /* enum */ IgniteFeatures INDEXES_MANIPULATIONS_FROM_CONTROL_SCRIPT = new IgniteFeatures(42);
    public static final /* enum */ IgniteFeatures EXCHANGELESS_SNAPSHOT = new IgniteFeatures(43);
    public static final /* enum */ IgniteFeatures MVCC_TX_RECOVERY_PROTOCOL_V2 = new IgniteFeatures(44);
    public static final /* enum */ IgniteFeatures SPECIFIED_SEQ_PK_KEYS = new IgniteFeatures(45);
    public static final /* enum */ IgniteFeatures SPLITTED_CACHE_CONFIGURATIONS_V2 = new IgniteFeatures(46);
    public static final /* enum */ IgniteFeatures SNAPSHOT_SFTP_UPLOAD = new IgniteFeatures(47);
    public static final /* enum */ IgniteFeatures MASTER_KEY_CHANGE = new IgniteFeatures(48);
    public static final /* enum */ IgniteFeatures INCREMENTAL_DR = new IgniteFeatures(49);
    public static final /* enum */ IgniteFeatures CACHE_GROUP_KEY_CHANGE = new IgniteFeatures(50);
    public static final /* enum */ IgniteFeatures SAFE_CLUSTER_DEACTIVATION = new IgniteFeatures(51);
    public static final /* enum */ IgniteFeatures TRANSACTION_DISTRIBUTED_PROPERTIES = new IgniteFeatures(52);
    public static final /* enum */ IgniteFeatures CUSTOM_SNAPSHOT_OPERATIONS = new IgniteFeatures(53);
    public static final /* enum */ IgniteFeatures POINT_IN_TIME_DISTRIBUTED_PROPERTY = new IgniteFeatures(54);
    public static final /* enum */ IgniteFeatures STATISTICS_COLLECTION = new IgniteFeatures(55);
    public static final /* enum */ IgniteFeatures IMPROPER_SCHEDULE_FOR_PITR_WARNING = new IgniteFeatures(56);
    public static final /* enum */ IgniteFeatures SNAPSHOT_LAST_SNAPSHOTS_MISMATCH_HANDLING_POLICY = new IgniteFeatures(57);
    public static final /* enum */ IgniteFeatures DISTRIBUTED_ROLLING_UPGRADE_MODE_V2 = new IgniteFeatures(58);
    public static final /* enum */ IgniteFeatures SNAPSHOT_OPERATIONS_CHAINING = new IgniteFeatures(59);
    public static final /* enum */ IgniteFeatures SNAPSHOT_SFTP_UPLOAD_V2 = new IgniteFeatures(60);
    public static final /* enum */ IgniteFeatures SNAPSHOT_OPERATION_WITH_EXCLUDE_AND_GROUPS_FILTER = new IgniteFeatures(62);
    public static final /* enum */ IgniteFeatures REMOTE_AUTH = new IgniteFeatures(61);
    public static final /* enum */ IgniteFeatures SNAPSHOT_COMPRESSION_EXTENDED_OPTION = new IgniteFeatures(63);
    public static final /* enum */ IgniteFeatures FILLS_ABSENT_PKS_WITH_DEFAULTS = new IgniteFeatures(64);
    private final int featureId;
    private static final /* synthetic */ IgniteFeatures[] $VALUES;

    public static IgniteFeatures[] values() {
        return (IgniteFeatures[])$VALUES.clone();
    }

    public static IgniteFeatures valueOf(String name) {
        return Enum.valueOf(IgniteFeatures.class, name);
    }

    private IgniteFeatures(int featureId) {
        this.featureId = featureId;
    }

    public int getFeatureId() {
        return this.featureId;
    }

    public static boolean nodeSupports(GridKernalContext ctx, ClusterNode clusterNode, IgniteFeatures feature) {
        RollingUpgradeStatus status;
        if (ctx != null && (status = ctx.rollingUpgrade().getStatus()).enabled() && !status.forcedModeEnabled()) {
            return IgniteFeatures.nodeSupports(((IgniteRollingUpgradeStatus)status).supportedFeatures(), feature);
        }
        return IgniteFeatures.nodeSupports((byte[])clusterNode.attribute("org.apache.ignite.features"), feature);
    }

    public static boolean nodeSupports(byte[] featuresAttrBytes, IgniteFeatures feature) {
        if (featuresAttrBytes == null) {
            return false;
        }
        int featureId = feature.getFeatureId();
        int byteIdx = featureId >>> 3;
        if (byteIdx >= featuresAttrBytes.length) {
            return false;
        }
        int bitIdx = featureId & 7;
        return (featuresAttrBytes[byteIdx] & 1 << bitIdx) != 0;
    }

    public static boolean allNodesSupports(@Nullable GridKernalContext ctx, Iterable<ClusterNode> nodes, IgniteFeatures feature) {
        RollingUpgradeStatus status;
        if (ctx != null && nodes.iterator().hasNext() && (status = ctx.rollingUpgrade().getStatus()).enabled() && !status.forcedModeEnabled() && status instanceof IgniteRollingUpgradeStatus) {
            return IgniteFeatures.nodeSupports(((IgniteRollingUpgradeStatus)status).supportedFeatures(), feature);
        }
        for (ClusterNode next : nodes) {
            if (IgniteFeatures.nodeSupports((byte[])next.attribute("org.apache.ignite.features"), feature)) continue;
            return false;
        }
        return true;
    }

    public static boolean allNodesSupport(GridKernalContext ctx, IgniteFeatures feature) {
        return IgniteFeatures.allNodesSupport(ctx, ctx.config().getDiscoverySpi(), feature);
    }

    public static boolean allNodesSupport(@Nullable GridKernalContext ctx, DiscoverySpi discoSpi, IgniteFeatures feature) {
        return IgniteFeatures.allNodesSupport(ctx, discoSpi, feature, F.alwaysTrue());
    }

    public static boolean allNodesSupport(GridKernalContext ctx, IgniteFeatures feature, IgnitePredicate<ClusterNode> pred) {
        return IgniteFeatures.allNodesSupport(ctx, ctx.config().getDiscoverySpi(), feature, pred);
    }

    public static boolean allNodesSupport(@Nullable GridKernalContext ctx, DiscoverySpi discoSpi, IgniteFeatures feature, IgnitePredicate<ClusterNode> pred) {
        if (discoSpi instanceof IgniteDiscoverySpi) {
            return ((IgniteDiscoverySpi)discoSpi).allNodesSupport(feature, pred);
        }
        return IgniteFeatures.allNodesSupports(ctx, F.view(discoSpi.getRemoteNodes(), pred), feature);
    }

    public static byte[] allFeatures(GridKernalContext ctx) {
        BitSet set = new BitSet();
        for (IgniteFeatures value : IgniteFeatures.values()) {
            if (IGNITE_SECURITY_PROCESSOR == value && !IgniteSystemProperties.getBoolean(IGNITE_SECURITY_PROCESSOR.name(), false) || IGNITE_SECURITY_PROCESSOR_V2 == value && !IgniteSystemProperties.getBoolean(IGNITE_SECURITY_PROCESSOR_V2.name(), true) || INDEXING == value && (ctx.query() == null || !ctx.query().moduleEnabled()) || TRACING == value && !IgniteComponentType.TRACING.inClassPath() || WC_SCHEDULING_NOT_AVAILABLE == value && !(ctx.schedule() instanceof IgniteNoopScheduleProcessor) || DISTRIBUTED_METASTORAGE == value && !SupportFeaturesUtils.isFeatureEnabled("IGNITE_DISTRIBUTED_META_STORAGE_FEATURE") || CLUSTER_ID_AND_TAG == value && !SupportFeaturesUtils.isFeatureEnabled("IGNITE_CLUSTER_ID_AND_TAG_FEATURE") || BASELINE_AUTO_ADJUSTMENT == value && !SupportFeaturesUtils.isFeatureEnabled("IGNITE_BASELINE_AUTO_ADJUST_FEATURE") || SPLITTED_CACHE_CONFIGURATIONS == value && SupportFeaturesUtils.isFeatureEnabled("IGNITE_USE_BACKWARD_COMPATIBLE_CONFIGURATION_SPLITTER") || PME_FREE_SWITCH == value && SupportFeaturesUtils.isFeatureEnabled("IGNITE_PME_FREE_SWITCH_DISABLED") || SPECIFIED_SEQ_PK_KEYS == value && SupportFeaturesUtils.isFeatureEnabled("IGNITE_SPECIFIED_SEQ_PK_KEYS_DISABLED")) continue;
            int featureId = value.getFeatureId();
            assert (!set.get(featureId)) : "Duplicate feature ID found for [" + (Object)((Object)value) + "] having same ID [" + featureId + "]";
            set.set(featureId);
        }
        return set.toByteArray();
    }

    static {
        $VALUES = new IgniteFeatures[]{TCP_COMMUNICATION_SPI_HANDSHAKE_WAIT_MESSAGE, CACHE_METRICS_V2, DATA_PACKET_COMPRESSION, DIFFERENT_REBALANCE_POOL_SIZE, SPLITTED_CACHE_CONFIGURATIONS, TRANSACTION_OWNER_THREAD_DUMP_PROVIDING, TX_INFO_COMMAND, FIND_AND_DELETE_GARBAGE_COMMAND, CLUSTER_READ_ONLY_MODE, SUSPEND_RESUME_PESSIMISTIC_TX, DISTRIBUTED_METASTORAGE, TX_TRACKING_UPDATE_COUNTER, IGNITE_SECURITY_PROCESSOR, TCP_DISCOVERY_MESSAGE_NODE_COMPACT_REPRESENTATION, INDEXING, CLUSTER_ID_AND_TAG, LRT_SYSTEM_USER_TIME_DUMP_SETTINGS, DR_DATA_NODE_SMART_THROTTLING, WC_DR_EVENTS, DISTRIBUTED_ROLLING_UPGRADE_MODE, WC_SNAPSHOT_CHAIN_MODE, BASELINE_AUTO_ADJUSTMENT, WC_SCHEDULING_NOT_AVAILABLE, DR_CONTROL_UTILITY, TRACING, WC_DR_CLEAR_SENDER_STORE, DISTRIBUTED_CHANGE_LONG_OPERATIONS_DUMP_TIMEOUT, WC_GET_CACHE_VALUE, PME_FREE_SWITCH, VOLATILE_DATA_STRUCTURES_REGION, PARTITION_RECONCILIATION, INVERSE_TCP_CONNECTION, CHECK_INDEX_INLINE_SIZES, DISTRIBUTED_TX_COLLISIONS_DUMP, METASTORAGE_LONG_KEYS, REMOVE_METADATA, SHUTDOWN_POLICY, IGNITE_SECURITY_PROCESSOR_V2, INDEXES_MANIPULATIONS_FROM_CONTROL_SCRIPT, EXCHANGELESS_SNAPSHOT, MVCC_TX_RECOVERY_PROTOCOL_V2, SPECIFIED_SEQ_PK_KEYS, SPLITTED_CACHE_CONFIGURATIONS_V2, SNAPSHOT_SFTP_UPLOAD, MASTER_KEY_CHANGE, INCREMENTAL_DR, CACHE_GROUP_KEY_CHANGE, SAFE_CLUSTER_DEACTIVATION, TRANSACTION_DISTRIBUTED_PROPERTIES, CUSTOM_SNAPSHOT_OPERATIONS, POINT_IN_TIME_DISTRIBUTED_PROPERTY, STATISTICS_COLLECTION, IMPROPER_SCHEDULE_FOR_PITR_WARNING, SNAPSHOT_LAST_SNAPSHOTS_MISMATCH_HANDLING_POLICY, DISTRIBUTED_ROLLING_UPGRADE_MODE_V2, SNAPSHOT_OPERATIONS_CHAINING, SNAPSHOT_SFTP_UPLOAD_V2, SNAPSHOT_OPERATION_WITH_EXCLUDE_AND_GROUPS_FILTER, REMOTE_AUTH, SNAPSHOT_COMPRESSION_EXTENDED_OPTION, FILLS_ABSENT_PKS_WITH_DEFAULTS};
    }
}

