/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryFieldMetadata;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.binary.BinaryTypeImpl;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class BinaryMetadata
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private static final int VERSION = 1;
    @GridToStringInclude(sensitive=true)
    private int typeId;
    @GridToStringInclude(sensitive=true)
    private String typeName;
    @GridToStringInclude(sensitive=true)
    private Map<String, BinaryFieldMetadata> fields;
    @GridToStringInclude(sensitive=true)
    private String affKeyFieldName;
    @GridToStringInclude
    private Collection<BinarySchema> schemas;
    private Set<Integer> schemaIds;
    private boolean isEnum;
    private Map<String, Integer> nameToOrdinal;
    private Map<Integer, String> ordinalToName;

    public BinaryMetadata() {
    }

    public BinaryMetadata(int typeId, String typeName, @Nullable Map<String, BinaryFieldMetadata> fields, @Nullable String affKeyFieldName, @Nullable Collection<BinarySchema> schemas, boolean isEnum, @Nullable Map<String, Integer> enumMap) {
        assert (typeName != null);
        this.typeId = typeId;
        this.typeName = typeName;
        this.fields = fields;
        this.affKeyFieldName = affKeyFieldName;
        this.schemas = schemas;
        if (schemas != null) {
            this.schemaIds = U.newHashSet(schemas.size());
            for (BinarySchema binarySchema : schemas) {
                this.schemaIds.add(binarySchema.schemaId());
            }
        } else {
            this.schemaIds = Collections.emptySet();
        }
        this.isEnum = isEnum;
        if (enumMap != null) {
            this.nameToOrdinal = new LinkedHashMap<String, Integer>(enumMap);
            this.ordinalToName = new LinkedHashMap<Integer, String>(enumMap.size());
            for (Map.Entry entry : this.nameToOrdinal.entrySet()) {
                this.ordinalToName.put((Integer)entry.getValue(), (String)entry.getKey());
            }
        }
    }

    public int typeId() {
        return this.typeId;
    }

    public String typeName() {
        return this.typeName;
    }

    public Collection<String> fields() {
        return this.fields != null ? this.fields.keySet() : Collections.emptyList();
    }

    public Map<String, BinaryFieldMetadata> fieldsMap() {
        return this.fields != null ? this.fields : Collections.emptyMap();
    }

    @Nullable
    public String fieldTypeName(String fieldName) {
        BinaryFieldMetadata meta = this.fields != null ? this.fields.get(fieldName) : null;
        return meta != null ? BinaryUtils.fieldTypeName(meta.typeId()) : null;
    }

    @Nullable
    public String affinityKeyFieldName() {
        return this.affKeyFieldName;
    }

    public Collection<BinarySchema> schemas() {
        return this.schemas != null ? this.schemas : Collections.emptyList();
    }

    public boolean hasSchema(int schemaId) {
        if (this.schemaIds == null) {
            return false;
        }
        return this.schemaIds.contains(schemaId);
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public BinaryTypeImpl wrap(BinaryContext ctx) {
        return new BinaryTypeImpl(ctx, this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeTo(out);
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeByte(1);
        out.writeInt(this.typeId);
        U.writeString(out, this.typeName);
        if (this.fields == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.fields.size());
            for (Map.Entry<String, BinaryFieldMetadata> fieldEntry : this.fields.entrySet()) {
                U.writeString(out, fieldEntry.getKey());
                fieldEntry.getValue().writeTo(out);
            }
        }
        U.writeString(out, this.affKeyFieldName);
        if (this.schemas == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.schemas.size());
            for (BinarySchema schema : this.schemas) {
                schema.writeTo(out);
            }
        }
        out.writeBoolean(this.isEnum);
        if (this.isEnum) {
            Map<String, Integer> map = this.enumMap();
            out.writeInt(map.size());
            for (Map.Entry<String, Integer> e : map.entrySet()) {
                U.writeString(out, e.getKey());
                out.writeInt(e.getValue());
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readFrom(in);
    }

    public void readFrom(DataInput in) throws IOException {
        int size;
        in.readByte();
        this.typeId = in.readInt();
        this.typeName = U.readString(in);
        int fieldsSize = in.readInt();
        if (fieldsSize == -1) {
            this.fields = null;
        } else {
            this.fields = new HashMap<String, BinaryFieldMetadata>();
            for (int i = 0; i < fieldsSize; ++i) {
                String fieldName = U.readString(in);
                BinaryFieldMetadata fieldMeta = new BinaryFieldMetadata();
                fieldMeta.readFrom(in);
                this.fields.put(fieldName, fieldMeta);
            }
        }
        this.affKeyFieldName = U.readString(in);
        int schemasSize = in.readInt();
        if (schemasSize == -1) {
            this.schemas = null;
            this.schemaIds = Collections.emptySet();
        } else {
            this.schemas = new ArrayList<BinarySchema>();
            this.schemaIds = U.newHashSet(schemasSize);
            for (int i = 0; i < schemasSize; ++i) {
                BinarySchema schema = new BinarySchema();
                schema.readFrom(in);
                this.schemas.add(schema);
                this.schemaIds.add(schema.schemaId());
            }
        }
        this.isEnum = in.readBoolean();
        if (this.isEnum && (size = in.readInt()) >= 0) {
            this.ordinalToName = new LinkedHashMap<Integer, String>(size);
            this.nameToOrdinal = new LinkedHashMap<String, Integer>(size);
            for (int idx = 0; idx < size; ++idx) {
                String name = U.readString(in);
                int ord = in.readInt();
                this.ordinalToName.put(ord, name);
                this.nameToOrdinal.put(name, ord);
            }
        }
    }

    public String getEnumNameByOrdinal(int ord) {
        if (this.ordinalToName == null) {
            return null;
        }
        return this.ordinalToName.get(ord);
    }

    public Integer getEnumOrdinalByName(String name) {
        assert (name != null);
        return this.nameToOrdinal.get(name);
    }

    public Map<String, Integer> enumMap() {
        if (this.nameToOrdinal == null) {
            return Collections.emptyMap();
        }
        return this.nameToOrdinal;
    }

    public String toString() {
        return S.toString(BinaryMetadata.class, this);
    }
}

