/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.client.ClientAtomicConfiguration;
import org.apache.ignite.client.ClientAtomicLong;
import org.apache.ignite.client.ClientCache;
import org.apache.ignite.client.ClientCacheConfiguration;
import org.apache.ignite.client.ClientCluster;
import org.apache.ignite.client.ClientClusterGroup;
import org.apache.ignite.client.ClientCompute;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.ClientServices;
import org.apache.ignite.client.ClientTransactions;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.client.IgniteClientFuture;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.configuration.ClientTransactionConfiguration;
import org.apache.ignite.internal.binary.BinaryCachingMetadataHandler;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryMetadataHandler;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryTypeImpl;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.streams.BinaryInputStream;
import org.apache.ignite.internal.binary.streams.BinaryOutputStream;
import org.apache.ignite.internal.client.thin.ClientAtomicLongImpl;
import org.apache.ignite.internal.client.thin.ClientBinary;
import org.apache.ignite.internal.client.thin.ClientBinaryMarshaller;
import org.apache.ignite.internal.client.thin.ClientCacheEntryListenersRegistry;
import org.apache.ignite.internal.client.thin.ClientChannel;
import org.apache.ignite.internal.client.thin.ClientChannelConfiguration;
import org.apache.ignite.internal.client.thin.ClientClusterGroupImpl;
import org.apache.ignite.internal.client.thin.ClientClusterImpl;
import org.apache.ignite.internal.client.thin.ClientComputeImpl;
import org.apache.ignite.internal.client.thin.ClientFieldsQueryCursor;
import org.apache.ignite.internal.client.thin.ClientFieldsQueryPager;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientServicesImpl;
import org.apache.ignite.internal.client.thin.ClientUtils;
import org.apache.ignite.internal.client.thin.IgniteClientFutureImpl;
import org.apache.ignite.internal.client.thin.PayloadOutputChannel;
import org.apache.ignite.internal.client.thin.ReliableChannel;
import org.apache.ignite.internal.client.thin.TcpClientCache;
import org.apache.ignite.internal.client.thin.TcpClientChannel;
import org.apache.ignite.internal.client.thin.TcpClientTransactions;
import org.apache.ignite.internal.client.thin.io.ClientConnectionMultiplexer;
import org.apache.ignite.internal.util.GridArgumentCheck;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.marshaller.MarshallerContext;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;

public class TcpIgniteClient
implements IgniteClient {
    private final ReliableChannel ch;
    private final IgniteBinary binary;
    private final TcpClientTransactions transactions;
    private final ClientComputeImpl compute;
    private final ClientClusterImpl cluster;
    private final ClientServicesImpl services;
    private final ClientCacheEntryListenersRegistry lsnrsRegistry;
    private final ClientBinaryMarshaller marsh;
    private final ClientUtils serDes;

    private TcpIgniteClient(ClientConfiguration cfg) throws ClientException {
        this(TcpClientChannel::new, cfg);
    }

    TcpIgniteClient(BiFunction<ClientChannelConfiguration, ClientConnectionMultiplexer, ClientChannel> chFactory, ClientConfiguration cfg) throws ClientException {
        ClientBinaryMetadataHandler metadataHnd = new ClientBinaryMetadataHandler();
        ClientMarshallerContext marshCtx = new ClientMarshallerContext();
        this.marsh = new ClientBinaryMarshaller(metadataHnd, marshCtx);
        this.marsh.setBinaryConfiguration(cfg.getBinaryConfiguration());
        this.serDes = new ClientUtils(this.marsh);
        this.binary = new ClientBinary(this.marsh);
        this.ch = new ReliableChannel(chFactory, cfg, this.binary);
        try {
            this.ch.channelsInit();
            this.ch.addChannelFailListener(() -> {
                metadataHnd.onReconnect();
                marshCtx.clearUserTypesCache();
                this.marsh.context().unregisterUserTypeDescriptors();
            });
            metadataHnd.sendAllMeta();
            this.transactions = new TcpClientTransactions(this.ch, this.marsh, new ClientTransactionConfiguration(cfg.getTransactionConfiguration()));
            this.cluster = new ClientClusterImpl(this.ch, this.marsh);
            this.compute = new ClientComputeImpl(this.ch, this.marsh, this.cluster.defaultClusterGroup());
            this.services = new ClientServicesImpl(this.ch, this.marsh, this.cluster.defaultClusterGroup());
            this.lsnrsRegistry = new ClientCacheEntryListenersRegistry();
        }
        catch (Exception e) {
            this.ch.close();
            throw e;
        }
    }

    @Override
    public void close() {
        this.ch.close();
    }

    @Override
    public <K, V> ClientCache<K, V> getOrCreateCache(String name) throws ClientException {
        TcpIgniteClient.ensureCacheName(name);
        this.ch.request(ClientOperation.CACHE_GET_OR_CREATE_WITH_NAME, req -> this.writeString(name, req.out()));
        return new TcpClientCache(name, this.ch, this.marsh, this.transactions, this.lsnrsRegistry);
    }

    @Override
    public <K, V> IgniteClientFuture<ClientCache<K, V>> getOrCreateCacheAsync(String name) throws ClientException {
        TcpIgniteClient.ensureCacheName(name);
        return new IgniteClientFutureImpl<ClientCache<K, V>>(this.ch.requestAsync(ClientOperation.CACHE_GET_OR_CREATE_WITH_NAME, req -> this.writeString(name, req.out())).thenApply(x -> new TcpClientCache(name, this.ch, this.marsh, this.transactions, this.lsnrsRegistry)));
    }

    @Override
    public <K, V> ClientCache<K, V> getOrCreateCache(ClientCacheConfiguration cfg) throws ClientException {
        TcpIgniteClient.ensureCacheConfiguration(cfg);
        this.ch.request(ClientOperation.CACHE_GET_OR_CREATE_WITH_CONFIGURATION, req -> this.serDes.cacheConfiguration(cfg, req.out(), req.clientChannel().protocolCtx()));
        return new TcpClientCache(cfg.getName(), this.ch, this.marsh, this.transactions, this.lsnrsRegistry);
    }

    @Override
    public <K, V> IgniteClientFuture<ClientCache<K, V>> getOrCreateCacheAsync(ClientCacheConfiguration cfg) throws ClientException {
        TcpIgniteClient.ensureCacheConfiguration(cfg);
        return new IgniteClientFutureImpl<ClientCache<K, V>>(this.ch.requestAsync(ClientOperation.CACHE_GET_OR_CREATE_WITH_CONFIGURATION, req -> this.serDes.cacheConfiguration(cfg, req.out(), req.clientChannel().protocolCtx())).thenApply(x -> new TcpClientCache(cfg.getName(), this.ch, this.marsh, this.transactions, this.lsnrsRegistry)));
    }

    @Override
    public <K, V> ClientCache<K, V> cache(String name) {
        TcpIgniteClient.ensureCacheName(name);
        return new TcpClientCache(name, this.ch, this.marsh, this.transactions, this.lsnrsRegistry);
    }

    @Override
    public Collection<String> cacheNames() throws ClientException {
        return this.ch.service(ClientOperation.CACHE_GET_NAMES, res -> Arrays.asList(BinaryUtils.doReadStringArray(res.in())));
    }

    @Override
    public IgniteClientFuture<Collection<String>> cacheNamesAsync() throws ClientException {
        return this.ch.serviceAsync(ClientOperation.CACHE_GET_NAMES, res -> Arrays.asList(BinaryUtils.doReadStringArray(res.in())));
    }

    @Override
    public void destroyCache(String name) throws ClientException {
        TcpIgniteClient.ensureCacheName(name);
        this.ch.request(ClientOperation.CACHE_DESTROY, req -> req.out().writeInt(ClientUtils.cacheId(name)));
    }

    @Override
    public IgniteClientFuture<Void> destroyCacheAsync(String name) throws ClientException {
        TcpIgniteClient.ensureCacheName(name);
        return this.ch.requestAsync(ClientOperation.CACHE_DESTROY, req -> req.out().writeInt(ClientUtils.cacheId(name)));
    }

    @Override
    public <K, V> ClientCache<K, V> createCache(String name) throws ClientException {
        TcpIgniteClient.ensureCacheName(name);
        this.ch.request(ClientOperation.CACHE_CREATE_WITH_NAME, req -> this.writeString(name, req.out()));
        return new TcpClientCache(name, this.ch, this.marsh, this.transactions, this.lsnrsRegistry);
    }

    @Override
    public <K, V> IgniteClientFuture<ClientCache<K, V>> createCacheAsync(String name) throws ClientException {
        TcpIgniteClient.ensureCacheName(name);
        return new IgniteClientFutureImpl<ClientCache<K, V>>(this.ch.requestAsync(ClientOperation.CACHE_CREATE_WITH_NAME, req -> this.writeString(name, req.out())).thenApply(x -> new TcpClientCache(name, this.ch, this.marsh, this.transactions, this.lsnrsRegistry)));
    }

    @Override
    public <K, V> ClientCache<K, V> createCache(ClientCacheConfiguration cfg) throws ClientException {
        TcpIgniteClient.ensureCacheConfiguration(cfg);
        this.ch.request(ClientOperation.CACHE_CREATE_WITH_CONFIGURATION, req -> this.serDes.cacheConfiguration(cfg, req.out(), req.clientChannel().protocolCtx()));
        return new TcpClientCache(cfg.getName(), this.ch, this.marsh, this.transactions, this.lsnrsRegistry);
    }

    @Override
    public <K, V> IgniteClientFuture<ClientCache<K, V>> createCacheAsync(ClientCacheConfiguration cfg) throws ClientException {
        TcpIgniteClient.ensureCacheConfiguration(cfg);
        return new IgniteClientFutureImpl<ClientCache<K, V>>(this.ch.requestAsync(ClientOperation.CACHE_CREATE_WITH_CONFIGURATION, req -> this.serDes.cacheConfiguration(cfg, req.out(), req.clientChannel().protocolCtx())).thenApply(x -> new TcpClientCache(cfg.getName(), this.ch, this.marsh, this.transactions, this.lsnrsRegistry)));
    }

    @Override
    public IgniteBinary binary() {
        return this.binary;
    }

    @Override
    public FieldsQueryCursor<List<?>> query(SqlFieldsQuery qry) {
        if (qry == null) {
            throw new NullPointerException("qry");
        }
        Consumer<PayloadOutputChannel> qryWriter = payloadCh -> {
            BinaryOutputStream out = payloadCh.out();
            out.writeInt(0);
            out.writeByte((byte)1);
            this.serDes.write(qry, out, payloadCh.clientChannel().protocolCtx());
        };
        return new ClientFieldsQueryCursor(new ClientFieldsQueryPager(this.ch, ClientOperation.QUERY_SQL_FIELDS, ClientOperation.QUERY_SQL_FIELDS_CURSOR_GET_PAGE, qryWriter, true, this.marsh));
    }

    @Override
    public ClientTransactions transactions() {
        return this.transactions;
    }

    @Override
    public ClientCompute compute() {
        return this.compute;
    }

    @Override
    public ClientCompute compute(ClientClusterGroup grp) {
        return this.compute.withClusterGroup((ClientClusterGroupImpl)grp);
    }

    @Override
    public ClientCluster cluster() {
        return this.cluster;
    }

    @Override
    public ClientServices services() {
        return this.services;
    }

    @Override
    public ClientServices services(ClientClusterGroup grp) {
        return this.services.withClusterGroup((ClientClusterGroupImpl)grp);
    }

    @Override
    public ClientAtomicLong atomicLong(String name, long initVal, boolean create) {
        return this.atomicLong(name, null, initVal, create);
    }

    @Override
    public ClientAtomicLong atomicLong(String name, ClientAtomicConfiguration cfg, long initVal, boolean create) {
        GridArgumentCheck.notNull(name, "name");
        if (create) {
            this.ch.service(ClientOperation.ATOMIC_LONG_CREATE, out -> {
                try (BinaryWriterExImpl w = new BinaryWriterExImpl(null, out.out(), null, null);){
                    w.writeString(name);
                    w.writeLong(initVal);
                    if (cfg != null) {
                        w.writeBoolean(true);
                        w.writeInt(cfg.getAtomicSequenceReserveSize());
                        w.writeByte((byte)cfg.getCacheMode().ordinal());
                        w.writeInt(cfg.getBackups());
                        w.writeString(cfg.getGroupName());
                    } else {
                        w.writeBoolean(false);
                    }
                }
            }, null);
        }
        ClientAtomicLongImpl res = new ClientAtomicLongImpl(name, cfg != null ? cfg.getGroupName() : null, this.ch);
        if (!create && res.removed()) {
            return null;
        }
        return res;
    }

    public static IgniteClient start(ClientConfiguration cfg) throws ClientException {
        return new TcpIgniteClient(cfg);
    }

    private static void ensureCacheName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Cache name must be specified");
        }
    }

    private static void ensureCacheConfiguration(ClientCacheConfiguration cfg) {
        if (cfg == null) {
            throw new IllegalArgumentException("Cache configuration must be specified");
        }
        TcpIgniteClient.ensureCacheName(cfg.getName());
    }

    private void writeString(String s, BinaryOutputStream out) {
        try (BinaryWriterExImpl w = new BinaryWriterExImpl(this.marsh.context(), out, null, null);){
            w.writeString(s);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readString(BinaryInputStream in) throws BinaryObjectException {
        try (BinaryReaderExImpl r = this.serDes.createBinaryReader(in);){
            String string = r.readString();
            return string;
        }
        catch (IOException e) {
            throw new BinaryObjectException(e);
        }
    }

    private class ClientMarshallerContext
    implements MarshallerContext {
        private final Map<Integer, String> cache = new ConcurrentHashMap<Integer, String>();
        private final Collection<String> sysTypes = new HashSet<String>();

        public ClientMarshallerContext() {
            try {
                MarshallerUtils.processSystemClasses(U.gridClassLoader(), null, this.sysTypes::add);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to initialize marshaller context.", e);
            }
        }

        @Override
        public boolean registerClassName(byte platformId, int typeId, String clsName, boolean failIfUnregistered) throws IgniteCheckedException {
            if (platformId != 0) {
                throw new IllegalArgumentException("platformId");
            }
            boolean res = true;
            if (!this.cache.containsKey(typeId)) {
                try {
                    res = TcpIgniteClient.this.ch.service(ClientOperation.REGISTER_BINARY_TYPE_NAME, payloadCh -> {
                        BinaryOutputStream out = payloadCh.out();
                        out.writeByte(platformId);
                        out.writeInt(typeId);
                        TcpIgniteClient.this.writeString(clsName, out);
                    }, payloadCh -> payloadCh.in().readBoolean());
                }
                catch (ClientException e) {
                    throw new IgniteCheckedException(e);
                }
                if (res) {
                    this.cache.put(typeId, clsName);
                }
            }
            return res;
        }

        @Override
        @Deprecated
        public boolean registerClassName(byte platformId, int typeId, String clsName) throws IgniteCheckedException {
            return this.registerClassName(platformId, typeId, clsName, false);
        }

        @Override
        public boolean registerClassNameLocally(byte platformId, int typeId, String clsName) {
            if (platformId != 0) {
                throw new IllegalArgumentException("platformId");
            }
            this.cache.put(typeId, clsName);
            return true;
        }

        @Override
        public Class getClass(int typeId, ClassLoader ldr) throws ClassNotFoundException, IgniteCheckedException {
            return U.forName(this.getClassName((byte)0, typeId), ldr, null);
        }

        @Override
        public String getClassName(byte platformId, int typeId) throws ClassNotFoundException, IgniteCheckedException {
            if (platformId != 0) {
                throw new IllegalArgumentException("platformId");
            }
            String clsName = this.cache.get(typeId);
            if (clsName == null) {
                try {
                    clsName = TcpIgniteClient.this.ch.service(ClientOperation.GET_BINARY_TYPE_NAME, req -> {
                        BinaryOutputStream out = req.out();
                        out.writeByte(platformId);
                        out.writeInt(typeId);
                    }, res -> TcpIgniteClient.this.readString(res.in()));
                }
                catch (ClientException e) {
                    throw new IgniteCheckedException(e);
                }
                if (clsName != null) {
                    this.cache.putIfAbsent(typeId, clsName);
                }
            }
            if (clsName == null) {
                throw new ClassNotFoundException(String.format("Unknown type id [%s]", typeId));
            }
            return clsName;
        }

        @Override
        public boolean isSystemType(String typeName) {
            return this.sysTypes.contains(typeName);
        }

        @Override
        public IgnitePredicate<String> classNameFilter() {
            return null;
        }

        @Override
        public JdkMarshaller jdkMarshaller() {
            return new JdkMarshaller();
        }

        void clearUserTypesCache() {
            this.cache.clear();
        }
    }

    private class ClientBinaryMetadataHandler
    implements BinaryMetadataHandler {
        private volatile BinaryMetadataHandler cache = BinaryCachingMetadataHandler.create();

        private ClientBinaryMetadataHandler() {
        }

        @Override
        public void addMeta(int typeId, BinaryType meta, boolean failIfUnregistered) throws BinaryObjectException {
            BinaryType oldType = this.cache.metadata(typeId);
            BinaryMetadata oldMeta = oldType == null ? null : ((BinaryTypeImpl)oldType).metadata();
            BinaryMetadata newMeta = ((BinaryTypeImpl)meta).metadata();
            if (oldType == null || BinaryUtils.mergeMetadata(oldMeta, newMeta) != oldMeta) {
                try {
                    if (TcpIgniteClient.this.ch != null) {
                        TcpIgniteClient.this.ch.request(ClientOperation.PUT_BINARY_TYPE, req -> TcpIgniteClient.this.serDes.binaryMetadata(newMeta, req.out()));
                    }
                }
                catch (ClientException e) {
                    throw new BinaryObjectException(e);
                }
            }
            this.cache.addMeta(typeId, meta, failIfUnregistered);
        }

        public void sendAllMeta() {
            try {
                CompletableFuture.allOf((CompletableFuture[])this.cache.metadata().stream().map(type -> this.sendMetaAsync(((BinaryTypeImpl)type).metadata()).toCompletableFuture()).toArray(CompletableFuture[]::new)).get();
            }
            catch (Exception e) {
                throw new ClientException(e);
            }
        }

        private IgniteClientFuture<Void> sendMetaAsync(BinaryMetadata meta) {
            return TcpIgniteClient.this.ch.requestAsync(ClientOperation.PUT_BINARY_TYPE, req -> TcpIgniteClient.this.serDes.binaryMetadata(meta, req.out()));
        }

        @Override
        public void addMetaLocally(int typeId, BinaryType meta, boolean failIfUnregistered) throws BinaryObjectException {
            throw new UnsupportedOperationException("Can't register metadata locally for thin client.");
        }

        @Override
        public BinaryType metadata(int typeId) throws BinaryObjectException {
            BinaryType meta = this.cache.metadata(typeId);
            if (meta == null) {
                meta = this.requestAndCacheBinaryType(typeId);
            }
            return meta;
        }

        @Override
        public BinaryMetadata metadata0(int typeId) throws BinaryObjectException {
            BinaryMetadata meta = this.cache.metadata0(typeId);
            if (meta == null) {
                meta = this.requestBinaryMetadata(typeId);
            }
            return meta;
        }

        @Override
        public BinaryType metadata(int typeId, int schemaId) throws BinaryObjectException {
            BinaryType meta = this.cache.metadata(typeId);
            if (this.hasSchema(meta, schemaId)) {
                return meta;
            }
            meta = this.requestAndCacheBinaryType(typeId);
            return this.hasSchema(meta, schemaId) ? meta : null;
        }

        @Override
        public Collection<BinaryType> metadata() throws BinaryObjectException {
            return this.cache.metadata();
        }

        private boolean hasSchema(BinaryType type, int schemaId) {
            return type != null && ((BinaryTypeImpl)type).metadata().hasSchema(schemaId);
        }

        private BinaryType requestAndCacheBinaryType(int typeId) throws BinaryObjectException {
            BinaryMetadata meta0 = this.requestBinaryMetadata(typeId);
            if (meta0 == null) {
                return null;
            }
            BinaryTypeImpl meta = new BinaryTypeImpl(TcpIgniteClient.this.marsh.context(), meta0);
            this.cache.addMeta(typeId, meta, false);
            return meta;
        }

        private BinaryMetadata requestBinaryMetadata(int typeId) throws BinaryObjectException {
            try {
                return TcpIgniteClient.this.ch.service(ClientOperation.GET_BINARY_TYPE, req -> req.out().writeInt(typeId), res -> {
                    try {
                        return res.in().readBoolean() ? TcpIgniteClient.this.serDes.binaryMetadata(res.in()) : null;
                    }
                    catch (IOException e) {
                        throw new BinaryObjectException(e);
                    }
                });
            }
            catch (ClientException e) {
                throw new BinaryObjectException(e);
            }
        }

        void onReconnect() {
            this.cache = BinaryCachingMetadataHandler.create();
        }
    }
}

