/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCluster;
import org.apache.ignite.IgniteException;
import org.apache.ignite.ShutdownPolicy;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterStartNodeResult;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.AsyncSupportAdapter;
import org.apache.ignite.internal.cluster.IgniteClusterImpl;
import org.apache.ignite.internal.processors.cluster.baseline.autoadjust.BaselineAutoAdjustStatus;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class IgniteClusterAsyncImpl
extends AsyncSupportAdapter<IgniteCluster>
implements IgniteCluster,
Externalizable {
    private static final long serialVersionUID = 0L;
    private IgniteClusterImpl cluster;

    public IgniteClusterAsyncImpl() {
    }

    public IgniteClusterAsyncImpl(IgniteClusterImpl cluster) {
        super(true);
        this.cluster = cluster;
    }

    @Override
    public ClusterNode localNode() {
        return this.cluster.localNode();
    }

    @Override
    public ClusterGroup forLocal() {
        return this.cluster.forLocal();
    }

    @Override
    public <K, V> ConcurrentMap<K, V> nodeLocalMap() {
        return this.cluster.nodeLocalMap();
    }

    @Override
    public boolean pingNode(UUID nodeId) {
        return this.cluster.pingNode(nodeId);
    }

    @Override
    public long topologyVersion() {
        return this.cluster.topologyVersion();
    }

    @Override
    @Nullable
    public Collection<ClusterNode> topology(long topVer) {
        return this.cluster.topology(topVer);
    }

    @Override
    public Collection<ClusterStartNodeResult> startNodes(File file, boolean restart, int timeout, int maxConn) {
        try {
            return this.saveOrGet(this.cluster.startNodesAsync0(file, restart, timeout, maxConn));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public IgniteFuture<Collection<ClusterStartNodeResult>> startNodesAsync(File file, boolean restart, int timeout, int maxConn) throws IgniteException {
        return this.cluster.startNodesAsync(file, restart, timeout, maxConn);
    }

    @Override
    public Collection<ClusterStartNodeResult> startNodes(Collection<Map<String, Object>> hosts, @Nullable Map<String, Object> dflts, boolean restart, int timeout, int maxConn) {
        try {
            return this.saveOrGet(this.cluster.startNodesAsync0(hosts, dflts, restart, timeout, maxConn));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public IgniteFuture<Collection<ClusterStartNodeResult>> startNodesAsync(Collection<Map<String, Object>> hosts, @Nullable Map<String, Object> dflts, boolean restart, int timeout, int maxConn) throws IgniteException {
        return this.cluster.startNodesAsync(hosts, dflts, restart, timeout, maxConn);
    }

    @Override
    public void stopNodes() {
        this.cluster.stopNodes();
    }

    @Override
    public void stopNodes(Collection<UUID> ids) {
        this.cluster.stopNodes(ids);
    }

    @Override
    public void restartNodes() {
        this.cluster.restartNodes();
    }

    @Override
    public void restartNodes(Collection<UUID> ids) {
        this.cluster.restartNodes(ids);
    }

    @Override
    public void resetMetrics() {
        this.cluster.resetMetrics();
    }

    @Override
    public void enableStatistics(Collection<String> caches, boolean enabled) {
        this.cluster.enableStatistics(caches, enabled);
    }

    @Override
    public void clearStatistics(Collection<String> caches) {
        this.cluster.clearStatistics(caches);
    }

    @Override
    public void setTxTimeoutOnPartitionMapExchange(long timeout) {
        this.cluster.setTxTimeoutOnPartitionMapExchange(timeout);
    }

    @Override
    public Ignite ignite() {
        return this.cluster.ignite();
    }

    @Override
    public ClusterGroup forNodes(Collection<? extends ClusterNode> nodes) {
        return this.cluster.forNodes(nodes);
    }

    @Override
    public ClusterGroup forNode(ClusterNode node, ClusterNode ... nodes) {
        return this.cluster.forNode(node, nodes);
    }

    @Override
    public ClusterGroup forOthers(ClusterNode node, ClusterNode ... nodes) {
        return this.cluster.forOthers(node, nodes);
    }

    @Override
    public ClusterGroup forOthers(ClusterGroup prj) {
        return this.cluster.forOthers(prj);
    }

    @Override
    public ClusterGroup forNodeIds(Collection<UUID> ids) {
        return this.cluster.forNodeIds(ids);
    }

    @Override
    public ClusterGroup forNodeId(UUID id, UUID ... ids) {
        return this.cluster.forNodeId(id, ids);
    }

    @Override
    public ClusterGroup forPredicate(IgnitePredicate<ClusterNode> p) {
        return this.cluster.forPredicate(p);
    }

    @Override
    public ClusterGroup forAttribute(String name, @Nullable Object val) {
        return this.cluster.forAttribute(name, val);
    }

    @Override
    public ClusterGroup forServers() {
        return this.cluster.forServers();
    }

    @Override
    public ClusterGroup forClients() {
        return this.cluster.forClients();
    }

    @Override
    public ClusterGroup forCacheNodes(String cacheName) {
        return this.cluster.forCacheNodes(cacheName);
    }

    @Override
    public ClusterGroup forDataNodes(String cacheName) {
        return this.cluster.forDataNodes(cacheName);
    }

    @Override
    public ClusterGroup forClientNodes(String cacheName) {
        return this.cluster.forClientNodes(cacheName);
    }

    @Override
    public ClusterGroup forRemotes() {
        return this.cluster.forRemotes();
    }

    @Override
    public ClusterGroup forHost(ClusterNode node) {
        return this.cluster.forHost(node);
    }

    @Override
    public ClusterGroup forHost(String host, String ... hosts) {
        return this.cluster.forHost(host, hosts);
    }

    @Override
    public ClusterGroup forDaemons() {
        return this.cluster.forDaemons();
    }

    @Override
    public ClusterGroup forRandom() {
        return this.cluster.forRandom();
    }

    @Override
    public ClusterGroup forOldest() {
        return this.cluster.forOldest();
    }

    @Override
    public ClusterGroup forYoungest() {
        return this.cluster.forYoungest();
    }

    @Override
    public Collection<ClusterNode> nodes() {
        return this.cluster.nodes();
    }

    @Override
    @Nullable
    public ClusterNode node(UUID id) {
        return this.cluster.node(id);
    }

    @Override
    public Collection<String> hostNames() {
        return this.cluster.hostNames();
    }

    @Override
    @Nullable
    public ClusterNode node() {
        return this.cluster.node();
    }

    @Override
    public IgnitePredicate<ClusterNode> predicate() {
        return this.cluster.predicate();
    }

    @Override
    public ClusterMetrics metrics() {
        return this.cluster.metrics();
    }

    @Override
    public boolean active() {
        return false;
    }

    @Override
    public void active(boolean active) {
    }

    @Override
    @Nullable
    public Collection<BaselineNode> currentBaselineTopology() {
        return null;
    }

    @Override
    public void setBaselineTopology(Collection<? extends BaselineNode> baselineTop) {
    }

    @Override
    public void setBaselineTopology(long topVer) {
    }

    @Override
    @Nullable
    public IgniteFuture<?> clientReconnectFuture() {
        return this.cluster.clientReconnectFuture();
    }

    @Override
    public boolean enableWal(String cacheName) throws IgniteException {
        return this.cluster.enableWal(cacheName);
    }

    @Override
    public boolean disableWal(String cacheName) throws IgniteException {
        return this.cluster.disableWal(cacheName);
    }

    @Override
    public boolean isWalEnabled(String cacheName) {
        return this.cluster.isWalEnabled(cacheName);
    }

    @Override
    public UUID id() {
        return this.cluster.id();
    }

    @Override
    public void id(UUID id) {
        this.cluster.id(id);
    }

    @Override
    public String tag() {
        return this.cluster.tag();
    }

    @Override
    public void tag(String tag) {
        this.cluster.tag(tag);
    }

    @Override
    public boolean isBaselineAutoAdjustEnabled() {
        return this.cluster.isBaselineAutoAdjustEnabled();
    }

    @Override
    public void baselineAutoAdjustEnabled(boolean baselineAutoAdjustEnabled) throws IgniteException {
        this.cluster.baselineAutoAdjustEnabled(baselineAutoAdjustEnabled);
    }

    @Override
    public long baselineAutoAdjustTimeout() {
        return this.cluster.baselineAutoAdjustTimeout();
    }

    @Override
    public void baselineAutoAdjustTimeout(long baselineAutoAdjustTimeout) throws IgniteException {
        this.cluster.baselineAutoAdjustTimeout(baselineAutoAdjustTimeout);
    }

    @Override
    public BaselineAutoAdjustStatus baselineAutoAdjustStatus() {
        return this.cluster.baselineAutoAdjustStatus();
    }

    @Override
    public ShutdownPolicy shutdownPolicy() {
        return this.cluster.shutdownPolicy();
    }

    @Override
    public void shutdownPolicy(ShutdownPolicy policy) {
        this.cluster.shutdownPolicy(policy);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cluster = (IgniteClusterImpl)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cluster);
    }

    @Override
    public ClusterState state() {
        return this.cluster.state();
    }

    @Override
    public void state(ClusterState newState) throws IgniteException {
        this.cluster.state(newState);
    }
}

