/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record;

import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public abstract class WALRecord {
    private int size;
    private int chainSize;
    @GridToStringExclude
    private WALRecord prev;
    private WALPointer pos;

    public void chainSize(int chainSize) {
        this.chainSize = chainSize;
    }

    public int chainSize() {
        return this.chainSize;
    }

    public WALRecord previous() {
        return this.prev;
    }

    public void previous(WALRecord prev) {
        this.prev = prev;
    }

    public WALPointer position() {
        return this.pos;
    }

    public void position(WALPointer pos) {
        assert (pos != null);
        this.pos = pos;
    }

    public int size() {
        return this.size;
    }

    public void size(int size) {
        assert (size >= 0) : size;
        this.size = size;
    }

    public abstract RecordType type();

    public String toString() {
        return S.toString(WALRecord.class, this, "type", (Object)this.type());
    }

    public static enum RecordPurpose {
        INTERNAL,
        PHYSICAL,
        LOGICAL,
        MIXED,
        CUSTOM;

    }

    public static final class RecordType
    extends Enum<RecordType> {
        public static final /* enum */ RecordType TX_RECORD = new RecordType(0, RecordPurpose.LOGICAL);
        public static final /* enum */ RecordType PAGE_RECORD = new RecordType(1, RecordPurpose.PHYSICAL);
        @Deprecated
        public static final /* enum */ RecordType DATA_RECORD = new RecordType(2, RecordPurpose.LOGICAL);
        public static final /* enum */ RecordType CHECKPOINT_RECORD = new RecordType(3, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType HEADER_RECORD = new RecordType(4, RecordPurpose.INTERNAL);
        public static final /* enum */ RecordType INIT_NEW_PAGE_RECORD = new RecordType(5, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType DATA_PAGE_INSERT_RECORD = new RecordType(6, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType DATA_PAGE_INSERT_FRAGMENT_RECORD = new RecordType(7, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType DATA_PAGE_REMOVE_RECORD = new RecordType(8, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType DATA_PAGE_SET_FREE_LIST_PAGE = new RecordType(9, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType BTREE_META_PAGE_INIT_ROOT = new RecordType(10, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType BTREE_META_PAGE_ADD_ROOT = new RecordType(11, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType BTREE_META_PAGE_CUT_ROOT = new RecordType(12, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType BTREE_INIT_NEW_ROOT = new RecordType(13, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType BTREE_PAGE_RECYCLE = new RecordType(14, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType BTREE_PAGE_INSERT = new RecordType(15, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType BTREE_FIX_LEFTMOST_CHILD = new RecordType(16, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType BTREE_FIX_COUNT = new RecordType(17, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType BTREE_PAGE_REPLACE = new RecordType(18, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType BTREE_PAGE_REMOVE = new RecordType(19, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType BTREE_PAGE_INNER_REPLACE = new RecordType(20, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType BTREE_FIX_REMOVE_ID = new RecordType(21, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType BTREE_FORWARD_PAGE_SPLIT = new RecordType(22, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType BTREE_EXISTING_PAGE_SPLIT = new RecordType(23, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType BTREE_PAGE_MERGE = new RecordType(24, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType PAGES_LIST_SET_NEXT = new RecordType(25, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType PAGES_LIST_SET_PREVIOUS = new RecordType(26, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType PAGES_LIST_INIT_NEW_PAGE = new RecordType(27, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType PAGES_LIST_ADD_PAGE = new RecordType(28, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType PAGES_LIST_REMOVE_PAGE = new RecordType(29, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType META_PAGE_INIT = new RecordType(30, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType PARTITION_META_PAGE_UPDATE_COUNTERS = new RecordType(31, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType MEMORY_RECOVERY = new RecordType(32);
        public static final /* enum */ RecordType TRACKING_PAGE_DELTA = new RecordType(33, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType META_PAGE_UPDATE_LAST_SUCCESSFUL_SNAPSHOT_ID = new RecordType(34, RecordPurpose.MIXED);
        public static final /* enum */ RecordType META_PAGE_UPDATE_LAST_SUCCESSFUL_FULL_SNAPSHOT_ID = new RecordType(35, RecordPurpose.MIXED);
        public static final /* enum */ RecordType META_PAGE_UPDATE_NEXT_SNAPSHOT_ID = new RecordType(36, RecordPurpose.MIXED);
        public static final /* enum */ RecordType META_PAGE_UPDATE_LAST_ALLOCATED_INDEX = new RecordType(37, RecordPurpose.MIXED);
        public static final /* enum */ RecordType PART_META_UPDATE_STATE = new RecordType(38, RecordPurpose.MIXED);
        public static final /* enum */ RecordType PAGE_LIST_META_RESET_COUNT_RECORD = new RecordType(39, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType SWITCH_SEGMENT_RECORD = new RecordType(40, RecordPurpose.INTERNAL);
        public static final /* enum */ RecordType DATA_PAGE_UPDATE_RECORD = new RecordType(41, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType BTREE_META_PAGE_INIT_ROOT2 = new RecordType(42, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType PARTITION_DESTROY = new RecordType(43, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType SNAPSHOT = new RecordType(44);
        public static final /* enum */ RecordType METASTORE_DATA_RECORD = new RecordType(45, RecordPurpose.LOGICAL);
        public static final /* enum */ RecordType EXCHANGE = new RecordType(46);
        public static final /* enum */ RecordType RESERVED = new RecordType(47);
        public static final /* enum */ RecordType ROTATED_ID_PART_RECORD = new RecordType(48, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType MVCC_DATA_PAGE_MARK_UPDATED_RECORD = new RecordType(49, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType MVCC_DATA_PAGE_TX_STATE_HINT_UPDATED_RECORD = new RecordType(50, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType MVCC_DATA_PAGE_NEW_TX_STATE_HINT_UPDATED_RECORD = new RecordType(51, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType ENCRYPTED_RECORD = new RecordType(52, RecordPurpose.PHYSICAL);
        @Deprecated
        public static final /* enum */ RecordType ENCRYPTED_DATA_RECORD = new RecordType(53, RecordPurpose.LOGICAL);
        public static final /* enum */ RecordType MVCC_DATA_RECORD = new RecordType(54, RecordPurpose.LOGICAL);
        public static final /* enum */ RecordType MVCC_TX_RECORD = new RecordType(55, RecordPurpose.LOGICAL);
        public static final /* enum */ RecordType CONSISTENT_CUT = new RecordType(56);
        public static final /* enum */ RecordType ROLLBACK_TX_RECORD = new RecordType(57, RecordPurpose.LOGICAL);
        public static final /* enum */ RecordType PARTITION_META_PAGE_UPDATE_COUNTERS_V2 = new RecordType(58, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType BTREE_META_PAGE_INIT_ROOT_V3 = new RecordType(59, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType MASTER_KEY_CHANGE_RECORD = new RecordType(60, RecordPurpose.LOGICAL);
        public static final /* enum */ RecordType TRACKING_PAGE_REPAIR_DELTA = new RecordType(61, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType OUT_OF_ORDER_UPDATE = new RecordType(62, RecordPurpose.LOGICAL);
        public static final /* enum */ RecordType ENCRYPTED_RECORD_V2 = new RecordType(63, RecordPurpose.PHYSICAL);
        @Deprecated
        public static final /* enum */ RecordType ENCRYPTED_DATA_RECORD_V2 = new RecordType(64, RecordPurpose.LOGICAL);
        public static final /* enum */ RecordType MASTER_KEY_CHANGE_RECORD_V2 = new RecordType(65, RecordPurpose.LOGICAL);
        public static final /* enum */ RecordType REENCRYPTION_START_RECORD = new RecordType(66, RecordPurpose.LOGICAL);
        public static final /* enum */ RecordType PARTITION_META_PAGE_DELTA_RECORD_V3 = new RecordType(67, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType INDEX_META_PAGE_DELTA_RECORD = new RecordType(68, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType PARTITION_META_PAGE_DELTA_RECORD_V4 = new RecordType(69, RecordPurpose.PHYSICAL);
        public static final /* enum */ RecordType DATA_RECORD_V2 = new RecordType(70, RecordPurpose.LOGICAL);
        public static final /* enum */ RecordType ENCRYPTED_DATA_RECORD_V3 = new RecordType(71, RecordPurpose.LOGICAL);
        public static final /* enum */ RecordType INDEX_ROOT_PAGE_RENAME_RECORD = new RecordType(72, RecordPurpose.LOGICAL);
        public static final /* enum */ RecordType PARTITION_CLEARING_START_RECORD = new RecordType(73, RecordPurpose.LOGICAL);
        private final int idx;
        private final RecordPurpose purpose;
        private static final RecordType[] VALS;
        public static final int STOP_ITERATION_RECORD_TYPE = 0;
        private static final /* synthetic */ RecordType[] $VALUES;

        public static RecordType[] values() {
            return (RecordType[])$VALUES.clone();
        }

        public static RecordType valueOf(String name) {
            return Enum.valueOf(RecordType.class, name);
        }

        private RecordType(int idx, RecordPurpose purpose) {
            assert (idx >= 0) : idx;
            this.idx = idx;
            this.purpose = purpose;
        }

        private RecordType(int idx) {
            this(idx, RecordPurpose.CUSTOM);
        }

        public int index() {
            return this.idx;
        }

        public RecordPurpose purpose() {
            return this.purpose;
        }

        public static RecordType fromIndex(int idx) {
            return idx < 0 || idx >= VALS.length ? null : VALS[idx];
        }

        static {
            $VALUES = new RecordType[]{TX_RECORD, PAGE_RECORD, DATA_RECORD, CHECKPOINT_RECORD, HEADER_RECORD, INIT_NEW_PAGE_RECORD, DATA_PAGE_INSERT_RECORD, DATA_PAGE_INSERT_FRAGMENT_RECORD, DATA_PAGE_REMOVE_RECORD, DATA_PAGE_SET_FREE_LIST_PAGE, BTREE_META_PAGE_INIT_ROOT, BTREE_META_PAGE_ADD_ROOT, BTREE_META_PAGE_CUT_ROOT, BTREE_INIT_NEW_ROOT, BTREE_PAGE_RECYCLE, BTREE_PAGE_INSERT, BTREE_FIX_LEFTMOST_CHILD, BTREE_FIX_COUNT, BTREE_PAGE_REPLACE, BTREE_PAGE_REMOVE, BTREE_PAGE_INNER_REPLACE, BTREE_FIX_REMOVE_ID, BTREE_FORWARD_PAGE_SPLIT, BTREE_EXISTING_PAGE_SPLIT, BTREE_PAGE_MERGE, PAGES_LIST_SET_NEXT, PAGES_LIST_SET_PREVIOUS, PAGES_LIST_INIT_NEW_PAGE, PAGES_LIST_ADD_PAGE, PAGES_LIST_REMOVE_PAGE, META_PAGE_INIT, PARTITION_META_PAGE_UPDATE_COUNTERS, MEMORY_RECOVERY, TRACKING_PAGE_DELTA, META_PAGE_UPDATE_LAST_SUCCESSFUL_SNAPSHOT_ID, META_PAGE_UPDATE_LAST_SUCCESSFUL_FULL_SNAPSHOT_ID, META_PAGE_UPDATE_NEXT_SNAPSHOT_ID, META_PAGE_UPDATE_LAST_ALLOCATED_INDEX, PART_META_UPDATE_STATE, PAGE_LIST_META_RESET_COUNT_RECORD, SWITCH_SEGMENT_RECORD, DATA_PAGE_UPDATE_RECORD, BTREE_META_PAGE_INIT_ROOT2, PARTITION_DESTROY, SNAPSHOT, METASTORE_DATA_RECORD, EXCHANGE, RESERVED, ROTATED_ID_PART_RECORD, MVCC_DATA_PAGE_MARK_UPDATED_RECORD, MVCC_DATA_PAGE_TX_STATE_HINT_UPDATED_RECORD, MVCC_DATA_PAGE_NEW_TX_STATE_HINT_UPDATED_RECORD, ENCRYPTED_RECORD, ENCRYPTED_DATA_RECORD, MVCC_DATA_RECORD, MVCC_TX_RECORD, CONSISTENT_CUT, ROLLBACK_TX_RECORD, PARTITION_META_PAGE_UPDATE_COUNTERS_V2, BTREE_META_PAGE_INIT_ROOT_V3, MASTER_KEY_CHANGE_RECORD, TRACKING_PAGE_REPAIR_DELTA, OUT_OF_ORDER_UPDATE, ENCRYPTED_RECORD_V2, ENCRYPTED_DATA_RECORD_V2, MASTER_KEY_CHANGE_RECORD_V2, REENCRYPTION_START_RECORD, PARTITION_META_PAGE_DELTA_RECORD_V3, INDEX_META_PAGE_DELTA_RECORD, PARTITION_META_PAGE_DELTA_RECORD_V4, DATA_RECORD_V2, ENCRYPTED_DATA_RECORD_V3, INDEX_ROOT_PAGE_RENAME_RECORD, PARTITION_CLEARING_START_RECORD};
            RecordType[] recordTypes = RecordType.values();
            int maxIdx = 0;
            for (RecordType recordType : recordTypes) {
                maxIdx = Math.max(maxIdx, recordType.idx);
            }
            VALS = new RecordType[maxIdx + 1];
            RecordType[] recordTypeArray = recordTypes;
            int n = recordTypeArray.length;
            for (int i = 0; i < n; ++i) {
                RecordType recordType;
                RecordType.VALS[recordType.idx] = recordType = recordTypeArray[i];
            }
        }
    }
}

