/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectAdapter;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.jetbrains.annotations.Nullable;

public class CacheObjectImpl
extends CacheObjectAdapter {
    private static final long serialVersionUID = 0L;

    public CacheObjectImpl() {
    }

    public CacheObjectImpl(Object val, byte[] valBytes) {
        assert (val != null || valBytes != null);
        this.val = val;
        this.valBytes = valBytes;
    }

    @Override
    public boolean isPlatformType() {
        return true;
    }

    @Override
    @Nullable
    public <T> T value(CacheObjectValueContext ctx, boolean cpy) {
        return this.value(ctx, cpy, null);
    }

    @Override
    @Nullable
    public <T> T value(CacheObjectValueContext ctx, boolean cpy, ClassLoader ldr) {
        cpy = cpy && this.needCopy(ctx);
        try {
            GridKernalContext kernalCtx = ctx.kernalContext();
            IgniteCacheObjectProcessor proc = ctx.kernalContext().cacheObjects();
            if (cpy) {
                if (this.valBytes == null) {
                    assert (this.val != null);
                    this.valBytes = proc.marshal(ctx, this.val);
                }
                if (ldr == null) {
                    if (this.val != null) {
                        ldr = this.val.getClass().getClassLoader();
                    } else if (kernalCtx.config().isPeerClassLoadingEnabled()) {
                        ldr = kernalCtx.cache().context().deploy().globalLoader();
                    }
                }
                return (T)proc.unmarshal(ctx, this.valBytes, ldr);
            }
            if (this.val != null) {
                return (T)this.val;
            }
            assert (this.valBytes != null);
            Object val = proc.unmarshal(ctx, this.valBytes, kernalCtx.config().isPeerClassLoadingEnabled() ? kernalCtx.cache().context().deploy().globalLoader() : null);
            if (ctx.storeValue()) {
                this.val = val;
            }
            return (T)val;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to unmarshall object.", e);
        }
    }

    @Override
    public byte[] valueBytes(CacheObjectValueContext ctx) throws IgniteCheckedException {
        if (this.valBytes == null) {
            this.valBytes = ctx.kernalContext().cacheObjects().marshal(ctx, this.val);
        }
        return this.valBytes;
    }

    @Override
    public void prepareMarshal(CacheObjectValueContext ctx) throws IgniteCheckedException {
        assert (this.val != null || this.valBytes != null);
        if (this.valBytes == null) {
            this.valBytes = ctx.kernalContext().cacheObjects().marshal(ctx, this.val);
        }
    }

    @Override
    public void finishUnmarshal(CacheObjectValueContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        assert (this.val != null || this.valBytes != null);
        if (this.val == null && ctx.storeValue()) {
            this.val = ctx.kernalContext().cacheObjects().unmarshal(ctx, this.valBytes, ldr);
        }
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public short directType() {
        return 89;
    }

    public int hashCode() {
        assert (false);
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        assert (false);
        return super.equals(obj);
    }

    @Override
    public CacheObject prepareForCache(CacheObjectContext ctx, boolean compress) throws IgniteCheckedException {
        this.valueBytes(ctx);
        return this;
    }
}

