/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.freelist.FreeList;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.processors.query.GridQueryRowCacheCleaner;
import org.apache.ignite.internal.util.typedef.internal.U;

public class RowStore {
    private final FreeList freeList;
    private final GridCacheSharedContext ctx;
    protected final PageMemory pageMem;
    protected final CacheObjectContext coctx;
    private final boolean persistenceEnabled;
    private volatile Supplier<GridQueryRowCacheCleaner> rowCacheCleaner = () -> null;
    protected final CacheGroupContext grp;

    public RowStore(CacheGroupContext grp, FreeList freeList) {
        assert (grp != null);
        assert (freeList != null);
        this.grp = grp;
        this.freeList = freeList;
        this.ctx = grp.shared();
        this.coctx = grp.cacheObjectContext();
        this.pageMem = grp.dataRegion().pageMemory();
        this.persistenceEnabled = grp.dataRegion().config().isPersistenceEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRow(long link, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        assert (link != 0L);
        GridQueryRowCacheCleaner rowCacheCleaner0 = this.rowCacheCleaner.get();
        if (rowCacheCleaner0 != null) {
            rowCacheCleaner0.remove(link);
        }
        if (!this.persistenceEnabled) {
            this.freeList.removeDataRowByLink(link, statHolder);
        } else {
            this.ctx.database().checkpointReadLock();
            try {
                this.freeList.removeDataRowByLink(link, statHolder);
            }
            finally {
                this.ctx.database().checkpointReadUnlock();
            }
        }
    }

    public void addRow(CacheDataRow row, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        if (!this.persistenceEnabled) {
            this.ctx.database().ensureFreeSpaceForInsert(this.grp.dataRegion(), row);
            this.freeList.insertDataRow(row, statHolder);
        } else {
            this.ctx.database().checkpointReadLock();
            try {
                this.freeList.insertDataRow(row, statHolder);
                assert (row.link() != 0L);
            }
            finally {
                this.ctx.database().checkpointReadUnlock();
            }
        }
        assert (row.key().partition() == PageIdUtils.partId(row.link())) : "Constructed a link with invalid partition ID [partId=" + row.key().partition() + ", link=" + U.hexLong(row.link()) + ']';
    }

    public boolean updateRow(long link, CacheDataRow row, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        assert (!this.persistenceEnabled || this.ctx.database().checkpointLockIsHeldByThread());
        GridQueryRowCacheCleaner rowCacheCleaner0 = this.rowCacheCleaner.get();
        if (rowCacheCleaner0 != null) {
            rowCacheCleaner0.remove(link);
        }
        return this.freeList.updateDataRow(link, row, statHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, R> void updateDataRow(long link, PageHandler<S, R> pageHnd, S arg, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        if (!this.persistenceEnabled) {
            this.freeList.updateDataRow(link, pageHnd, arg, statHolder);
        } else {
            this.ctx.database().checkpointReadLock();
            try {
                this.freeList.updateDataRow(link, pageHnd, arg, statHolder);
            }
            finally {
                this.ctx.database().checkpointReadUnlock();
            }
        }
    }

    public FreeList freeList() {
        return this.freeList;
    }

    public void setRowCacheCleaner(Supplier<GridQueryRowCacheCleaner> rowCacheCleaner) {
        assert (rowCacheCleaner != null);
        this.rowCacheCleaner = rowCacheCleaner;
    }
}

