/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.checkpoint;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointEntry;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class EarliestCheckpointMapSnapshot
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private Map<UUID, Map<Integer, GroupStateSnapshot>> data = new HashMap<UUID, Map<Integer, GroupStateSnapshot>>();
    private Set<UUID> checkpointIds;

    public EarliestCheckpointMapSnapshot(Set<UUID> checkpointIds, Map<UUID, Map<Integer, GroupStateSnapshot>> earliestCp) {
        this.checkpointIds = checkpointIds;
        this.data = earliestCp;
    }

    public EarliestCheckpointMapSnapshot() {
        this.checkpointIds = new HashSet<UUID>();
    }

    @Nullable
    public Map<Integer, CheckpointEntry.GroupState> groupState(UUID checkpointId) {
        Map<Integer, GroupStateSnapshot> groupStateSnapshotMap = this.data.get(checkpointId);
        HashMap<Integer, CheckpointEntry.GroupState> groupStateMap = null;
        if (groupStateSnapshotMap != null) {
            groupStateMap = new HashMap<Integer, CheckpointEntry.GroupState>();
            for (Map.Entry<Integer, GroupStateSnapshot> e : groupStateSnapshotMap.entrySet()) {
                Integer k = e.getKey();
                GroupStateSnapshot v = e.getValue();
                groupStateMap.put(k, new CheckpointEntry.GroupState(v.partitionIds(), v.partitionCounters(), v.size()));
            }
        }
        return groupStateMap;
    }

    public boolean checkpointWasPresent(UUID checkpointId) {
        return this.checkpointIds.contains(checkpointId);
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeMap(out, this.data);
        U.writeCollection(out, this.checkpointIds);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.data = U.readMap(in);
        this.checkpointIds = U.readSet(in);
    }

    static class GroupStateSnapshot
    extends IgniteDataTransferObject {
        private static final long serialVersionUID = 0L;
        private int[] parts;
        private long[] cnts;
        private int size;

        GroupStateSnapshot(int[] parts, long[] cnts, int size) {
            this.parts = parts;
            this.cnts = cnts;
            this.size = size;
        }

        public GroupStateSnapshot() {
        }

        int[] partitionIds() {
            return this.parts;
        }

        long[] partitionCounters() {
            return this.cnts;
        }

        public int size() {
            return this.size;
        }

        @Override
        protected void writeExternalData(ObjectOutput out) throws IOException {
            U.writeIntArray(out, this.parts);
            U.writeLongArray(out, this.cnts);
            out.writeInt(this.size);
        }

        @Override
        protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
            this.parts = U.readIntArray(in);
            this.cnts = U.readLongArray(in);
            this.size = in.readInt();
        }
    }
}

