/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.serializer;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.managers.encryption.EncryptionCacheKeyProvider;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordDataV1Serializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordDataV2Serializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordV1Serializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordV2Serializer;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.jetbrains.annotations.Nullable;

public class RecordSerializerFactoryImpl
implements RecordSerializerFactory {
    private GridCacheSharedContext cctx;
    private boolean needWritePointer;
    @Nullable
    private IgniteBiPredicate<WALRecord.RecordType, WALPointer> recordDeserializeFilter;
    private boolean marshalledMode;
    private boolean skipPositionCheck;
    private final EncryptionCacheKeyProvider cacheKeyProvider;

    public RecordSerializerFactoryImpl(GridCacheSharedContext cctx) {
        this(cctx, null);
    }

    public RecordSerializerFactoryImpl(GridCacheSharedContext cctx, @Nullable IgniteBiPredicate<WALRecord.RecordType, WALPointer> readTypeFilter) {
        this(cctx, readTypeFilter, null);
    }

    public RecordSerializerFactoryImpl(GridCacheSharedContext cctx, @Nullable IgniteBiPredicate<WALRecord.RecordType, WALPointer> readTypeFilter, EncryptionCacheKeyProvider cacheKeyProvider) {
        this.cctx = cctx;
        this.recordDeserializeFilter = readTypeFilter;
        this.cacheKeyProvider = cacheKeyProvider == null ? cctx.kernalContext().encryption() : cacheKeyProvider;
    }

    @Override
    public RecordSerializer createSerializer(int ver) throws IgniteCheckedException {
        if (ver <= 0) {
            throw new IgniteCheckedException("Failed to create a serializer (corrupted WAL file).");
        }
        switch (ver) {
            case 1: {
                return new RecordV1Serializer(new RecordDataV1Serializer(this.cctx, this.cacheKeyProvider), this.needWritePointer, this.marshalledMode, this.skipPositionCheck, this.recordDeserializeFilter);
            }
            case 2: {
                return new RecordV2Serializer(new RecordDataV2Serializer(this.cctx, this.cacheKeyProvider), this.needWritePointer, this.marshalledMode, this.skipPositionCheck, this.recordDeserializeFilter);
            }
        }
        throw new IgniteCheckedException("Failed to create a serializer with the given version (forward compatibility is not supported): " + ver);
    }

    public boolean writePointer() {
        return this.needWritePointer;
    }

    @Override
    public RecordSerializerFactoryImpl writePointer(boolean writePointer) {
        this.needWritePointer = writePointer;
        return this;
    }

    public IgniteBiPredicate<WALRecord.RecordType, WALPointer> recordDeserializeFilter() {
        return this.recordDeserializeFilter;
    }

    @Override
    public RecordSerializerFactoryImpl recordDeserializeFilter(@Nullable IgniteBiPredicate<WALRecord.RecordType, WALPointer> readTypeFilter) {
        this.recordDeserializeFilter = readTypeFilter;
        return this;
    }

    public boolean marshalledMode() {
        return this.marshalledMode;
    }

    @Override
    public RecordSerializerFactoryImpl marshalledMode(boolean marshalledMode) {
        this.marshalledMode = marshalledMode;
        return this;
    }

    public boolean skipPositionCheck() {
        return this.skipPositionCheck;
    }

    @Override
    public RecordSerializerFactoryImpl skipPositionCheck(boolean skipPositionCheck) {
        this.skipPositionCheck = skipPositionCheck;
        return this;
    }

    @Override
    public RecordSerializerFactory clearSegmentLocalState() {
        this.skipPositionCheck = false;
        return this;
    }
}

