/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.query.GridCacheDistributedQueryManager;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryBean;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryFutureAdapter;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryRequest;
import org.apache.ignite.internal.util.lang.GridPlainCallable;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridCacheDistributedQueryFuture<K, V, R>
extends GridCacheQueryFutureAdapter<K, V, R> {
    private static final long serialVersionUID = 0L;
    private long reqId;
    private final Collection<UUID> subgrid = new HashSet<UUID>();
    private final Collection<UUID> rcvd = new HashSet<UUID>();
    private CountDownLatch firstPageLatch = new CountDownLatch(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GridCacheDistributedQueryFuture(GridCacheContext<K, V> ctx, long reqId, GridCacheQueryBean qry, Iterable<ClusterNode> nodes) {
        super(ctx, qry, false);
        assert (reqId > 0L);
        this.reqId = reqId;
        GridCacheQueryManager<K, V> mgr = ctx.queries();
        assert (mgr != null);
        GridCacheDistributedQueryFuture gridCacheDistributedQueryFuture = this;
        synchronized (gridCacheDistributedQueryFuture) {
            for (ClusterNode node : nodes) {
                this.subgrid.add(node.id());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancelQuery() throws IgniteCheckedException {
        final GridCacheQueryManager qryMgr = this.cctx.queries();
        assert (qryMgr != null);
        try {
            Collection<ClusterNode> nodes;
            Collection<ClusterNode> allNodes = this.cctx.discovery().allNodes();
            GridCacheDistributedQueryFuture gridCacheDistributedQueryFuture = this;
            synchronized (gridCacheDistributedQueryFuture) {
                nodes = F.retain(allNodes, true, new P1<ClusterNode>(){

                    @Override
                    public boolean apply(ClusterNode node) {
                        return !GridCacheDistributedQueryFuture.this.cctx.localNodeId().equals(node.id()) && GridCacheDistributedQueryFuture.this.subgrid.contains(node.id());
                    }
                });
                this.subgrid.clear();
            }
            final GridCacheQueryRequest req = new GridCacheQueryRequest(this.cctx.cacheId(), this.reqId, this.fields(), qryMgr.queryTopologyVersion(), this.cctx.deploymentEnabled());
            this.cctx.closures().callLocalSafe(new GridPlainCallable<Object>(){

                @Override
                public Object call() {
                    qryMgr.processQueryRequest(GridCacheDistributedQueryFuture.this.cctx.localNodeId(), req);
                    return null;
                }
            });
            if (!nodes.isEmpty()) {
                for (ClusterNode node : nodes) {
                    try {
                        this.cctx.io().send(node, (GridCacheMessage)req, this.cctx.ioPolicy());
                    }
                    catch (IgniteCheckedException e) {
                        if (this.cctx.io().checkNodeLeft(node.id(), e, false)) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Failed to send cancel request, node failed: " + node);
                            continue;
                        }
                        U.error(log, "Failed to send cancel request [node=" + node + ']', e);
                    }
                }
            }
        }
        catch (IgniteCheckedException e) {
            U.error(log, "Failed to send cancel request (will cancel query in any case).", e);
        }
        qryMgr.onQueryFutureCanceled(this.reqId);
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onNodeLeft(UUID nodeId) {
        boolean callOnPage;
        GridCacheDistributedQueryFuture gridCacheDistributedQueryFuture = this;
        synchronized (gridCacheDistributedQueryFuture) {
            callOnPage = !this.loc && this.subgrid.contains(nodeId);
        }
        if (callOnPage) {
            this.onPage(nodeId, Collections.emptyList(), new ClusterTopologyCheckedException("Remote node has left topology: " + nodeId), true);
        }
    }

    @Override
    public void awaitFirstPage() throws IgniteCheckedException {
        try {
            this.firstPageLatch.await();
            if (this.isDone() && this.error() != null) {
                this.get();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedCheckedException(e);
        }
    }

    @Override
    protected boolean onPage(UUID nodeId, boolean last) {
        boolean futFinish;
        assert (Thread.holdsLock(this));
        if (!this.loc) {
            this.rcvd.add(nodeId);
            if (this.rcvd.containsAll(this.subgrid)) {
                this.firstPageLatch.countDown();
            }
        }
        if (last) {
            boolean bl = futFinish = this.loc || this.subgrid.remove(nodeId) && this.subgrid.isEmpty();
            if (futFinish) {
                this.firstPageLatch.countDown();
            }
        } else {
            futFinish = false;
        }
        return futFinish;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadPage() {
        assert (!Thread.holdsLock(this));
        Collection<ClusterNode> nodes = null;
        GridCacheDistributedQueryFuture gridCacheDistributedQueryFuture = this;
        synchronized (gridCacheDistributedQueryFuture) {
            if (!this.isDone() && this.rcvd.containsAll(this.subgrid)) {
                this.rcvd.clear();
                nodes = this.nodes();
            }
        }
        if (nodes != null) {
            this.cctx.queries().loadPage(this.reqId, this.qry.query(), nodes, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadAllPages() throws IgniteInterruptedCheckedException {
        assert (!Thread.holdsLock(this));
        U.await(this.firstPageLatch);
        Collection<ClusterNode> nodes = null;
        GridCacheDistributedQueryFuture gridCacheDistributedQueryFuture = this;
        synchronized (gridCacheDistributedQueryFuture) {
            if (!this.isDone() && !this.subgrid.isEmpty()) {
                nodes = this.nodes();
            }
        }
        if (nodes != null) {
            this.cctx.queries().loadPage(this.reqId, this.qry.query(), nodes, true);
        }
    }

    private Collection<ClusterNode> nodes() {
        assert (Thread.holdsLock(this));
        ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>(this.subgrid.size());
        for (UUID nodeId : this.subgrid) {
            ClusterNode node = this.cctx.discovery().node(nodeId);
            if (node == null) continue;
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public boolean onDone(Collection<R> res, Throwable err) {
        boolean done = super.onDone(res, err);
        this.firstPageLatch.countDown();
        return done;
    }

    @Override
    public boolean onCancelled() {
        this.firstPageLatch.countDown();
        return super.onCancelled();
    }

    @Override
    public void onTimeout() {
        log.warning("Distributed scan query timed out: " + this.toString());
        this.firstPageLatch.countDown();
        super.onTimeout();
    }

    @Override
    void clear() {
        assert (this.isDone()) : this;
        GridCacheDistributedQueryManager qryMgr = (GridCacheDistributedQueryManager)this.cctx.queries();
        if (qryMgr != null) {
            qryMgr.removeQueryFuture(this.reqId);
        }
    }

    @Override
    public String toString() {
        return S.toString(GridCacheDistributedQueryFuture.class, this, "topology", (Object)this.cctx.discovery().topologyVersion(), "nodes", this.subgrid, "super", (Object)super.toString());
    }
}

