/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query.continuous;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.SystemProperty;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryEntry;
import org.apache.ignite.util.deque.FastSizeDeque;
import org.jetbrains.annotations.Nullable;

public class CacheContinuousQueryEventBuffer {
    public static final int DFLT_CONTINUOUS_QUERY_PENDING_BUFF_SIZE = 10000;
    public static final int DFLT_CONTINUOUS_QUERY_SERVER_BUFFER_SIZE = 1000;
    @SystemProperty(value="The max size of the buffer with pending continuous queries events", type=Long.class, defaults="10000")
    public static final String IGNITE_CONTINUOUS_QUERY_PENDING_BUFF_SIZE = "IGNITE_CONTINUOUS_QUERY_PENDING_BUFF_SIZE";
    @SystemProperty(value="Continuous queries batch buffer size", type=Long.class, defaults="1000")
    public static final String IGNITE_CONTINUOUS_QUERY_SERVER_BUFFER_SIZE = "IGNITE_CONTINUOUS_QUERY_SERVER_BUFFER_SIZE";
    private static final int BUF_SIZE = IgniteSystemProperties.getInteger("IGNITE_CONTINUOUS_QUERY_SERVER_BUFFER_SIZE", 1000);
    private static final Object RETRY = new Object();
    protected final int part;
    private AtomicReference<Batch> curBatch = new AtomicReference();
    private FastSizeDeque<CacheContinuousQueryEntry> backupQ = new FastSizeDeque(new ConcurrentLinkedDeque());
    private ConcurrentSkipListMap<Long, CacheContinuousQueryEntry> pending = new ConcurrentSkipListMap();

    CacheContinuousQueryEventBuffer(int part) {
        this.part = part;
    }

    void cleanupBackupQueue(Long updateCntr) {
        Iterator<CacheContinuousQueryEntry> it = this.backupQ.iterator();
        while (it.hasNext()) {
            CacheContinuousQueryEntry backupEntry = it.next();
            if (backupEntry.updateCounter() > updateCntr) continue;
            it.remove();
        }
    }

    void cleanupEntries(Long updateCntr) {
        Batch batch = this.curBatch.get();
        if (batch != null) {
            batch.cleanupEntries(updateCntr);
        }
    }

    @Nullable
    Collection<CacheContinuousQueryEntry> flushOnExchange() {
        Batch batch;
        TreeMap<Long, CacheContinuousQueryEntry> ret = null;
        int size = this.backupQ.sizex();
        if (size > 0) {
            CacheContinuousQueryEntry e;
            ret = new TreeMap<Long, CacheContinuousQueryEntry>();
            for (int i = 0; i < size && (e = this.backupQ.pollFirst()) != null; ++i) {
                ret.put(e.updateCounter(), e);
            }
        }
        if ((batch = this.curBatch.get()) != null) {
            ret = batch.flushCurrentEntries(ret);
        }
        if (!this.pending.isEmpty()) {
            if (ret == null) {
                ret = new TreeMap();
            }
            for (CacheContinuousQueryEntry e : this.pending.values()) {
                ret.put(e.updateCounter(), e);
            }
        }
        return ret != null ? ret.values() : null;
    }

    protected long currentPartitionCounter(boolean backup) {
        return 0L;
    }

    long currentFiltered() {
        Batch batch = this.curBatch.get();
        return batch != null ? batch.filtered : 0L;
    }

    @Nullable
    Object processEntry(CacheContinuousQueryEntry e, boolean backup) {
        return this.process0(e.updateCounter(), e, backup);
    }

    private Object process0(long cntr, CacheContinuousQueryEntry entry, boolean backup) {
        Batch batch0;
        Batch batch;
        Object res;
        block7: {
            assert (cntr >= 0L) : cntr;
            res = null;
            while (true) {
                if ((batch = this.initBatch(entry.topologyVersion(), backup)) == null || cntr < batch.startCntr) {
                    if (backup) {
                        this.backupQ.add(entry);
                        return null;
                    }
                    return entry;
                }
                if (cntr > batch.endCntr) break;
                res = batch.processEntry0(null, cntr, entry, backup);
                if (res == RETRY) {
                    continue;
                }
                break block7;
                break;
            }
            this.pending.put(cntr, entry);
        }
        if ((batch0 = this.curBatch.get()) != batch) {
            do {
                batch = batch0;
                res = this.processPending(res, batch, backup);
            } while (batch != (batch0 = this.initBatch(entry.topologyVersion(), backup)));
        }
        return res;
    }

    private Batch initBatch(AffinityTopologyVersion topVer, boolean backup) {
        Batch batch = this.curBatch.get();
        if (batch != null) {
            return batch;
        }
        do {
            long curCntr;
            if ((curCntr = this.currentPartitionCounter(backup)) == -1L) {
                return null;
            }
            batch = new Batch(curCntr + 1L, 0L, new CacheContinuousQueryEntry[BUF_SIZE], topVer);
            if (!this.curBatch.compareAndSet(null, batch)) continue;
            return batch;
        } while ((batch = this.curBatch.get()) == null);
        return batch;
    }

    @Nullable
    private Object processPending(@Nullable Object res, Batch batch, boolean backup) {
        if (this.pending.floorKey(batch.endCntr) != null) {
            for (Map.Entry p : this.pending.headMap((Object)batch.endCntr, true).entrySet()) {
                long cntr = (Long)p.getKey();
                assert (cntr <= batch.endCntr);
                if (this.pending.remove(p.getKey()) == null) continue;
                if (cntr < batch.startCntr) {
                    res = this.addResult(res, (CacheContinuousQueryEntry)p.getValue(), backup);
                    continue;
                }
                res = batch.processEntry0(res, (Long)p.getKey(), (CacheContinuousQueryEntry)p.getValue(), backup);
            }
        }
        return res;
    }

    @Nullable
    private Object addResult(@Nullable Object res, CacheContinuousQueryEntry entry, boolean backup) {
        if (res == null) {
            if (backup) {
                this.backupQ.add(entry);
            } else {
                res = entry;
            }
        } else {
            List<CacheContinuousQueryEntry> resList;
            assert (!backup);
            if (res instanceof CacheContinuousQueryEntry) {
                resList = new ArrayList<CacheContinuousQueryEntry>();
                resList.add((CacheContinuousQueryEntry)((Object)res));
            } else {
                assert (res instanceof List) : res;
                resList = res;
            }
            resList.add(entry);
            res = resList;
        }
        return res;
    }

    private class Batch {
        private long filtered;
        private final long startCntr;
        private final long endCntr;
        private int lastProc = -1;
        private int lastCleaned = -1;
        private CacheContinuousQueryEntry[] entries;
        private final AffinityTopologyVersion topVer;

        Batch(long startCntr, long filtered, CacheContinuousQueryEntry[] entries, AffinityTopologyVersion topVer) {
            assert (startCntr >= 0L);
            assert (filtered >= 0L);
            this.startCntr = startCntr;
            this.filtered = filtered;
            this.entries = entries;
            this.topVer = topVer;
            this.endCntr = startCntr + (long)BUF_SIZE - 1L;
        }

        synchronized void cleanupEntries(Long updateCntr) {
            CacheContinuousQueryEntry e;
            int next;
            if (this.entries == null) {
                return;
            }
            int i = next = this.lastCleaned + 1;
            while (i < this.entries.length && (e = this.entries[i]) != null && e.updateCounter() <= updateCntr) {
                this.entries[i] = null;
                this.lastCleaned = i++;
            }
        }

        @Nullable
        synchronized TreeMap<Long, CacheContinuousQueryEntry> flushCurrentEntries(@Nullable TreeMap<Long, CacheContinuousQueryEntry> res) {
            if (this.entries == null) {
                return res;
            }
            long filtered = this.filtered;
            long cntr = this.startCntr;
            for (int i = 0; i < this.entries.length; ++i) {
                CacheContinuousQueryEntry e = this.entries[i];
                CacheContinuousQueryEntry flushEntry = null;
                if (e == null) {
                    if (filtered != 0L) {
                        flushEntry = this.filteredEntry(cntr - 1L, filtered - 1L);
                        filtered = 0L;
                    }
                } else if (e.isFiltered()) {
                    ++filtered;
                } else {
                    flushEntry = new CacheContinuousQueryEntry(e.cacheId(), e.eventType(), e.key(), e.value(), e.oldValue(), e.isKeepBinary(), e.partition(), e.updateCounter(), e.topologyVersion(), e.flags());
                    flushEntry.filteredCount(filtered);
                    filtered = 0L;
                }
                if (flushEntry != null) {
                    if (res == null) {
                        res = new TreeMap();
                    }
                    res.put(flushEntry.updateCounter(), flushEntry);
                }
                ++cntr;
            }
            if (filtered != 0L) {
                if (res == null) {
                    res = new TreeMap();
                }
                CacheContinuousQueryEntry flushEntry = this.filteredEntry(cntr - 1L, filtered - 1L);
                res.put(flushEntry.updateCounter(), flushEntry);
            }
            return res;
        }

        private CacheContinuousQueryEntry filteredEntry(long cntr, long filtered) {
            CacheContinuousQueryEntry e = new CacheContinuousQueryEntry(0, null, null, null, null, false, CacheContinuousQueryEventBuffer.this.part, cntr, this.topVer, 0);
            e.markFiltered();
            e.filteredCount(filtered);
            return e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Object processEntry0(@Nullable Object res, long cntr, CacheContinuousQueryEntry entry, boolean backup) {
            int pos = (int)(cntr - this.startCntr);
            Batch batch = this;
            synchronized (batch) {
                if (this.entries == null) {
                    return RETRY;
                }
                this.entries[pos] = entry = entry.copyWithDataReset();
                int next = this.lastProc + 1;
                if (next == pos) {
                    CacheContinuousQueryEntry entry0;
                    int i = next;
                    while (i < this.entries.length && (entry0 = this.entries[i]) != null) {
                        if (!entry0.isFiltered()) {
                            entry0.filteredCount(this.filtered);
                            this.filtered = 0L;
                            res = CacheContinuousQueryEventBuffer.this.addResult(res, entry0, backup);
                        } else {
                            ++this.filtered;
                        }
                        pos = i++;
                    }
                    this.lastProc = pos;
                    if (pos == this.entries.length - 1) {
                        Arrays.fill(this.entries, null);
                        Batch nextBatch = new Batch(this.startCntr + (long)BUF_SIZE, this.filtered, this.entries, entry.topologyVersion());
                        this.entries = null;
                        assert (CacheContinuousQueryEventBuffer.this.curBatch.get() == this);
                        CacheContinuousQueryEventBuffer.this.curBatch.set(nextBatch);
                    }
                } else {
                    return res;
                }
            }
            return res;
        }
    }
}

