/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.concurrent.Callable;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.IgniteAtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheEntryProcessor;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.processors.datastructures.AtomicDataStructureProxy;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicReferenceEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicReferenceValue;
import org.apache.ignite.internal.processors.datastructures.GridCacheInternalKey;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;

public final class GridCacheAtomicReferenceImpl<T>
extends AtomicDataStructureProxy<GridCacheAtomicReferenceValue<T>>
implements GridCacheAtomicReferenceEx<T>,
IgniteChangeGlobalStateSupport,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final ThreadLocal<IgniteBiTuple<GridKernalContext, String>> stash = new ThreadLocal<IgniteBiTuple<GridKernalContext, String>>(){

        @Override
        protected IgniteBiTuple<GridKernalContext, String> initialValue() {
            return new IgniteBiTuple<GridKernalContext, String>();
        }
    };

    public GridCacheAtomicReferenceImpl() {
    }

    public GridCacheAtomicReferenceImpl(String name, GridCacheInternalKey key, IgniteInternalCache<GridCacheInternalKey, GridCacheAtomicReferenceValue<T>> atomicView) {
        super(name, key, atomicView);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public T get() {
        this.checkRemoved();
        try {
            GridCacheAtomicReferenceValue ref = (GridCacheAtomicReferenceValue)this.cacheView.get(this.key);
            if (ref == null) {
                throw new IgniteException("Failed to find atomic reference with given name: " + this.name);
            }
            return ref.get();
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.checkRemovedAfterFail(e);
        }
    }

    @Override
    public void set(final T val) {
        this.checkRemoved();
        try {
            if (this.ctx.dataStructures().knownType(val)) {
                EntryProcessorResult res = this.cacheView.invoke(this.key, new ReferenceSetEntryProcessor<T>(val), new Object[0]);
                assert (res != null);
                res.get();
            } else {
                CU.retryTopologySafe(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try (GridNearTxLocal tx = CU.txStartInternal(GridCacheAtomicReferenceImpl.this.ctx, GridCacheAtomicReferenceImpl.this.cacheView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                            GridCacheAtomicReferenceValue ref = (GridCacheAtomicReferenceValue)GridCacheAtomicReferenceImpl.this.cacheView.get(GridCacheAtomicReferenceImpl.this.key);
                            if (ref == null) {
                                throw new IgniteException("Failed to find atomic reference with given name: " + GridCacheAtomicReferenceImpl.this.name);
                            }
                            GridCacheAtomicReferenceImpl.this.cacheView.put(GridCacheAtomicReferenceImpl.this.key, new GridCacheAtomicReferenceValue<Object>(val));
                            tx.commit();
                        }
                        return null;
                    }
                });
            }
        }
        catch (EntryProcessorException | IgniteCheckedException | IgniteException e) {
            throw this.checkRemovedAfterFail((Exception)e);
        }
    }

    @Override
    public boolean compareAndSet(final T expVal, final T newVal) {
        this.checkRemoved();
        try {
            if (this.ctx.dataStructures().knownType(expVal) && this.ctx.dataStructures().knownType(newVal)) {
                EntryProcessorResult res = this.cacheView.invoke(this.key, new ReferenceCompareAndSetEntryProcessor<T>(expVal, newVal), new Object[0]);
                assert (res != null && res.get() != null) : res;
                return (Boolean)res.get();
            }
            return CU.retryTopologySafe(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    try (GridNearTxLocal tx = CU.txStartInternal(GridCacheAtomicReferenceImpl.this.ctx, GridCacheAtomicReferenceImpl.this.cacheView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                        GridCacheAtomicReferenceValue ref = (GridCacheAtomicReferenceValue)GridCacheAtomicReferenceImpl.this.cacheView.get(GridCacheAtomicReferenceImpl.this.key);
                        if (ref == null) {
                            throw new IgniteException("Failed to find atomic reference with given name: " + GridCacheAtomicReferenceImpl.this.name);
                        }
                        Object curVal = ref.get();
                        if (!F.eq(expVal, curVal)) {
                            Boolean bl = false;
                            return bl;
                        }
                        GridCacheAtomicReferenceImpl.this.cacheView.put(GridCacheAtomicReferenceImpl.this.key, new GridCacheAtomicReferenceValue<Object>(newVal));
                        tx.commit();
                        Boolean bl = true;
                        return bl;
                    }
                }
            });
        }
        catch (EntryProcessorException | IgniteCheckedException | IgniteException e) {
            throw this.checkRemovedAfterFail((Exception)e);
        }
    }

    public T compareAndSetAndGet(final T newVal, final T expVal) {
        this.checkRemoved();
        try {
            if (this.ctx.dataStructures().knownType(expVal) && this.ctx.dataStructures().knownType(newVal)) {
                EntryProcessorResult res = this.cacheView.invoke(this.key, new ReferenceCompareAndSetAndGetEntryProcessor<T>(expVal, newVal), new Object[0]);
                assert (res != null);
                return (T)res.get();
            }
            return (T)CU.retryTopologySafe(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    try (GridNearTxLocal tx = CU.txStartInternal(GridCacheAtomicReferenceImpl.this.ctx, GridCacheAtomicReferenceImpl.this.cacheView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                        GridCacheAtomicReferenceValue ref = (GridCacheAtomicReferenceValue)GridCacheAtomicReferenceImpl.this.cacheView.get(GridCacheAtomicReferenceImpl.this.key);
                        if (ref == null) {
                            throw new IgniteException("Failed to find atomic reference with given name: " + GridCacheAtomicReferenceImpl.this.name);
                        }
                        Object curVal = ref.get();
                        if (!F.eq(expVal, curVal)) {
                            Object t = curVal;
                            return t;
                        }
                        GridCacheAtomicReferenceImpl.this.cacheView.put(GridCacheAtomicReferenceImpl.this.key, new GridCacheAtomicReferenceValue<Object>(newVal));
                        tx.commit();
                        Object object = expVal;
                        return object;
                    }
                }
            });
        }
        catch (EntryProcessorException | IgniteCheckedException | IgniteException e) {
            throw this.checkRemovedAfterFail((Exception)e);
        }
    }

    @Override
    public void close() {
        if (this.rmvd) {
            return;
        }
        try {
            this.ctx.kernalContext().dataStructures().removeAtomicReference(this.name, this.ctx.group().name());
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    private IllegalStateException removedError() {
        return new IllegalStateException("Atomic reference was removed from cache: " + this.name);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ctx.kernalContext());
        out.writeUTF(this.name);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        IgniteBiTuple<GridKernalContext, String> t = stash.get();
        t.set1((GridKernalContext)in.readObject());
        t.set2(in.readUTF());
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            IgniteBiTuple<GridKernalContext, String> t = stash.get();
            IgniteAtomicReference<Object> igniteAtomicReference = t.get1().dataStructures().atomicReference(t.get2(), null, null, false);
            return igniteAtomicReference;
        }
        catch (IgniteCheckedException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
        finally {
            stash.remove();
        }
    }

    @Override
    public String toString() {
        return S.toString(GridCacheAtomicReferenceImpl.class, this);
    }

    static class ReferenceCompareAndSetAndGetEntryProcessor<T>
    implements CacheEntryProcessor<GridCacheInternalKey, GridCacheAtomicReferenceValue<T>, T> {
        private static final long serialVersionUID = 0L;
        private final T expVal;
        private final T newVal;

        ReferenceCompareAndSetAndGetEntryProcessor(T expVal, T newVal) {
            this.expVal = expVal;
            this.newVal = newVal;
        }

        public T process(MutableEntry<GridCacheInternalKey, GridCacheAtomicReferenceValue<T>> e, Object ... args) {
            GridCacheAtomicReferenceValue val = (GridCacheAtomicReferenceValue)e.getValue();
            if (val == null) {
                throw new EntryProcessorException("Failed to find atomic reference with given name: " + ((GridCacheInternalKey)e.getKey()).name());
            }
            Object curVal = val.get();
            if (F.eq(this.expVal, curVal)) {
                e.setValue(new GridCacheAtomicReferenceValue<T>(this.newVal));
            }
            return curVal;
        }

        public String toString() {
            return S.toString(ReferenceCompareAndSetAndGetEntryProcessor.class, this);
        }
    }

    static class ReferenceCompareAndSetEntryProcessor<T>
    implements CacheEntryProcessor<GridCacheInternalKey, GridCacheAtomicReferenceValue<T>, Boolean> {
        private static final long serialVersionUID = 0L;
        private final T expVal;
        private final T newVal;

        ReferenceCompareAndSetEntryProcessor(T expVal, T newVal) {
            this.expVal = expVal;
            this.newVal = newVal;
        }

        public Boolean process(MutableEntry<GridCacheInternalKey, GridCacheAtomicReferenceValue<T>> e, Object ... args) {
            GridCacheAtomicReferenceValue val = (GridCacheAtomicReferenceValue)e.getValue();
            if (val == null) {
                throw new EntryProcessorException("Failed to find atomic reference with given name: " + ((GridCacheInternalKey)e.getKey()).name());
            }
            Object curVal = val.get();
            if (F.eq(this.expVal, curVal)) {
                e.setValue(new GridCacheAtomicReferenceValue<T>(this.newVal));
                return true;
            }
            return false;
        }

        public String toString() {
            return S.toString(ReferenceCompareAndSetEntryProcessor.class, this);
        }
    }

    static class ReferenceSetEntryProcessor<T>
    implements CacheEntryProcessor<GridCacheInternalKey, GridCacheAtomicReferenceValue<T>, Void> {
        private static final long serialVersionUID = 0L;
        private final T newVal;

        ReferenceSetEntryProcessor(T newVal) {
            this.newVal = newVal;
        }

        public Void process(MutableEntry<GridCacheInternalKey, GridCacheAtomicReferenceValue<T>> e, Object ... args) {
            GridCacheAtomicReferenceValue val = (GridCacheAtomicReferenceValue)e.getValue();
            if (val == null) {
                throw new EntryProcessorException("Failed to find atomic reference with given name: " + ((GridCacheInternalKey)e.getKey()).name());
            }
            e.setValue(new GridCacheAtomicReferenceValue<T>(this.newVal));
            return null;
        }

        public String toString() {
            return S.toString(ReferenceSetEntryProcessor.class, this, super.toString());
        }
    }
}

