/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.exceptions.SqlCacheException;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.transactions.TransactionAlreadyCompletedException;
import org.apache.ignite.transactions.TransactionDuplicateKeyException;
import org.apache.ignite.transactions.TransactionMixedModeException;
import org.apache.ignite.transactions.TransactionSerializationException;
import org.apache.ignite.transactions.TransactionUnsupportedConcurrencyException;
import org.jetbrains.annotations.Nullable;

public abstract class SqlListenerUtils {
    @Nullable
    public static Object readObject(BinaryReaderExImpl reader, boolean binObjAllow) throws BinaryObjectException {
        return SqlListenerUtils.readObject(reader, binObjAllow, true);
    }

    @Nullable
    public static Object readObject(BinaryReaderExImpl reader, boolean binObjAllow, boolean keepBinary) throws BinaryObjectException {
        byte type = reader.readByte();
        return SqlListenerUtils.readObject(type, reader, binObjAllow, keepBinary);
    }

    @Nullable
    public static Object readObject(byte type, BinaryReaderExImpl reader, boolean binObjAllow, boolean keepBinary) throws BinaryObjectException {
        switch (type) {
            case 101: {
                return null;
            }
            case 8: {
                return reader.readBoolean();
            }
            case 1: {
                return reader.readByte();
            }
            case 7: {
                return Character.valueOf(reader.readChar());
            }
            case 2: {
                return reader.readShort();
            }
            case 3: {
                return reader.readInt();
            }
            case 4: {
                return reader.readLong();
            }
            case 5: {
                return Float.valueOf(reader.readFloat());
            }
            case 6: {
                return reader.readDouble();
            }
            case 9: {
                return BinaryUtils.doReadString(reader.in());
            }
            case 30: {
                return BinaryUtils.doReadDecimal(reader.in());
            }
            case 10: {
                return BinaryUtils.doReadUuid(reader.in());
            }
            case 36: {
                return BinaryUtils.doReadTime(reader.in());
            }
            case 33: {
                return BinaryUtils.doReadTimestamp(reader.in());
            }
            case 11: {
                return BinaryUtils.doReadDate(reader.in());
            }
            case 19: {
                return BinaryUtils.doReadBooleanArray(reader.in());
            }
            case 12: {
                return BinaryUtils.doReadByteArray(reader.in());
            }
            case 18: {
                return BinaryUtils.doReadCharArray(reader.in());
            }
            case 13: {
                return BinaryUtils.doReadShortArray(reader.in());
            }
            case 14: {
                return BinaryUtils.doReadIntArray(reader.in());
            }
            case 15: {
                return BinaryUtils.doReadLongArray(reader.in());
            }
            case 16: {
                return BinaryUtils.doReadFloatArray(reader.in());
            }
            case 17: {
                return BinaryUtils.doReadDoubleArray(reader.in());
            }
            case 20: {
                return BinaryUtils.doReadStringArray(reader.in());
            }
            case 31: {
                return BinaryUtils.doReadDecimalArray(reader.in());
            }
            case 21: {
                return BinaryUtils.doReadUuidArray(reader.in());
            }
            case 37: {
                return BinaryUtils.doReadTimeArray(reader.in());
            }
            case 34: {
                return BinaryUtils.doReadTimestampArray(reader.in());
            }
            case 22: {
                return BinaryUtils.doReadDateArray(reader.in());
            }
        }
        reader.in().position(reader.in().position() - 1);
        if (binObjAllow) {
            Object res = reader.readObjectDetached();
            return !keepBinary && res instanceof BinaryObject ? ((BinaryObject)res).deserialize() : res;
        }
        throw new BinaryObjectException("Custom objects are not supported");
    }

    public static void writeObject(BinaryWriterExImpl writer, @Nullable Object obj, boolean binObjAllow) throws BinaryObjectException {
        if (obj == null) {
            writer.writeByte((byte)101);
            return;
        }
        Class<?> cls = obj.getClass();
        if (cls == Boolean.class) {
            writer.writeBooleanFieldPrimitive((Boolean)obj);
        } else if (cls == Byte.class) {
            writer.writeByteFieldPrimitive((Byte)obj);
        } else if (cls == Character.class) {
            writer.writeCharFieldPrimitive(((Character)obj).charValue());
        } else if (cls == Short.class) {
            writer.writeShortFieldPrimitive((Short)obj);
        } else if (cls == Integer.class) {
            writer.writeIntFieldPrimitive((Integer)obj);
        } else if (cls == Long.class) {
            writer.writeLongFieldPrimitive((Long)obj);
        } else if (cls == Float.class) {
            writer.writeFloatFieldPrimitive(((Float)obj).floatValue());
        } else if (cls == Double.class) {
            writer.writeDoubleFieldPrimitive((Double)obj);
        } else if (cls == String.class) {
            writer.doWriteString((String)obj);
        } else if (cls == BigDecimal.class) {
            writer.doWriteDecimal((BigDecimal)obj);
        } else if (cls == UUID.class) {
            writer.writeUuid((UUID)obj);
        } else if (cls == Time.class) {
            writer.writeTime((Time)obj);
        } else if (cls == Timestamp.class) {
            writer.writeTimestamp((Timestamp)obj);
        } else if (cls == Date.class || cls == java.util.Date.class) {
            writer.writeDate((java.util.Date)obj);
        } else if (cls == boolean[].class) {
            writer.writeBooleanArray((boolean[])obj);
        } else if (cls == byte[].class) {
            writer.writeByteArray((byte[])obj);
        } else if (cls == char[].class) {
            writer.writeCharArray((char[])obj);
        } else if (cls == short[].class) {
            writer.writeShortArray((short[])obj);
        } else if (cls == int[].class) {
            writer.writeIntArray((int[])obj);
        } else if (cls == long[].class) {
            writer.writeLongArray((long[])obj);
        } else if (cls == float[].class) {
            writer.writeFloatArray((float[])obj);
        } else if (cls == double[].class) {
            writer.writeDoubleArray((double[])obj);
        } else if (cls == String[].class) {
            writer.writeStringArray((String[])obj);
        } else if (cls == BigDecimal[].class) {
            writer.writeDecimalArray((BigDecimal[])obj);
        } else if (cls == UUID[].class) {
            writer.writeUuidArray((UUID[])obj);
        } else if (cls == Time[].class) {
            writer.writeTimeArray((Time[])obj);
        } else if (cls == Timestamp[].class) {
            writer.writeTimestampArray((Timestamp[])obj);
        } else if (cls == java.util.Date[].class || cls == Date[].class) {
            writer.writeDateArray((java.util.Date[])obj);
        } else if (binObjAllow) {
            writer.writeObjectDetached(obj);
        } else {
            throw new BinaryObjectException("Custom objects are not supported");
        }
    }

    public static boolean isPlainType(Class<?> cls) {
        return cls == Boolean.class || cls == Byte.class || cls == Character.class || cls == Short.class || cls == Integer.class || cls == Long.class || cls == Float.class || cls == Double.class || cls == String.class || cls == BigDecimal.class || cls == UUID.class || cls == Time.class || cls == Timestamp.class || cls == Date.class || cls == java.util.Date.class || cls == boolean[].class || cls == byte[].class || cls == char[].class || cls == short[].class || cls == int[].class || cls == long[].class || cls == float[].class || cls == double[].class || cls == String[].class || cls == BigDecimal[].class || cls == UUID[].class || cls == Time[].class || cls == Timestamp[].class || cls == java.util.Date[].class || cls == Date[].class;
    }

    public static int exceptionToSqlErrorCode(Throwable e) {
        if (e instanceof QueryCancelledException) {
            return 3014;
        }
        if (e instanceof TransactionSerializationException) {
            return 5005;
        }
        if (e instanceof TransactionAlreadyCompletedException) {
            return 5004;
        }
        if (e instanceof TransactionDuplicateKeyException) {
            return 4001;
        }
        if (e instanceof TransactionMixedModeException) {
            return 5003;
        }
        if (e instanceof TransactionUnsupportedConcurrencyException) {
            return 1002;
        }
        if (e instanceof IgniteSQLException) {
            return ((IgniteSQLException)e).statusCode();
        }
        if (e instanceof SqlCacheException) {
            return ((SqlCacheException)((Object)e)).statusCode();
        }
        return 1;
    }

    public static String translateSqlWildcardsToRegex(String sqlPtrn) {
        if (F.isEmpty(sqlPtrn)) {
            return sqlPtrn;
        }
        String toRegex = ' ' + sqlPtrn;
        toRegex = toRegex.replaceAll("([\\[\\]{}()*+?.\\\\\\\\^$|])", "\\\\$1");
        toRegex = toRegex.replaceAll("([^\\\\\\\\])((?:\\\\\\\\\\\\\\\\)*)%", "$1$2.*");
        toRegex = toRegex.replaceAll("([^\\\\\\\\])((?:\\\\\\\\\\\\\\\\)*)_", "$1$2.");
        toRegex = toRegex.replaceAll("([^\\\\\\\\])(\\\\\\\\(?>\\\\\\\\\\\\\\\\)*\\\\\\\\)*\\\\\\\\([_|%])", "$1$2$3");
        return toRegex.substring(1);
    }

    public static Timestamp convertWithTimeZone(Timestamp ts, TimeZone tzFrom, TimeZone tzTo) {
        if (ts == null || tzTo == null || tzFrom == null || tzTo.getID().equals(tzFrom.getID())) {
            return ts;
        }
        return new Timestamp(SqlListenerUtils.convertWithTimeZone(tzFrom, tzTo, ts.getTime()));
    }

    public static Time convertWithTimeZone(Time time, TimeZone tzFrom, TimeZone tzTo) {
        if (time == null || tzTo == null || tzFrom == null || tzTo.getID().equals(tzFrom.getID())) {
            return time;
        }
        return new Time(SqlListenerUtils.convertWithTimeZone(tzFrom, tzTo, time.getTime()));
    }

    public static java.util.Date convertWithTimeZone(java.util.Date date, TimeZone tzFrom, TimeZone tzTo) {
        if (date == null || tzTo == null || tzFrom == null || tzTo.getID().equals(tzFrom.getID())) {
            return date;
        }
        return new Time(SqlListenerUtils.convertWithTimeZone(tzFrom, tzTo, date.getTime()));
    }

    private static long convertWithTimeZone(TimeZone tzFrom, TimeZone tzTo, long ms) {
        Instant i = Instant.ofEpochMilli(ms);
        LocalDateTime ldt = LocalDateTime.ofInstant(i, tzFrom.toZoneId());
        ZonedDateTime zdt = ldt.atZone(tzTo.toZoneId());
        return zdt.toInstant().toEpochMilli();
    }

    @Nullable
    public static Object readSqlField(BinaryRawReaderEx reader, TimeZone clientTz, boolean allowBinary) throws BinaryObjectException {
        BinaryReaderExImpl reader0 = (BinaryReaderExImpl)reader;
        TimeZone serverTz = TimeZone.getDefault();
        byte type = reader0.readByte();
        switch (type) {
            case 11: {
                return new Date(SqlListenerUtils.convertWithTimeZone(BinaryUtils.doReadDate(reader0.in()), clientTz, serverTz).getTime());
            }
            case 36: {
                return SqlListenerUtils.convertWithTimeZone(BinaryUtils.doReadTime(reader0.in()), clientTz, serverTz);
            }
            case 33: {
                return SqlListenerUtils.convertWithTimeZone(BinaryUtils.doReadTimestamp(reader0.in()), clientTz, serverTz);
            }
        }
        reader0.in().position(reader0.in().position() - 1);
        return SqlListenerUtils.readObject(reader0, allowBinary);
    }

    public static void writeSqlField(BinaryWriterExImpl writer, @Nullable Object obj, TimeZone clientTz, boolean allowBinary) throws BinaryObjectException {
        Class<?> cls = obj == null ? null : obj.getClass();
        TimeZone serverTz = TimeZone.getDefault();
        if (cls == Date.class || cls == java.util.Date.class) {
            writer.writeDate(SqlListenerUtils.convertWithTimeZone((java.util.Date)obj, serverTz, clientTz));
        } else if (cls == Time.class) {
            writer.writeTime(SqlListenerUtils.convertWithTimeZone((Time)obj, serverTz, clientTz));
        } else if (cls == Timestamp.class) {
            writer.writeTimestamp(SqlListenerUtils.convertWithTimeZone((Timestamp)obj, serverTz, clientTz));
        } else {
            SqlListenerUtils.writeObject(writer, obj, allowBinary);
        }
    }
}

