/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.jdbc.thin.JdbcThinUtils;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.authentication.AuthorizationContext;
import org.apache.ignite.internal.processors.odbc.ClientListenerAbstractConnectionContext;
import org.apache.ignite.internal.processors.odbc.ClientListenerMessageParser;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequestHandler;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponse;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponseSender;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMessageParser;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequestHandler;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcThinFeature;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcUtils;
import org.apache.ignite.internal.processors.query.NestedTxMode;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.security.SecurityPermission;

public class JdbcConnectionContext
extends ClientListenerAbstractConnectionContext {
    private static final ClientListenerProtocolVersion VER_2_1_0 = ClientListenerProtocolVersion.create(2, 1, 0);
    private static final ClientListenerProtocolVersion VER_2_1_5 = ClientListenerProtocolVersion.create(2, 1, 5);
    static final ClientListenerProtocolVersion VER_2_3_0 = ClientListenerProtocolVersion.create(2, 3, 0);
    static final ClientListenerProtocolVersion VER_2_4_0 = ClientListenerProtocolVersion.create(2, 4, 0);
    static final ClientListenerProtocolVersion VER_2_5_0 = ClientListenerProtocolVersion.create(2, 5, 0);
    static final ClientListenerProtocolVersion VER_2_7_0 = ClientListenerProtocolVersion.create(2, 7, 0);
    static final ClientListenerProtocolVersion VER_2_8_0 = ClientListenerProtocolVersion.create(2, 8, 0);
    static final ClientListenerProtocolVersion VER_2_8_1 = ClientListenerProtocolVersion.create(2, 8, 1);
    static final ClientListenerProtocolVersion VER_2_8_2 = ClientListenerProtocolVersion.create(2, 8, 2);
    static final ClientListenerProtocolVersion VER_2_8_3;
    public static final ClientListenerProtocolVersion CURRENT_VER;
    private static final Set<ClientListenerProtocolVersion> SUPPORTED_VERS;
    private final GridSpinBusyLock busyLock;
    private final IgniteLogger log;
    private final int maxCursors;
    private JdbcMessageParser parser;
    private JdbcRequestHandler handler;
    private JdbcProtocolContext protoCtx;
    private AtomicReference<AffinityTopologyVersion> lastAffinityTopVer = new AtomicReference();

    public JdbcConnectionContext(GridKernalContext ctx, GridNioSession ses, GridSpinBusyLock busyLock, long connId, int maxCursors) {
        super(ctx, ses, connId);
        this.busyLock = busyLock;
        this.maxCursors = maxCursors;
        this.log = ctx.log(this.getClass());
    }

    @Override
    public byte clientType() {
        return 1;
    }

    @Override
    public boolean isVersionSupported(ClientListenerProtocolVersion ver) {
        return SUPPORTED_VERS.contains(ver);
    }

    @Override
    public ClientListenerProtocolVersion defaultVersion() {
        return CURRENT_VER;
    }

    @Override
    public void initializeFromHandshake(final GridNioSession ses, ClientListenerProtocolVersion ver, BinaryReaderExImpl reader) throws IgniteCheckedException {
        String nestedTxModeName;
        assert (SUPPORTED_VERS.contains(ver)) : "Unsupported JDBC protocol version.";
        boolean distributedJoins = reader.readBoolean();
        boolean enforceJoinOrder = reader.readBoolean();
        boolean collocated = reader.readBoolean();
        boolean replicatedOnly = reader.readBoolean();
        boolean autoCloseCursors = reader.readBoolean();
        boolean lazyExec = false;
        boolean skipReducerOnUpdate = false;
        NestedTxMode nestedTxMode = NestedTxMode.DEFAULT;
        AuthorizationContext actx = null;
        if (ver.compareTo(VER_2_1_5) >= 0) {
            lazyExec = reader.readBoolean();
        }
        if (ver.compareTo(VER_2_3_0) >= 0) {
            skipReducerOnUpdate = reader.readBoolean();
        }
        if (ver.compareTo(VER_2_7_0) >= 0 && !F.isEmpty(nestedTxModeName = reader.readString())) {
            try {
                nestedTxMode = NestedTxMode.valueOf(nestedTxModeName);
            }
            catch (IllegalArgumentException e) {
                throw new IgniteCheckedException("Invalid nested transactions handling mode: " + nestedTxModeName);
            }
        }
        Boolean dataPageScanEnabled = null;
        Integer updateBatchSize = null;
        long maxMemory = 0L;
        EnumSet<JdbcThinFeature> features = EnumSet.noneOf(JdbcThinFeature.class);
        if (ver.compareTo(VER_2_8_0) >= 0) {
            BinaryHeapInputStream inStream = (BinaryHeapInputStream)reader.in();
            int pos = inStream.position();
            try {
                dataPageScanEnabled = JdbcThinUtils.nullableBooleanFromByte(reader.readByte());
                updateBatchSize = JdbcUtils.readNullableInteger(reader);
            }
            catch (Exception ex) {
                if (ver.compareTo(VER_2_8_0) != 0) {
                    throw ex;
                }
                inStream.position(pos);
            }
        }
        if (ver.compareTo(VER_2_8_1) >= 0 && reader.readBoolean()) {
            maxMemory = reader.readLong();
        }
        if (ver.compareTo(VER_2_8_2) >= 0) {
            byte[] cliFeatures = reader.readByteArray();
            features = JdbcThinFeature.enumSet(cliFeatures);
        }
        if (ver.compareTo(VER_2_8_3) >= 0) {
            this.userAttrs = reader.readMap();
        }
        if (ver.compareTo(VER_2_5_0) >= 0) {
            String user = null;
            String passwd = null;
            try {
                if (reader.available() > 0) {
                    user = reader.readString();
                    passwd = reader.readString();
                }
            }
            catch (Exception e) {
                throw new IgniteCheckedException("Handshake error: " + e.getMessage(), e);
            }
            actx = this.authenticate(ses.certificates(), user, passwd);
        }
        this.protoCtx = new JdbcProtocolContext(ver, features, null, false, true);
        this.initClientDescriptor("jdbc-thin");
        this.parser = new JdbcMessageParser(this.ctx, this.protoCtx);
        ClientListenerResponseSender sender = new ClientListenerResponseSender(){

            @Override
            public void send(ClientListenerResponse resp) {
                if (resp != null) {
                    if (JdbcConnectionContext.this.log.isDebugEnabled()) {
                        JdbcConnectionContext.this.log.debug("Async response: [resp=" + resp.status() + ']');
                    }
                    ses.send(JdbcConnectionContext.this.parser.encode(resp));
                }
            }
        };
        if (maxMemory != 0L && this.securityContext() != null) {
            try (OperationSecurityContext op = this.ctx.security().withContext(this.securityContext());){
                this.ctx.security().authorize(SecurityPermission.SET_QUERY_MEMORY_QUOTA);
            }
        }
        this.handler = new JdbcRequestHandler(this.busyLock, sender, this.maxCursors, maxMemory, distributedJoins, enforceJoinOrder, collocated, replicatedOnly, autoCloseCursors, lazyExec, skipReducerOnUpdate, nestedTxMode, dataPageScanEnabled, updateBatchSize, actx, ver, this);
        this.handler.start();
    }

    @Override
    public ClientListenerRequestHandler handler() {
        return this.handler;
    }

    @Override
    public ClientListenerMessageParser parser() {
        return this.parser;
    }

    @Override
    public void onDisconnected() {
        this.handler.onDisconnect();
        super.onDisconnected();
    }

    public AffinityTopologyVersion getAffinityTopologyVersionIfChanged() {
        AffinityTopologyVersion newVer;
        AffinityTopologyVersion oldVer;
        boolean success;
        boolean changed;
        do {
            oldVer = this.lastAffinityTopVer.get();
            newVer = this.ctx.cache().context().exchange().readyAffinityVersion();
            boolean bl = changed = oldVer == null || oldVer.compareTo(newVer) < 0;
        } while (changed && !(success = this.lastAffinityTopVer.compareAndSet(oldVer, newVer)));
        return changed ? newVer : null;
    }

    public JdbcProtocolContext protocolContext() {
        return this.protoCtx;
    }

    static {
        CURRENT_VER = VER_2_8_3 = ClientListenerProtocolVersion.create(2, 8, 3);
        SUPPORTED_VERS = new HashSet<ClientListenerProtocolVersion>();
        SUPPORTED_VERS.add(CURRENT_VER);
        SUPPORTED_VERS.add(VER_2_8_2);
        SUPPORTED_VERS.add(VER_2_8_1);
        SUPPORTED_VERS.add(VER_2_8_0);
        SUPPORTED_VERS.add(VER_2_7_0);
        SUPPORTED_VERS.add(VER_2_5_0);
        SUPPORTED_VERS.add(VER_2_4_0);
        SUPPORTED_VERS.add(VER_2_3_0);
        SUPPORTED_VERS.add(VER_2_1_5);
        SUPPORTED_VERS.add(VER_2_1_0);
    }
}

