/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cluster;

import java.util.Collection;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;

public class ClientClusterGroupGetNodesDetailsResponse
extends ClientResponse {
    private final Collection<ClusterNode> nodes;

    public ClientClusterGroupGetNodesDetailsResponse(long reqId, Collection<ClusterNode> nodes) {
        super(reqId);
        this.nodes = nodes;
    }

    @Override
    public void encode(ClientConnectionContext ctx, BinaryRawWriterEx writer) {
        super.encode(ctx, writer);
        writer.writeInt(this.nodes.size());
        for (ClusterNode node : this.nodes) {
            writer.writeUuid(node.id());
            PlatformUtils.writeNodeAttributes(writer, node.attributes());
            writer.writeCollection(node.addresses());
            writer.writeCollection(node.hostNames());
            writer.writeLong(node.order());
            writer.writeBoolean(node.isLocal());
            writer.writeBoolean(node.isDaemon());
            writer.writeBoolean(node.isClient());
            writer.writeObjectDetached(node.consistentId());
            PlatformUtils.writeNodeVersion(writer, node.version());
        }
    }
}

