/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.datastructures;

import org.apache.ignite.IgniteAtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.configuration.AtomicConfiguration;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;

public class ClientAtomicLongRequest
extends ClientRequest {
    private final String name;
    private final String groupName;

    public ClientAtomicLongRequest(BinaryRawReader reader) {
        super(reader);
        this.name = reader.readString();
        this.groupName = reader.readString();
    }

    protected IgniteAtomicLong atomicLong(ClientConnectionContext ctx) {
        AtomicConfiguration cfg = this.groupName == null ? null : new AtomicConfiguration().setGroupName(this.groupName);
        try {
            return ctx.kernalContext().dataStructures().atomicLong(this.name, cfg, 0L, false);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e.getMessage(), e);
        }
    }

    protected ClientResponse notFoundResponse() {
        return new ClientResponse(this.requestId(), String.format("AtomicLong with name '%s' does not exist.", this.name));
    }
}

