/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.tx;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;
import org.apache.ignite.internal.processors.platform.client.tx.ClientTxContext;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;

public class ClientTxEndRequest
extends ClientRequest {
    private final int txId;
    private final boolean committed;

    public ClientTxEndRequest(BinaryRawReader reader) {
        super(reader);
        this.txId = reader.readInt();
        this.committed = reader.readBoolean();
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        ClientTxContext txCtx = ctx.txContext(this.txId);
        if (txCtx == null && !this.committed) {
            return super.process(ctx);
        }
        if (txCtx == null) {
            throw new IgniteClientException(1021, "Transaction with id " + this.txId + " not found.");
        }
        try {
            txCtx.acquire(this.committed);
            try (GridNearTxLocal tx = txCtx.tx();){
                if (this.committed) {
                    tx.commit();
                } else {
                    tx.rollback();
                }
            }
        }
        catch (IgniteTxTimeoutCheckedException e) {
            throw new IgniteClientException(1022, e.getMessage(), e);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteClientException(1, e.getMessage(), e);
        }
        finally {
            ctx.removeTxContext(this.txId);
            try {
                txCtx.release(false);
            }
            catch (IgniteCheckedException igniteCheckedException) {}
        }
        return super.process(ctx);
    }
}

