/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.redis;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.rest.GridRestProtocolHandler;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.redis.GridRedisCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.exception.GridRedisGenericException;
import org.apache.ignite.internal.processors.rest.handlers.redis.exception.GridRedisTypeException;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisMessage;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisProtocolParser;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.typedef.CX1;
import org.jetbrains.annotations.Nullable;

public abstract class GridRedisRestCommandHandler
implements GridRedisCommandHandler {
    protected final IgniteLogger log;
    protected final GridRestProtocolHandler hnd;
    protected final GridKernalContext ctx;

    protected GridRedisRestCommandHandler(IgniteLogger log, GridRestProtocolHandler hnd, GridKernalContext ctx) {
        this.log = log;
        this.hnd = hnd;
        this.ctx = ctx;
    }

    @Override
    public IgniteInternalFuture<GridRedisMessage> handleAsync(GridNioSession ses, final GridRedisMessage msg) {
        assert (msg != null);
        try {
            return this.hnd.handleAsync(this.asRestRequest(msg)).chain(new CX1<IgniteInternalFuture<GridRestResponse>, GridRedisMessage>(){

                @Override
                public GridRedisMessage applyx(IgniteInternalFuture<GridRestResponse> f) throws IgniteCheckedException {
                    GridRestResponse restRes = f.get();
                    if (restRes.getSuccessStatus() == 0) {
                        msg.setResponse(GridRedisRestCommandHandler.this.makeResponse(restRes, msg.auxMKeys()));
                    } else {
                        msg.setResponse(GridRedisProtocolParser.toGenericError("Operation error"));
                    }
                    return msg;
                }
            }, this.ctx.pools().getRestExecutorService());
        }
        catch (IgniteCheckedException e) {
            if (e instanceof GridRedisTypeException) {
                msg.setResponse(GridRedisProtocolParser.toTypeError(e.getMessage()));
            } else {
                msg.setResponse(GridRedisProtocolParser.toGenericError(e.getMessage()));
            }
            return new GridFinishedFuture<GridRedisMessage>(msg);
        }
    }

    @Nullable
    protected Long longValue(String name, List<String> params) throws GridRedisGenericException {
        assert (name != null);
        Iterator<String> it = params.iterator();
        while (it.hasNext()) {
            if (!name.equalsIgnoreCase(it.next())) continue;
            if (it.hasNext()) {
                String val = it.next();
                try {
                    return Long.valueOf(val);
                }
                catch (NumberFormatException ignore) {
                    throw new GridRedisGenericException("Failed to parse parameter of Long type [" + name + "=" + val + "]");
                }
            }
            throw new GridRedisGenericException("Syntax error. Missing value for parameter: " + name);
        }
        return null;
    }

    public abstract GridRestRequest asRestRequest(GridRedisMessage var1) throws IgniteCheckedException;

    public abstract ByteBuffer makeResponse(GridRestResponse var1, List<String> var2);
}

