/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.security;

import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.security.GridSecurityProcessor;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.security.AuthenticationContext;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityException;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecuritySubject;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.jetbrains.annotations.Nullable;

public class NoOpIgniteSecurityProcessor
extends GridProcessorAdapter
implements IgniteSecurity {
    private final OperationSecurityContext opSecCtx = new OperationSecurityContext(this, null);
    private final GridSecurityProcessor processor;

    public NoOpIgniteSecurityProcessor(GridKernalContext ctx, @Nullable GridSecurityProcessor processor) {
        super(ctx);
        this.processor = processor;
    }

    @Override
    public void onKernalStart(boolean active) throws IgniteCheckedException {
        super.onKernalStart(active);
        if (this.processor != null) {
            this.processor.onKernalStart(active);
        }
    }

    @Override
    public void onKernalStop(boolean cancel) {
        super.onKernalStop(cancel);
        if (this.processor != null) {
            this.processor.onKernalStop(cancel);
        }
    }

    @Override
    public void start() throws IgniteCheckedException {
        super.start();
        if (this.processor != null) {
            this.ctx.addNodeAttribute("grid.security.processor.class", this.processor.getClass().getName());
            this.processor.start();
        } else {
            this.ctx.addNodeAttribute("grid.security.processor.class", this.getClass().getName());
        }
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        super.stop(cancel);
        if (this.processor != null) {
            this.processor.stop(cancel);
        }
    }

    @Override
    public OperationSecurityContext withContext(SecurityContext secCtx) {
        return this.opSecCtx;
    }

    @Override
    public OperationSecurityContext withContext(UUID nodeId) {
        return this.withContext(nodeId, nodeId);
    }

    @Override
    public OperationSecurityContext withContext(UUID senderNodeId, UUID subjectId) {
        return this.opSecCtx;
    }

    @Override
    public SecurityContext securityContext() {
        return null;
    }

    @Override
    public SecurityContext authenticateNode(ClusterNode node, SecurityCredentials cred) {
        return null;
    }

    @Override
    public boolean isGlobalNodeAuthentication() {
        return false;
    }

    @Override
    public SecurityContext authenticate(AuthenticationContext ctx) {
        return null;
    }

    @Override
    public Collection<SecuritySubject> authenticatedSubjects() {
        return null;
    }

    @Override
    public SecuritySubject authenticatedSubject(UUID subjId) {
        return null;
    }

    @Override
    public void onSessionExpired(UUID subjId) {
    }

    @Override
    public void authorize(String name, SecurityPermission perm) throws SecurityException {
    }

    @Override
    public boolean enabled() {
        if (this.processor != null) {
            return this.processor.enabled();
        }
        return false;
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node) {
        IgniteNodeValidationResult res = this.validateSecProcClass(node);
        return res != null || this.processor == null ? res : this.processor.validateNode(node);
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node, DiscoveryDataBag.JoiningNodeDiscoveryData discoData) {
        IgniteNodeValidationResult res = this.validateSecProcClass(node);
        return res != null || this.processor == null ? res : this.processor.validateNode(node, discoData);
    }

    private IgniteNodeValidationResult validateSecProcClass(ClusterNode node) {
        String rmtCls = (String)node.attribute("grid.security.processor.class");
        boolean securityMsgSupported = IgniteFeatures.allNodesSupports(this.ctx, this.ctx.discovery().allNodes(), IgniteFeatures.IGNITE_SECURITY_PROCESSOR);
        if (securityMsgSupported && this.processor != null) {
            String locCls = this.processor.getClass().getName();
            if (!this.processor.enabled() && rmtCls == null) {
                return null;
            }
            if (!F.eq(locCls, rmtCls) && !F.eq(this.getClass().getName(), rmtCls)) {
                return new IgniteNodeValidationResult(node.id(), String.format("Local node's grid security processor class is not equal to remote node's grid security processor class [locNodeId=%s, rmtNodeId=%s, locCls=%s, rmtCls=%s]", this.ctx.localNodeId(), node.id(), locCls, rmtCls), String.format("Local node's grid security processor class is not equal to remote node's grid security processor class [locNodeId=%s, rmtNodeId=%s, locCls=%s, rmtCls=%s]", node.id(), this.ctx.localNodeId(), rmtCls, locCls));
            }
            return null;
        }
        if (securityMsgSupported && rmtCls != null && !rmtCls.equals(this.getClass().getName())) {
            ClusterNode locNode = this.ctx.discovery().localNode();
            return new IgniteNodeValidationResult(node.id(), String.format("Local node's grid security processor class is not equal to remote node's grid security processor class [locNodeId=%s, rmtNodeId=%s, locCls=%s, rmtCls=%s]", locNode.id(), node.id(), "undefined", rmtCls), String.format("Local node's grid security processor class is not equal to remote node's grid security processor class [locNodeId=%s, rmtNodeId=%s, locCls=%s, rmtCls=%s]", node.id(), locNode.id(), rmtCls, "undefined"));
        }
        return null;
    }

    public GridSecurityProcessor gridSecurityProcessor() {
        return this.processor;
    }
}

