/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.misc;

import java.net.InetAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.lang.IgniteBiTuple;

@GridInternal
public class VisorResolveHostNameTask
extends VisorOneNodeTask<Void, Map<String, String>> {
    private static final long serialVersionUID = 0L;

    protected VisorResolveHostNameJob job(Void arg) {
        return new VisorResolveHostNameJob(arg, this.debug);
    }

    private static class VisorResolveHostNameJob
    extends VisorJob<Void, Map<String, String>> {
        private static final long serialVersionUID = 0L;

        private VisorResolveHostNameJob(Void arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected Map<String, String> run(Void arg) {
            HashMap<String, String> res = new HashMap<String, String>();
            try {
                IgniteBiTuple<Collection<String>, Collection<String>> addrs = IgniteUtils.resolveLocalAddresses(InetAddress.getByName("0.0.0.0"), true);
                assert (addrs.get1() != null);
                assert (addrs.get2() != null);
                Iterator<String> ipIt = addrs.get1().iterator();
                Iterator<String> hostIt = addrs.get2().iterator();
                while (ipIt.hasNext() && hostIt.hasNext()) {
                    String ip = ipIt.next();
                    String hostName = hostIt.next();
                    if (hostName == null || hostName.trim().isEmpty()) {
                        try {
                            if (!InetAddress.getByName(ip).isLoopbackAddress()) continue;
                            res.put(ip, "localhost");
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (hostName.equals(ip)) continue;
                    res.put(ip, hostName);
                }
            }
            catch (Exception e) {
                throw new IgniteException("Failed to resolve host name", e);
            }
            return res;
        }

        public String toString() {
            return S.toString(VisorResolveHostNameJob.class, this);
        }
    }
}

