/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.util.Iterator;
import java.util.List;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.query.VisorQueryHolder;
import org.apache.ignite.internal.visor.query.VisorQueryNextPageTaskArg;
import org.apache.ignite.internal.visor.query.VisorQueryResult;
import org.apache.ignite.internal.visor.query.VisorQueryUtils;

@GridInternal
public class VisorQueryNextPageTask
extends VisorOneNodeTask<VisorQueryNextPageTaskArg, VisorQueryResult> {
    private static final long serialVersionUID = 0L;

    protected VisorQueryNextPageJob job(VisorQueryNextPageTaskArg arg) {
        return new VisorQueryNextPageJob(arg, this.debug);
    }

    private static class VisorQueryNextPageJob
    extends VisorJob<VisorQueryNextPageTaskArg, VisorQueryResult> {
        private static final long serialVersionUID = 0L;

        private VisorQueryNextPageJob(VisorQueryNextPageTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorQueryResult run(VisorQueryNextPageTaskArg arg) {
            long start = System.currentTimeMillis();
            String qryId = arg.getQueryId();
            VisorQueryHolder holder = VisorQueryUtils.getQueryHolder(this.ignite, qryId);
            Iterator itr = holder.getIterator();
            List<Object[]> nextRows = VisorQueryHolder.isSqlQuery(qryId) ? VisorQueryUtils.fetchSqlQueryRows(itr, arg.getPageSize()) : VisorQueryUtils.fetchScanQueryRows(itr, arg.getPageSize());
            boolean hasMore = itr.hasNext();
            if (hasMore) {
                holder.setAccessed(true);
            } else {
                VisorQueryUtils.removeQueryHolder(this.ignite, qryId);
            }
            return new VisorQueryResult(this.ignite.localNode().id(), qryId, null, nextRows, hasMore, System.currentTimeMillis() - start);
        }

        public String toString() {
            return S.toString(VisorQueryNextPageJob.class, this);
        }
    }
}

