/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp;

import java.net.InetSocketAddress;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.tracing.NoopTracing;
import org.apache.ignite.internal.processors.tracing.Tracing;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiThread;
import org.apache.ignite.spi.discovery.DiscoverySpiCustomMessage;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryAbstractMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryMetricsUpdateMessage;
import org.jetbrains.annotations.Nullable;

abstract class TcpDiscoveryImpl {
    protected static final int RES_OK = 1;
    protected static final int RES_CONTINUE_JOIN = 100;
    protected static final int RES_WAIT = 200;
    protected static final int RES_JOIN_IMPOSSIBLE = 255;
    public static final long LOG_WARN_MSG_TIMEOUT = 3600000L;
    private static final DateTimeFormatter DEBUG_FORMATTER = DateTimeFormatter.ofPattern("[HH:mm:ss,SSS]").withZone(ZoneId.systemDefault());
    protected final TcpDiscoverySpi spi;
    protected final IgniteLogger log;
    protected volatile TcpDiscoveryNode locNode;
    protected boolean debugMode;
    private int debugMsgHist = 512;
    protected ConcurrentLinkedDeque<String> debugLogQ;
    protected int METRICS_QNT_WARN = IgniteSystemProperties.getInteger("IGNITE_DISCOVERY_METRICS_QNT_WARN", 500);
    protected long endTimeMetricsSizeProcessWait = System.currentTimeMillis();
    protected final DebugLogger debugLog = new DebugLogger(){

        @Override
        public boolean isDebugEnabled() {
            return TcpDiscoveryImpl.this.log.isDebugEnabled();
        }

        @Override
        public void debug(String msg) {
            TcpDiscoveryImpl.this.log.debug(msg);
        }
    };
    protected final DebugLogger traceLog = new DebugLogger(){

        @Override
        public boolean isDebugEnabled() {
            return TcpDiscoveryImpl.this.log.isTraceEnabled();
        }

        @Override
        public void debug(String msg) {
            TcpDiscoveryImpl.this.log.trace(msg);
        }
    };
    protected Tracing tracing;

    protected static <T extends R, R> Collection<R> upcast(Collection<T> c) {
        A.notNull(c, "c");
        return c;
    }

    TcpDiscoveryImpl(TcpDiscoverySpi spi) {
        this.spi = spi;
        this.log = spi.log;
        this.tracing = spi.ignite() instanceof IgniteEx ? ((IgniteEx)spi.ignite()).context().tracing() : new NoopTracing();
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void setDebugMessageHistory(int debugMsgHist) {
        this.debugMsgHist = debugMsgHist;
    }

    protected void debugLog(@Nullable TcpDiscoveryAbstractMessage discoMsg, String msg) {
        assert (this.debugMode);
        String msg0 = DEBUG_FORMATTER.format(Instant.now()) + '[' + Thread.currentThread().getName() + "][" + this.getLocalNodeId() + "-" + this.locNode.internalOrder() + "] " + msg;
        this.debugLogQ.add(msg0);
        int delta = this.debugLogQ.size() - this.debugMsgHist;
        for (int i = 0; i < delta && this.debugLogQ.size() > this.debugMsgHist; ++i) {
            this.debugLogQ.poll();
        }
    }

    public UUID getLocalNodeId() {
        return this.spi.locNode.id();
    }

    public UUID getConfiguredNodeId() {
        return this.spi.cfgNodeId;
    }

    protected void onException(String msg, Exception e) {
        this.spi.getExceptionRegistry().onException(msg, e);
    }

    protected void onMessageExchanged() {
    }

    public abstract void dumpDebugInfo(IgniteLogger var1);

    public abstract String getSpiState();

    public abstract int getMessageWorkerQueueSize();

    public abstract UUID getCoordinator();

    public abstract Collection<ClusterNode> getRemoteNodes();

    public abstract boolean allNodesSupport(IgniteFeatures var1, IgnitePredicate<ClusterNode> var2);

    @Nullable
    public abstract ClusterNode getNode(UUID var1);

    public abstract boolean pingNode(UUID var1);

    public abstract void disconnect() throws IgniteSpiException;

    public abstract void sendCustomEvent(DiscoverySpiCustomMessage var1) throws IgniteException;

    public abstract void failNode(UUID var1, @Nullable String var2);

    public abstract void dumpRingStructure(IgniteLogger var1);

    public abstract long getCurrentTopologyVersion();

    public abstract void spiStart(@Nullable String var1) throws IgniteSpiException;

    public int boundPort() throws IgniteSpiException {
        return 0;
    }

    public long connectionCheckInterval() {
        return 0L;
    }

    public abstract void spiStop() throws IgniteSpiException;

    public abstract void onContextInitialized0(IgniteSpiContext var1) throws IgniteSpiException;

    protected static String threadStatus(Thread t) {
        if (t == null) {
            return "N/A";
        }
        return t.isAlive() ? "alive" : "dead";
    }

    public abstract void reconnect() throws IgniteSpiException;

    abstract void simulateNodeFailure();

    public abstract void brakeConnection();

    public abstract void checkRingLatency(int var1);

    protected abstract Collection<IgniteSpiThread> threads();

    public abstract void updateMetrics(UUID var1, ClusterMetrics var2, Map<Integer, CacheMetrics> var3, long var4);

    protected final void registerLocalNodeAddress() throws IgniteSpiException {
        long spiJoinTimeout = this.spi.getJoinTimeout();
        long startNanos = spiJoinTimeout > 0L ? System.nanoTime() : 0L;
        while (true) {
            try {
                this.spi.ipFinder.initializeLocalAddresses(U.resolveAddresses(this.spi.getAddressResolver(), this.locNode.socketAddresses()));
                break;
            }
            catch (IllegalStateException e) {
                throw new IgniteSpiException("Failed to register local node address with IP finder: " + this.locNode.socketAddresses(), e);
            }
            catch (IgniteSpiException e) {
                LT.error(this.log, e, "Failed to register local node address in IP finder on start (retrying every " + this.spi.getReconnectDelay() + " ms; change 'reconnectDelay' to configure the frequency of retries).");
                if (spiJoinTimeout > 0L && U.millisSinceNanos(startNanos) > spiJoinTimeout) {
                    throw new IgniteSpiException("Failed to register local addresses with IP finder within join timeout (make sure IP finder configuration is correct, and operating system firewalls are disabled on all host machines, or consider increasing 'joinTimeout' configuration property) [joinTimeout=" + spiJoinTimeout + ']');
                }
                try {
                    U.sleep(this.spi.getReconnectDelay());
                }
                catch (IgniteInterruptedCheckedException e2) {
                    throw new IgniteSpiException("Thread has been interrupted.", e2);
                }
            }
        }
    }

    protected boolean checkAckTimeout(long ackTimeout) {
        if (ackTimeout > this.spi.getMaxAckTimeout()) {
            LT.warn(this.log, "Acknowledgement timeout is greater than maximum acknowledgement timeout (consider increasing 'maxAckTimeout' configuration property) [ackTimeout=" + ackTimeout + ", maxAckTimeout=" + this.spi.getMaxAckTimeout() + ']');
            return false;
        }
        return true;
    }

    public void processMsgCacheMetrics(TcpDiscoveryMetricsUpdateMessage msg, long tsNanos) {
        for (Map.Entry<UUID, TcpDiscoveryMetricsUpdateMessage.MetricsSet> e : msg.metrics().entrySet()) {
            Map<Integer, CacheMetrics> cacheMetrics;
            UUID nodeId = e.getKey();
            TcpDiscoveryMetricsUpdateMessage.MetricsSet metricsSet = e.getValue();
            Map<Integer, CacheMetrics> map = cacheMetrics = msg.hasCacheMetrics(nodeId) ? msg.cacheMetrics().get(nodeId) : Collections.emptyMap();
            if (this.endTimeMetricsSizeProcessWait <= U.currentTimeMillis() && cacheMetrics.size() >= this.METRICS_QNT_WARN) {
                this.log.warning("The Discovery message has metrics for " + cacheMetrics.size() + " caches.\nTo prevent Discovery blocking use -DIGNITE_DISCOVERY_DISABLE_CACHE_METRICS_UPDATE=true option.");
                this.endTimeMetricsSizeProcessWait = U.currentTimeMillis() + 3600000L;
            }
            this.updateMetrics(nodeId, metricsSet.metrics(), cacheMetrics, tsNanos);
            for (T2<UUID, ClusterMetrics> t : metricsSet.clientMetrics()) {
                this.updateMetrics((UUID)t.get1(), (ClusterMetrics)t.get2(), cacheMetrics, tsNanos);
            }
        }
    }

    protected static List<String> toOrderedList(Collection<InetSocketAddress> addrs) {
        ArrayList<String> res = new ArrayList<String>(addrs.size());
        for (InetSocketAddress addr : addrs) {
            res.add(addr.toString());
        }
        Collections.sort(res);
        return res;
    }

    protected final DebugLogger messageLogger(TcpDiscoveryAbstractMessage msg) {
        return msg.traceLogLevel() ? this.traceLog : this.debugLog;
    }

    static interface DebugLogger {
        public boolean isDebugEnabled();

        public void debug(String var1);
    }
}

