/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import java.util.Date;
import java.util.UUID;
import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;

public class SqlQueryView {
    private final GridRunningQueryInfo qry;

    public SqlQueryView(GridRunningQueryInfo qry) {
        this.qry = qry;
    }

    @Order(value=2)
    public UUID originNodeId() {
        return this.qry.nodeId();
    }

    @Order
    public String queryId() {
        return this.qry.globalQueryId();
    }

    @Order(value=1)
    public String sql() {
        return this.qry.query();
    }

    public String schemaName() {
        return this.qry.schemaName();
    }

    @Order(value=3)
    public Date startTime() {
        return new Date(this.qry.startTime());
    }

    @Order(value=4)
    public long duration() {
        return System.currentTimeMillis() - this.qry.startTime();
    }

    public boolean local() {
        return this.qry.local();
    }

    public long diskAllocationCurrent() {
        return this.qry.memoryMetricProvider().writtenOnDisk();
    }

    public long diskAllocationMax() {
        return this.qry.memoryMetricProvider().maxWrittenOnDisk();
    }

    public long diskAllocationTotal() {
        return this.qry.memoryMetricProvider().totalWrittenOnDisk();
    }

    public long memoryCurrent() {
        return this.qry.memoryMetricProvider().reserved();
    }

    public long memoryMax() {
        return this.qry.memoryMetricProvider().maxReserved();
    }

    public String initiatorId() {
        return this.qry.queryInitiatorId();
    }

    public boolean distributedJoins() {
        return this.qry.distributedJoins();
    }

    public boolean enforceJoinOrder() {
        return this.qry.enforceJoinOrder();
    }

    public boolean lazy() {
        return this.qry.lazy();
    }
}

