/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.compute.gridify.aop;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.compute.gridify.GridifyInput;
import org.apache.ignite.compute.gridify.GridifyNodeFilter;
import org.apache.ignite.compute.gridify.GridifySetToSet;
import org.apache.ignite.compute.gridify.aop.GridifyDefaultRangeTask;
import org.apache.ignite.internal.compute.ComputeTaskTimeoutCheckedException;
import org.apache.ignite.internal.util.gridify.GridifyRangeArgument;
import org.apache.ignite.internal.util.gridify.GridifyUtils;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridifySetToSetAbstractAspect {
    protected void checkMethodSignature(Method mtd) throws IgniteCheckedException {
        Class<?>[] paramTypes = mtd.getParameterTypes();
        LinkedList<Integer> allowedParamIdxs = new LinkedList<Integer>();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> paramType = paramTypes[i];
            if (!GridifyUtils.isMethodParameterTypeAllowed(paramType)) continue;
            allowedParamIdxs.add(i);
        }
        if (allowedParamIdxs.isEmpty()) {
            throw new IgniteCheckedException("Invalid method signature. Failed to get valid method parameter types [mtdName=" + mtd.getName() + ", allowedTypes=" + GridifyUtils.getAllowedMethodParameterTypes() + ']');
        }
        LinkedList<Integer> annParamIdxs = new LinkedList<Integer>();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> paramType = paramTypes[i];
            if (!GridifyUtils.isMethodParameterTypeAnnotated(paramType.getDeclaredAnnotations())) continue;
            annParamIdxs.add(i);
        }
        if (annParamIdxs.size() > 1) {
            throw new IgniteCheckedException("Invalid method signature. Only one method parameter can may annotated with @" + GridifyInput.class.getSimpleName() + "[mtdName=" + mtd.getName() + ", allowedTypes=" + GridifyUtils.getAllowedMethodParameterTypes() + ", annParamIdxs=" + annParamIdxs + ']');
        }
        if (allowedParamIdxs.size() > 1 && annParamIdxs.isEmpty()) {
            throw new IgniteCheckedException("Invalid method signature. Method parameter must be annotated with @" + GridifyInput.class.getSimpleName() + "[mtdName=" + mtd.getName() + ", allowedTypes=" + GridifyUtils.getAllowedMethodParameterTypes() + ", allowedParamIdxs=" + allowedParamIdxs + ']');
        }
        if (!annParamIdxs.isEmpty() && !allowedParamIdxs.contains(annParamIdxs.get(0))) {
            throw new IgniteCheckedException("Invalid method signature. Invalid annotated parameter [mtdName=" + mtd.getName() + ", allowedTypes=" + GridifyUtils.getAllowedMethodParameterTypes() + ", allowedParamIdxs=" + allowedParamIdxs + ", annParamIdxs=" + annParamIdxs + ']');
        }
        if (!GridifyUtils.isMethodReturnTypeValid(mtd.getReturnType())) {
            throw new IgniteCheckedException("Invalid method signature. Invalid method return type [mtdName=" + mtd.getName() + ", allowedTypes=" + GridifyUtils.getAllowedMethodReturnTypes() + ", mtdReturnType=" + mtd.getReturnType() + ']');
        }
    }

    protected void checkIsSplitToJobsAllowed(GridifyRangeArgument arg, GridifySetToSet ann) throws IgniteCheckedException {
        if (arg.getInputSize() == -1 && ann.threshold() <= 0 && ann.splitSize() <= 0) {
            throw new IgniteCheckedException("Failed to split input method argument to jobs with unknown input size and invalid annotation parameter 'splitSize' [mtdName=" + arg.getMethodName() + ", inputTypeCls=" + arg.getMethodParameterTypes()[arg.getParamIndex()].getName() + ", threshold=" + ann.threshold() + ", splitSize=" + ann.splitSize() + ']');
        }
    }

    protected Object execute(IgniteCompute compute, Class<?> cls, GridifyRangeArgument arg, GridifyNodeFilter nodeFilter, int threshold, int splitSize, long timeout) throws IgniteCheckedException {
        long end;
        long now = U.currentTimeMillis();
        long l = end = timeout == 0L ? Long.MAX_VALUE : timeout + now;
        if (end < 0L) {
            end = Long.MAX_VALUE;
        }
        if (now > end) {
            throw new ComputeTaskTimeoutCheckedException("Timeout occurred while waiting for completion.");
        }
        Collection res = (Collection)compute.withTimeout(timeout == 0L ? 0L : end - now).execute(new GridifyDefaultRangeTask(cls, nodeFilter, threshold, splitSize, false), arg);
        return this.result(arg.getMethodReturnType(), res);
    }

    private Object result(Class<?> cls, Iterable taskRes) {
        assert (taskRes != null);
        LinkedList res = new LinkedList();
        for (Object element : taskRes) {
            res.addAll(GridifyUtils.parameterToCollection(element));
        }
        return GridifyUtils.collectionToParameter(cls, res);
    }
}

