/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary.streams;

import java.util.ArrayDeque;
import java.util.Arrays;
import org.apache.ignite.internal.binary.streams.BinaryMemoryAllocatorChunk;
import org.apache.ignite.internal.util.typedef.internal.U;

public abstract class BinaryMemoryAllocator {
    private static final Long CHECK_FREQ = Long.getLong("IGNITE_MARSHAL_BUFFERS_RECHECK", 10000L);
    private static final int POOL_SIZE = Integer.getInteger("IGNITE_MARSHAL_BUFFERS_PER_THREAD_POOL_SIZE", 32);
    public static final BinaryMemoryAllocator THREAD_LOCAL = new ThreadLocalAllocator();
    public static final BinaryMemoryAllocator POOLED = new PooledAllocator();

    public abstract BinaryMemoryAllocatorChunk chunk();

    public abstract boolean isAcquired();

    private static class PooledAllocator
    extends BinaryMemoryAllocator {
        private final ThreadLocal<DataHoldersPool> holders = ThreadLocal.withInitial(() -> new DataHoldersPool());

        private PooledAllocator() {
        }

        @Override
        public BinaryMemoryAllocatorChunk chunk() {
            return new Chunk(this.holders.get());
        }

        @Override
        public boolean isAcquired() {
            return false;
        }

        private static class Chunk
        implements BinaryMemoryAllocatorChunk {
            private volatile DataHolder holder;
            private final DataHoldersPool pool;

            private Chunk(DataHoldersPool pool) {
                this.pool = pool;
            }

            @Override
            public byte[] allocate(int size) {
                if (this.holder != null) {
                    return new byte[size];
                }
                this.holder = this.pool.acquire();
                return this.holder.ensureCapacity(size, false);
            }

            @Override
            public byte[] reallocate(byte[] data, int size) {
                DataHolder holder0 = this.holder;
                if (holder0 != null && holder0.corresponds(data)) {
                    return holder0.ensureCapacity(size, true);
                }
                return Arrays.copyOf(data, size);
            }

            @Override
            public void release(byte[] data, int msgSize) {
                DataHolder holder0 = this.holder;
                if (holder0 == null || !holder0.corresponds(data)) {
                    return;
                }
                this.holder.adjustSize(msgSize);
                this.pool.release(this.holder);
                this.holder = null;
            }

            @Override
            public boolean isAcquired() {
                return this.holder != null;
            }
        }

        private static class DataHolder {
            private final int[] history = new int[128];
            private int cntr;
            private long lastCheckNanos = System.nanoTime();
            private byte[] data;

            private DataHolder() {
            }

            public byte[] ensureCapacity(int size, boolean copy) {
                if (this.data == null) {
                    this.data = new byte[size];
                } else if (this.data.length < size) {
                    this.data = copy ? Arrays.copyOf(this.data, size) : new byte[size];
                }
                return this.data;
            }

            public boolean corresponds(byte[] data) {
                return data != null && this.data == data;
            }

            public void adjustSize(int msgSize) {
                this.history[this.cntr % this.history.length] = msgSize;
                this.cntr = this.cntr == Integer.MAX_VALUE ? 0 : this.cntr + 1;
                long now = System.nanoTime();
                if (U.nanosToMillis(now - this.lastCheckNanos) >= CHECK_FREQ && this.cntr > this.history.length) {
                    this.lastCheckNanos = now;
                    int[] tmp = Arrays.copyOf(this.history, this.history.length);
                    Arrays.sort(tmp);
                    int adjusted = U.nextPowerOf2(tmp[tmp.length / 2]);
                    if (adjusted < this.data.length) {
                        this.data = new byte[adjusted];
                    }
                }
            }
        }

        private static class DataHoldersPool {
            private final ArrayDeque<DataHolder> pool = new ArrayDeque(BinaryMemoryAllocator.access$500());

            private DataHoldersPool() {
            }

            public synchronized DataHolder acquire() {
                return this.pool.isEmpty() ? new DataHolder() : this.pool.pop();
            }

            public synchronized void release(DataHolder holder) {
                if (this.pool.size() < POOL_SIZE) {
                    this.pool.push(holder);
                }
            }
        }
    }

    private static class ThreadLocalAllocator
    extends BinaryMemoryAllocator {
        private final ThreadLocal<BinaryMemoryAllocatorChunk> holders = new ThreadLocal();

        private ThreadLocalAllocator() {
        }

        @Override
        public BinaryMemoryAllocatorChunk chunk() {
            BinaryMemoryAllocatorChunk holder = this.holders.get();
            if (holder == null) {
                holder = new Chunk();
                this.holders.set(holder);
            }
            return holder;
        }

        @Override
        public boolean isAcquired() {
            BinaryMemoryAllocatorChunk holder = this.holders.get();
            return holder != null && holder.isAcquired();
        }

        private static class Chunk
        implements BinaryMemoryAllocatorChunk {
            private byte[] data;
            private int maxMsgSize;
            private long lastCheckNanos = System.nanoTime();
            private boolean acquired;

            private Chunk() {
            }

            @Override
            public byte[] allocate(int size) {
                if (this.acquired) {
                    return new byte[size];
                }
                this.acquired = true;
                if (this.data == null || size > this.data.length) {
                    this.data = new byte[size];
                }
                return this.data;
            }

            @Override
            public byte[] reallocate(byte[] data, int size) {
                byte[] newData = new byte[size];
                if (this.data == data) {
                    this.data = newData;
                }
                System.arraycopy(data, 0, newData, 0, data.length);
                return newData;
            }

            @Override
            public void release(byte[] data, int maxMsgSize) {
                if (this.data != data) {
                    return;
                }
                if (maxMsgSize > this.maxMsgSize) {
                    this.maxMsgSize = maxMsgSize;
                }
                this.acquired = false;
                long nowNanos = System.nanoTime();
                if (U.nanosToMillis(nowNanos - this.lastCheckNanos) >= CHECK_FREQ) {
                    int halfSize = data.length >> 1;
                    if (this.maxMsgSize < halfSize) {
                        this.data = new byte[halfSize];
                    }
                    this.lastCheckNanos = nowNanos;
                }
            }

            @Override
            public boolean isAcquired() {
                return this.acquired;
            }
        }
    }
}

