/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.impl.connection;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.client.GridClientAuthenticationException;
import org.apache.ignite.internal.client.GridClientCacheFlag;
import org.apache.ignite.internal.client.GridClientCacheMode;
import org.apache.ignite.internal.client.GridClientClosedException;
import org.apache.ignite.internal.client.GridClientDataMetrics;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientFuture;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.impl.GridClientFutureAdapter;
import org.apache.ignite.internal.client.impl.GridClientFutureCallback;
import org.apache.ignite.internal.client.impl.GridClientNodeImpl;
import org.apache.ignite.internal.client.impl.GridClientNodeMetricsAdapter;
import org.apache.ignite.internal.client.impl.connection.GridClientConnection;
import org.apache.ignite.internal.client.impl.connection.GridClientConnectionCloseReason;
import org.apache.ignite.internal.client.impl.connection.GridClientConnectionResetException;
import org.apache.ignite.internal.client.impl.connection.GridClientTopology;
import org.apache.ignite.internal.client.marshaller.GridClientMarshaller;
import org.apache.ignite.internal.client.marshaller.jdk.GridClientJdkMarshaller;
import org.apache.ignite.internal.client.marshaller.optimized.GridClientOptimizedMarshaller;
import org.apache.ignite.internal.client.marshaller.optimized.GridClientZipOptimizedMarshaller;
import org.apache.ignite.internal.processors.rest.client.message.GridClientAuthenticationRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientAuthenticationRequestV2;
import org.apache.ignite.internal.processors.rest.client.message.GridClientCacheBean;
import org.apache.ignite.internal.processors.rest.client.message.GridClientCacheRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientClusterNameRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientClusterStateRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientClusterStateRequestV2;
import org.apache.ignite.internal.processors.rest.client.message.GridClientHandshakeRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientMessage;
import org.apache.ignite.internal.processors.rest.client.message.GridClientNodeBean;
import org.apache.ignite.internal.processors.rest.client.message.GridClientNodeMetricsBean;
import org.apache.ignite.internal.processors.rest.client.message.GridClientNodeStateBeforeStartRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientPingPacket;
import org.apache.ignite.internal.processors.rest.client.message.GridClientResponse;
import org.apache.ignite.internal.processors.rest.client.message.GridClientStateRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientTaskRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientTaskResultBean;
import org.apache.ignite.internal.processors.rest.client.message.GridClientTopologyRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridRouterRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridRouterResponse;
import org.apache.ignite.internal.util.GridArgumentCheck;
import org.apache.ignite.internal.util.nio.GridNioFuture;
import org.apache.ignite.internal.util.nio.GridNioFutureImpl;
import org.apache.ignite.internal.util.nio.GridNioServer;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionMetaKey;
import org.apache.ignite.internal.util.nio.ssl.GridNioSslFilter;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.util.VisorIllegalStateException;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.jetbrains.annotations.Nullable;

public class GridClientNioTcpConnection
extends GridClientConnection {
    static final int SES_META_HANDSHAKE = GridNioSessionMetaKey.nextUniqueKey();
    static final int SES_META_CONN = GridNioSessionMetaKey.nextUniqueKey();
    private static final Logger log = Logger.getLogger(GridClientNioTcpConnection.class.getName());
    private final long pingInterval;
    private final long pingTimeout;
    private ConcurrentMap<Long, TcpClientFuture> pendingReqs = new ConcurrentHashMap<Long, TcpClientFuture>();
    private ConcurrentMap<UUID, TcpClientFuture> refreshNodeReqs = new ConcurrentHashMap<UUID, TcpClientFuture>();
    private final CountDownLatch closedLatch = new CountDownLatch(1);
    private AtomicLong reqIdCntr = new AtomicLong(1L);
    private volatile long lastMsgSndTime;
    private volatile long lastMsgRcvTime;
    private volatile long lastPingRcvTime;
    private volatile long lastPingSndTime;
    private long createTs;
    private volatile byte[] sesTok;
    private ScheduledFuture<?> pingTask;
    private GridNioSession ses;
    private final GridClientMarshaller marsh;
    Map<String, String> userAttrs;

    GridClientNioTcpConnection(GridNioServer srv, UUID clientId, InetSocketAddress srvAddr, SSLContext sslCtx, ScheduledExecutorService pingExecutor, int connectTimeout, long pingInterval, long pingTimeout, boolean tcpNoDelay, GridClientMarshaller marsh, Byte marshId, GridClientTopology top, SecurityCredentials cred, Map<String, String> userAttrs) throws IOException, GridClientException {
        super(clientId, srvAddr, sslCtx, top, cred);
        assert (marsh != null || marshId != null);
        this.marsh = marsh;
        this.pingInterval = pingInterval;
        this.pingTimeout = pingTimeout;
        this.userAttrs = userAttrs;
        SocketChannel ch = null;
        Socket sock = null;
        boolean cleanup = true;
        try {
            ch = SocketChannel.open();
            sock = ch.socket();
            sock.setTcpNoDelay(tcpNoDelay);
            sock.setKeepAlive(true);
            long startConnTime = System.currentTimeMillis();
            sock.connect(srvAddr, connectTimeout);
            long connTimeoutRest = (long)connectTimeout - (System.currentTimeMillis() - startConnTime);
            GridClientFutureAdapter handshakeFut = new GridClientFutureAdapter();
            HashMap<Integer, Object> meta = new HashMap<Integer, Object>();
            meta.put(SES_META_HANDSHAKE, handshakeFut);
            GridNioFutureImpl sslHandshakeFut = null;
            if (sslCtx != null) {
                sslHandshakeFut = new GridNioFutureImpl(null);
                meta.put(GridNioSslFilter.HANDSHAKE_FUT_META_KEY, sslHandshakeFut);
            }
            this.ses = (GridNioSession)srv.createSession(ch, meta, false, null).get();
            if (sslHandshakeFut != null) {
                sslHandshakeFut.get();
            }
            GridClientHandshakeRequest req = new GridClientHandshakeRequest();
            if (marshId != null) {
                req.marshallerId(marshId);
            } else if (marsh instanceof GridClientZipOptimizedMarshaller) {
                req.marshallerId((byte)3);
            } else if (marsh instanceof GridClientOptimizedMarshaller) {
                req.marshallerId((byte)1);
            } else if (marsh instanceof GridClientJdkMarshaller) {
                req.marshallerId((byte)2);
            }
            this.ses.addMeta(GridNioSessionMetaKey.MARSHALLER.ordinal(), marsh);
            this.ses.send(req);
            handshakeFut.get(connTimeoutRest, TimeUnit.MILLISECONDS);
            this.ses.addMeta(SES_META_CONN, this);
            if (cred != null || !F.isEmpty(userAttrs)) {
                GridClientFutureAdapter authFut = this.makeAuthRequest();
                authFut.get(connTimeoutRest, TimeUnit.MILLISECONDS);
            }
            if (log.isLoggable(Level.INFO)) {
                log.info("Client TCP connection established: " + this.serverAddress());
            }
            this.pingTask = pingExecutor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        GridClientNioTcpConnection.this.makeRequest(GridClientPingPacket.PING_MESSAGE, null, false);
                    }
                    catch (Exception e) {
                        log.warning("Failed to send ping message: " + e);
                    }
                }
            }, 500L, 500L, TimeUnit.MILLISECONDS);
            this.createTs = System.currentTimeMillis();
            cleanup = false;
        }
        catch (IgniteCheckedException e) {
            throw new GridClientException(e);
        }
        finally {
            if (cleanup) {
                if (this.ses != null) {
                    srv.close(this.ses);
                }
                if (sock != null) {
                    sock.close();
                }
                if (ch != null) {
                    ch.close();
                }
            }
        }
    }

    @Override
    void close(GridClientConnectionCloseReason reason, boolean waitCompletion) {
        this.close(reason, waitCompletion, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void close(GridClientConnectionCloseReason reason, boolean waitCompletion, @Nullable Throwable cause) {
        GridClientNioTcpConnection gridClientNioTcpConnection = this;
        synchronized (gridClientNioTcpConnection) {
            if (this.closeReason != null) {
                return;
            }
            this.closeReason = reason;
        }
        try {
            if (waitCompletion && !this.pendingReqs.isEmpty() && this.ses.closeTime() == 0L) {
                this.closedLatch.await();
            }
        }
        catch (InterruptedException ignored) {
            log.warning("Interrupted while waiting for all requests to be processed (all pending requests will be failed): " + this.serverAddress());
            Thread.currentThread().interrupt();
        }
        if (this.pingTask != null) {
            this.pingTask.cancel(false);
        }
        if (this.ses != null) {
            this.ses.close();
        }
        Iterator it = this.pendingReqs.values().iterator();
        while (it.hasNext()) {
            GridClientFutureAdapter fut = (GridClientFutureAdapter)it.next();
            fut.onDone(this.getCloseReasonAsException(this.closeReason, cause));
            it.remove();
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Client TCP connection closed: " + this.serverAddress());
        }
    }

    @Override
    boolean closeIfIdle(long idleTimeout) {
        if (this.closeReason != null) {
            return true;
        }
        long lastMsgTime = Math.max(Math.max(this.lastMsgSndTime, this.lastMsgRcvTime), this.createTs);
        if (lastMsgTime + idleTimeout < System.currentTimeMillis() && this.pendingReqs.isEmpty()) {
            this.close(GridClientConnectionCloseReason.CONN_IDLE, true);
            return true;
        }
        return false;
    }

    private <R> GridClientFutureAdapter<R> makeRequest(GridClientMessage msg, UUID destId) throws GridClientConnectionResetException, GridClientClosedException {
        return this.makeRequest(msg, destId, false);
    }

    private <R> GridClientFutureAdapter<R> makeRequest(GridClientMessage msg, UUID destId, boolean keepBinaries) throws GridClientConnectionResetException, GridClientClosedException {
        assert (msg != null);
        TcpClientFuture res = new TcpClientFuture(false, keepBinaries);
        msg.destinationId(destId);
        return this.makeRequest(msg, res);
    }

    private <R> GridClientFutureAdapter<R> makeRequest(GridClientMessage msg, TcpClientFuture<R> fut) throws GridClientConnectionResetException, GridClientClosedException {
        return this.makeRequest(msg, fut, false);
    }

    private <R> GridClientFutureAdapter<R> makeRequest(GridClientMessage msg, final TcpClientFuture<R> fut, boolean routeMode) throws GridClientConnectionResetException, GridClientClosedException {
        assert (msg != null);
        if (msg instanceof GridClientPingPacket) {
            long now = System.currentTimeMillis();
            if (Math.min(now, this.lastPingRcvTime) - this.lastPingSndTime >= this.pingTimeout) {
                this.close(GridClientConnectionCloseReason.FAILED, false, new IOException("Did not receive any packets within ping response interval (connection is considered to be half-opened) [lastPingReceiveTime=" + this.lastPingRcvTime + ", lastPingSendTime=" + this.lastPingSndTime + ", now=" + now + ", timeout=" + this.pingTimeout + ", addr=" + this.serverAddress() + ']'));
            } else if (now - this.lastPingSndTime > this.pingInterval && this.lastPingRcvTime != Long.MAX_VALUE) {
                this.lastPingRcvTime = Long.MAX_VALUE;
                this.ses.send(GridClientPingPacket.PING_MESSAGE);
                this.lastPingSndTime = now;
            }
        } else {
            long reqId = this.reqIdCntr.getAndIncrement();
            msg.requestId(reqId);
            if (!routeMode) {
                msg.clientId(this.clientId);
                msg.sessionToken(this.sesTok);
            }
            fut.pendingMessage(msg);
            this.checkClosed(this.closeReason);
            GridClientFutureAdapter old = this.pendingReqs.putIfAbsent(reqId, fut);
            assert (old == null);
            GridNioFuture<?> sndFut = this.ses.send(msg);
            this.lastMsgSndTime = System.currentTimeMillis();
            if (routeMode) {
                sndFut.listen(new CI1<IgniteInternalFuture<?>>(){

                    @Override
                    public void apply(IgniteInternalFuture<?> sndFut) {
                        try {
                            sndFut.get();
                        }
                        catch (Exception e) {
                            GridClientNioTcpConnection.this.close(GridClientConnectionCloseReason.FAILED, false, e);
                            fut.onDone(GridClientNioTcpConnection.this.getCloseReasonAsException(GridClientConnectionCloseReason.FAILED, e));
                        }
                    }
                });
            } else {
                try {
                    sndFut.get();
                }
                catch (Exception e) {
                    throw new GridClientConnectionResetException("Failed to send message over connection (will try to reconnect): " + this.serverAddress(), e);
                }
            }
        }
        return fut;
    }

    void handlePingResponse() {
        this.lastPingRcvTime = System.currentTimeMillis();
    }

    void handleResponse(GridClientMessage res) throws IOException {
        this.lastMsgRcvTime = System.currentTimeMillis();
        TcpClientFuture fut = (TcpClientFuture)this.pendingReqs.get(res.requestId());
        if (fut == null) {
            log.warning("Response for an unknown request is received, ignoring. [res=" + res + ", ses=" + this.ses + ']');
            return;
        }
        if (fut.forward()) {
            this.removePending(res.requestId());
            fut.onDone(res);
        } else {
            GridClientMessage res0 = res;
            if (res instanceof GridRouterResponse) {
                res0 = (GridClientMessage)this.marsh.unmarshal(((GridRouterResponse)res).body());
                res0.requestId(res.requestId());
                res0.clientId(res.clientId());
                res0.destinationId(res.destinationId());
            }
            if (res0 instanceof GridClientResponse) {
                this.handleClientResponse(fut, (GridClientResponse)res0);
            } else {
                log.warning("Unsupported response type received: " + res0);
            }
        }
    }

    private void handleClientResponse(TcpClientFuture fut, GridClientResponse resp) {
        if (resp.sessionToken() != null) {
            this.sesTok = resp.sessionToken();
        }
        GridClientMessage src = fut.pendingMessage();
        switch (fut.retryState()) {
            case 0: {
                if (resp.successStatus() != 2) break;
                if (this.credentials() == null) {
                    fut.onDone(new GridClientAuthenticationException("Authentication failed on server (client has no credentials) [clientId=" + this.clientId + ", srvAddr=" + this.serverAddress() + ", errMsg=" + resp.errorMessage() + ']'));
                    this.removePending(resp.requestId());
                    return;
                }
                fut.retryState(1);
                GridClientAuthenticationRequest req = this.buildAuthRequest();
                req.requestId(resp.requestId());
                this.ses.send(req);
                return;
            }
            case 1: {
                if (resp.successStatus() != 0) break;
                fut.retryState(2);
                src.sessionToken(this.sesTok);
                this.ses.send(src);
                return;
            }
        }
        this.removePending(resp.requestId());
        if (resp.successStatus() == 2) {
            fut.onDone(new GridClientAuthenticationException("Client authentication failed [clientId=" + this.clientId + ", srvAddr=" + this.serverAddress() + ", errMsg=" + resp.errorMessage() + ']'));
        } else if (resp.successStatus() == 4) {
            fut.onDone(new VisorIllegalStateException(resp.errorMessage()));
        } else if (resp.errorMessage() != null) {
            fut.onDone(new GridClientException(resp.errorMessage()));
        } else {
            fut.onDone(resp.result());
        }
    }

    private void removePending(long reqId) {
        this.pendingReqs.remove(reqId);
        if (this.pendingReqs.isEmpty() && this.closeReason != null) {
            this.closedLatch.countDown();
        }
    }

    private <R> GridClientFutureAdapter<R> makeAuthRequest() throws GridClientConnectionResetException, GridClientClosedException {
        TcpClientFuture fut = new TcpClientFuture();
        fut.retryState(2);
        GridClientAuthenticationRequest req = this.buildAuthRequest();
        return this.makeRequest((GridClientMessage)req, fut, false);
    }

    private GridClientAuthenticationRequest buildAuthRequest() {
        GridClientAuthenticationRequestV2 req = new GridClientAuthenticationRequestV2();
        req.clientId(this.clientId);
        req.credentials(this.credentials());
        req.userAttributes(this.userAttrs);
        return req;
    }

    @Override
    public <K, V> GridClientFutureAdapter<Boolean> cachePutAll(String cacheName, Map<K, V> entries, Set<GridClientCacheFlag> flags, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
        assert (entries != null);
        GridClientCacheRequest req = new GridClientCacheRequest(GridClientCacheRequest.GridCacheOperation.PUT_ALL);
        req.cacheName(cacheName);
        req.values(entries);
        req.cacheFlagsOn(GridClientCacheFlag.encodeCacheFlags(flags));
        return this.makeRequest((GridClientMessage)req, destNodeId);
    }

    @Override
    public <K, V> GridClientFutureAdapter<Map<K, V>> cacheGetAll(String cacheName, Collection<K> keys, Set<GridClientCacheFlag> flags, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
        assert (keys != null);
        GridClientCacheRequest req = new GridClientCacheRequest(GridClientCacheRequest.GridCacheOperation.GET_ALL);
        req.cacheName(cacheName);
        req.keys(keys);
        req.cacheFlagsOn(GridClientCacheFlag.encodeCacheFlags(flags));
        return this.makeRequest((GridClientMessage)req, destNodeId, flags.contains((Object)GridClientCacheFlag.KEEP_BINARIES));
    }

    @Override
    public <K> GridClientFutureAdapter<Boolean> cacheRemove(String cacheName, K key, Set<GridClientCacheFlag> flags, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
        GridClientCacheRequest req = new GridClientCacheRequest(GridClientCacheRequest.GridCacheOperation.RMV);
        req.cacheName(cacheName);
        req.key(key);
        req.cacheFlagsOn(GridClientCacheFlag.encodeCacheFlags(flags));
        return this.makeRequest((GridClientMessage)req, destNodeId);
    }

    @Override
    public <K> GridClientFutureAdapter<Boolean> cacheRemoveAll(String cacheName, Collection<K> keys, Set<GridClientCacheFlag> flags, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
        assert (keys != null);
        GridClientCacheRequest req = new GridClientCacheRequest(GridClientCacheRequest.GridCacheOperation.RMV_ALL);
        req.cacheName(cacheName);
        req.keys(keys);
        req.cacheFlagsOn(GridClientCacheFlag.encodeCacheFlags(flags));
        return this.makeRequest((GridClientMessage)req, destNodeId);
    }

    @Override
    public <K, V> GridClientFutureAdapter<Boolean> cacheReplace(String cacheName, K key, V val, Set<GridClientCacheFlag> flags, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
        assert (key != null);
        assert (val != null);
        GridClientCacheRequest replace = new GridClientCacheRequest(GridClientCacheRequest.GridCacheOperation.REPLACE);
        replace.cacheName(cacheName);
        replace.key(key);
        replace.value(val);
        replace.cacheFlagsOn(GridClientCacheFlag.encodeCacheFlags(flags));
        return this.makeRequest((GridClientMessage)replace, destNodeId);
    }

    @Override
    public <K, V> GridClientFutureAdapter<Boolean> cacheCompareAndSet(String cacheName, K key, V newVal, V oldVal, Set<GridClientCacheFlag> flags, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
        assert (key != null);
        GridClientCacheRequest msg = new GridClientCacheRequest(GridClientCacheRequest.GridCacheOperation.CAS);
        msg.cacheName(cacheName);
        msg.key(key);
        msg.value(newVal);
        msg.value2(oldVal);
        msg.cacheFlagsOn(GridClientCacheFlag.encodeCacheFlags(flags));
        return this.makeRequest((GridClientMessage)msg, destNodeId);
    }

    @Override
    public <K> GridClientFutureAdapter<GridClientDataMetrics> cacheMetrics(String cacheName, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
        GridClientCacheRequest metrics = new GridClientCacheRequest(GridClientCacheRequest.GridCacheOperation.METRICS);
        metrics.cacheName(cacheName);
        metrics.destinationId(destNodeId);
        TcpClientFuture fut = new TcpClientFuture(){

            @Override
            public void onDone(Object res) {
                super.onDone(GridClientNioTcpConnection.this.metricsMapToMetrics((Map)res));
            }
        };
        return this.makeRequest((GridClientMessage)metrics, fut);
    }

    @Override
    public <K, V> GridClientFutureAdapter<Boolean> cacheAppend(String cacheName, K key, V val, Set<GridClientCacheFlag> flags, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
        assert (key != null);
        assert (val != null);
        GridClientCacheRequest append = new GridClientCacheRequest(GridClientCacheRequest.GridCacheOperation.APPEND);
        append.cacheName(cacheName);
        append.key(key);
        append.value(val);
        append.cacheFlagsOn(GridClientCacheFlag.encodeCacheFlags(flags));
        return this.makeRequest((GridClientMessage)append, destNodeId);
    }

    @Override
    public <K, V> GridClientFutureAdapter<Boolean> cachePrepend(String cacheName, K key, V val, Set<GridClientCacheFlag> flags, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
        assert (key != null);
        assert (val != null);
        GridClientCacheRequest prepend = new GridClientCacheRequest(GridClientCacheRequest.GridCacheOperation.PREPEND);
        prepend.cacheName(cacheName);
        prepend.key(key);
        prepend.value(val);
        prepend.cacheFlagsOn(GridClientCacheFlag.encodeCacheFlags(flags));
        return this.makeRequest((GridClientMessage)prepend, destNodeId);
    }

    @Override
    public <R> GridClientFutureAdapter<R> execute(String taskName, Object arg, UUID destNodeId, boolean keepBinaries) throws GridClientConnectionResetException, GridClientClosedException {
        GridClientTaskRequest msg = new GridClientTaskRequest();
        msg.taskName(taskName);
        msg.argument(arg);
        msg.keepBinaries(keepBinaries);
        return this.makeRequest((GridClientMessage)msg, destNodeId).chain(new GridClientFutureCallback<GridClientTaskResultBean, R>(){

            @Override
            public R onComplete(GridClientFuture<GridClientTaskResultBean> fut) throws GridClientException {
                return fut.get().getResult();
            }
        });
    }

    @Override
    public GridClientFuture<?> changeState(boolean active, UUID destNodeId) throws GridClientClosedException, GridClientConnectionResetException {
        GridClientStateRequest msg = new GridClientStateRequest();
        msg.active(active);
        return this.makeRequest((GridClientMessage)msg, destNodeId);
    }

    @Override
    public GridClientFuture<?> changeState(ClusterState state, UUID destNodeId, boolean forceDeactivation) throws GridClientClosedException, GridClientConnectionResetException {
        GridArgumentCheck.notNull((Object)state, "state");
        return this.makeRequest((GridClientMessage)GridClientClusterStateRequestV2.state(state, forceDeactivation), destNodeId);
    }

    @Override
    public GridClientFuture<?> changeState(ClusterState state, UUID destNodeId) throws GridClientClosedException, GridClientConnectionResetException {
        GridArgumentCheck.notNull((Object)state, "state");
        return this.makeRequest((GridClientMessage)GridClientClusterStateRequest.state(state), destNodeId);
    }

    @Override
    public GridClientFuture<Boolean> currentState(UUID destNodeId) throws GridClientClosedException, GridClientConnectionResetException {
        GridClientFutureAdapter<Boolean> resFut = new GridClientFutureAdapter<Boolean>();
        this.state(destNodeId).listen(fut -> {
            try {
                resFut.onDone(ClusterState.active((ClusterState)((Object)((Object)fut.get()))));
            }
            catch (GridClientException e) {
                resFut.onDone(e);
            }
        });
        return resFut;
    }

    @Override
    public GridClientFuture<ClusterState> state(UUID destNodeId) throws GridClientClosedException, GridClientConnectionResetException {
        return this.makeRequest((GridClientMessage)GridClientClusterStateRequest.currentState(), destNodeId);
    }

    @Override
    public GridClientFuture<GridClientNode> node(final UUID id, boolean inclAttrs, boolean inclMetrics, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
        assert (id != null);
        TcpClientFuture fut = (TcpClientFuture)this.refreshNodeReqs.get(id);
        if (fut != null) {
            return fut;
        }
        GridClientTopologyRequest msg = new GridClientTopologyRequest();
        fut = new TcpClientFuture(){

            @Override
            public void onDone(Object res) {
                GridClientNioTcpConnection.this.refreshNodeReqs.remove(id);
                GridClientNodeImpl node = GridClientNioTcpConnection.this.nodeBeanToNode((GridClientNodeBean)res);
                if (node != null) {
                    GridClientNioTcpConnection.this.top.updateNode(node);
                }
                super.onDone(node);
            }
        };
        GridClientFutureAdapter old = this.refreshNodeReqs.putIfAbsent(id, fut);
        if (old != null) {
            return old;
        }
        msg.nodeId(id);
        this.setupMessage(inclAttrs, inclMetrics, destNodeId, msg);
        return this.makeRequest((GridClientMessage)msg, fut);
    }

    private void setupMessage(boolean inclAttrs, boolean inclMetrics, UUID destNodeId, GridClientTopologyRequest msg) {
        msg.includeAttributes(inclAttrs);
        msg.includeMetrics(inclMetrics);
        msg.destinationId(destNodeId);
    }

    @Override
    public GridClientFuture<GridClientNode> node(String ipAddr, boolean inclAttrs, boolean includeMetrics, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
        GridClientTopologyRequest msg = new GridClientTopologyRequest();
        TcpClientFuture fut = new TcpClientFuture(){

            @Override
            public void onDone(Object res) {
                GridClientNodeImpl node = GridClientNioTcpConnection.this.nodeBeanToNode((GridClientNodeBean)res);
                if (node != null) {
                    super.onDone(GridClientNioTcpConnection.this.top.updateNode(node));
                } else {
                    super.onDone(node);
                }
            }
        };
        msg.nodeIp(ipAddr);
        this.setupMessage(inclAttrs, includeMetrics, destNodeId, msg);
        return this.makeRequest((GridClientMessage)msg, fut);
    }

    @Override
    public GridClientFuture<List<GridClientNode>> topology(boolean inclAttrs, boolean inclMetrics, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
        GridClientTopologyRequest msg = new GridClientTopologyRequest();
        TcpClientFuture fut = new TcpClientFuture(){

            @Override
            public void onDone(Object res) {
                Collection beans = (Collection)res;
                ArrayList<GridClientNodeImpl> nodes = new ArrayList<GridClientNodeImpl>(beans.size());
                for (GridClientNodeBean bean : beans) {
                    nodes.add(GridClientNioTcpConnection.this.nodeBeanToNode(bean));
                }
                super.onDone(GridClientNioTcpConnection.this.top.updateTopology(nodes));
            }
        };
        this.setupMessage(inclAttrs, inclMetrics, destNodeId, msg);
        return this.makeRequest((GridClientMessage)msg, fut);
    }

    public GridClientFutureAdapter<GridRouterRequest> forwardMessage(Object msg) throws GridClientException {
        assert (msg instanceof GridRouterRequest);
        TcpClientFuture<GridRouterRequest> res = new TcpClientFuture<GridRouterRequest>(true, false);
        this.makeRequest((GridClientMessage)msg, res, true);
        return res;
    }

    @Override
    public GridClientFuture<String> clusterName(UUID destNodeId) throws GridClientClosedException, GridClientConnectionResetException {
        return this.makeRequest((GridClientMessage)new GridClientClusterNameRequest(), destNodeId);
    }

    @Nullable
    private GridClientNodeImpl nodeBeanToNode(@Nullable GridClientNodeBean nodeBean) {
        GridClientNodeMetricsBean metricsBean;
        if (nodeBean == null) {
            return null;
        }
        GridClientNodeImpl.Builder nodeBuilder = GridClientNodeImpl.builder().nodeId(nodeBean.getNodeId()).consistentId(nodeBean.getConsistentId()).tcpAddresses(nodeBean.getTcpAddresses()).tcpPort(nodeBean.getTcpPort()).order(nodeBean.getOrder());
        HashMap<String, GridClientCacheMode> caches = new HashMap<String, GridClientCacheMode>();
        if (nodeBean.getCaches() != null) {
            for (GridClientCacheBean cacheBean : nodeBean.getCaches()) {
                try {
                    caches.put(cacheBean.getName(), cacheBean.getMode());
                }
                catch (IllegalArgumentException ignored) {
                    log.warning("Invalid cache mode received from remote node (will ignore) [srv=" + this.serverAddress() + ", cacheName=" + cacheBean.getName() + ", cacheMode=" + (Object)((Object)cacheBean.getMode()) + ']');
                }
            }
        }
        if (!caches.isEmpty()) {
            nodeBuilder.caches(caches);
        }
        if (nodeBean.getAttributes() != null) {
            nodeBuilder.attributes(nodeBean.getAttributes());
        }
        if ((metricsBean = nodeBean.getMetrics()) != null) {
            GridClientNodeMetricsAdapter metrics = new GridClientNodeMetricsAdapter();
            metrics.setStartTime(metricsBean.getStartTime());
            metrics.setAverageActiveJobs(metricsBean.getAverageActiveJobs());
            metrics.setAverageCancelledJobs(metricsBean.getAverageCancelledJobs());
            metrics.setAverageCpuLoad(metricsBean.getAverageCpuLoad());
            metrics.setAverageJobExecuteTime(metricsBean.getAverageJobExecuteTime());
            metrics.setAverageJobWaitTime(metricsBean.getAverageJobWaitTime());
            metrics.setAverageRejectedJobs(metricsBean.getAverageRejectedJobs());
            metrics.setAverageWaitingJobs(metricsBean.getAverageWaitingJobs());
            metrics.setCurrentActiveJobs(metricsBean.getCurrentActiveJobs());
            metrics.setCurrentCancelledJobs(metricsBean.getCurrentCancelledJobs());
            metrics.setCurrentCpuLoad(metricsBean.getCurrentCpuLoad());
            metrics.setCurrentGcCpuLoad(metricsBean.getCurrentGcCpuLoad());
            metrics.setCurrentDaemonThreadCount(metricsBean.getCurrentDaemonThreadCount());
            metrics.setCurrentIdleTime(metricsBean.getCurrentIdleTime());
            metrics.setCurrentJobExecuteTime(metricsBean.getCurrentJobExecuteTime());
            metrics.setCurrentJobWaitTime(metricsBean.getCurrentJobWaitTime());
            metrics.setCurrentRejectedJobs(metricsBean.getCurrentRejectedJobs());
            metrics.setCurrentThreadCount(metricsBean.getCurrentThreadCount());
            metrics.setCurrentWaitingJobs(metricsBean.getCurrentWaitingJobs());
            metrics.setFileSystemFreeSpace(metricsBean.getFileSystemFreeSpace());
            metrics.setFileSystemTotalSpace(metricsBean.getFileSystemTotalSpace());
            metrics.setFileSystemUsableSpace(metricsBean.getFileSystemUsableSpace());
            metrics.setHeapMemoryCommitted(metricsBean.getHeapMemoryCommitted());
            metrics.setHeapMemoryInitialized(metricsBean.getHeapMemoryInitialized());
            metrics.setHeapMemoryMaximum(metricsBean.getHeapMemoryMaximum());
            metrics.setHeapMemoryUsed(metricsBean.getHeapMemoryUsed());
            metrics.setLastDataVersion(metricsBean.getLastDataVersion());
            metrics.setLastUpdateTime(metricsBean.getLastUpdateTime());
            metrics.setMaximumActiveJobs(metricsBean.getMaximumActiveJobs());
            metrics.setMaximumCancelledJobs(metricsBean.getMaximumCancelledJobs());
            metrics.setMaximumJobExecuteTime(metricsBean.getMaximumJobExecuteTime());
            metrics.setMaximumJobWaitTime(metricsBean.getMaximumJobWaitTime());
            metrics.setMaximumRejectedJobs(metricsBean.getMaximumRejectedJobs());
            metrics.setMaximumThreadCount(metricsBean.getMaximumThreadCount());
            metrics.setMaximumWaitingJobs(metricsBean.getMaximumWaitingJobs());
            metrics.setNodeStartTime(metricsBean.getNodeStartTime());
            metrics.setNonHeapMemoryCommitted(metricsBean.getNonHeapMemoryCommitted());
            metrics.setNonHeapMemoryInitialized(metricsBean.getNonHeapMemoryInitialized());
            metrics.setNonHeapMemoryMaximum(metricsBean.getNonHeapMemoryMaximum());
            metrics.setNonHeapMemoryUsed(metricsBean.getNonHeapMemoryUsed());
            metrics.setStartTime(metricsBean.getStartTime());
            metrics.setTotalCancelledJobs(metricsBean.getTotalCancelledJobs());
            metrics.setTotalCpus(metricsBean.getTotalCpus());
            metrics.setTotalExecutedJobs(metricsBean.getTotalExecutedJobs());
            metrics.setTotalIdleTime(metricsBean.getTotalIdleTime());
            metrics.setTotalRejectedJobs(metricsBean.getTotalRejectedJobs());
            metrics.setTotalStartedThreadCount(metricsBean.getTotalStartedThreadCount());
            metrics.setTotalExecutedTasks(metricsBean.getTotalExecutedTasks());
            metrics.setSentMessagesCount(metricsBean.getSentMessagesCount());
            metrics.setSentBytesCount(metricsBean.getSentBytesCount());
            metrics.setReceivedMessagesCount(metricsBean.getReceivedMessagesCount());
            metrics.setReceivedBytesCount(metricsBean.getReceivedBytesCount());
            metrics.setUpTime(metricsBean.getUpTime());
            nodeBuilder.metrics(metrics);
        }
        return nodeBuilder.build();
    }

    @Override
    public GridClientFutureAdapter<?> messageBeforeStart(Object msg) throws GridClientException {
        assert (msg instanceof GridClientNodeStateBeforeStartRequest);
        return this.makeRequest((GridClientMessage)msg, new TcpClientFuture());
    }

    private static class TcpClientFuture<R>
    extends GridClientFutureAdapter<R> {
        private static final long serialVersionUID = 0L;
        private static final int STATE_INITIAL = 0;
        private static final int STATE_AUTH_RETRY = 1;
        private static final int STATE_REQUEST_RETRY = 2;
        private final boolean forward;
        private final boolean keepBinaries;
        private GridClientMessage pendingMsg;
        private int authRetry = 0;

        private TcpClientFuture() {
            this.forward = false;
            this.keepBinaries = false;
        }

        private TcpClientFuture(boolean forward, boolean keepBinaries) {
            this.forward = forward;
            this.keepBinaries = keepBinaries;
        }

        public GridClientMessage pendingMessage() {
            return this.pendingMsg;
        }

        public void pendingMessage(GridClientMessage pendingMsg) {
            this.pendingMsg = pendingMsg;
        }

        public int retryState() {
            return this.authRetry;
        }

        public void retryState(int authRetry) {
            this.authRetry = authRetry;
        }

        public boolean forward() {
            return this.forward;
        }

        public boolean keepBinaries() {
            return this.keepBinaries;
        }

        @Override
        public String toString() {
            return "TcpClientFuture [state=" + this.authRetry + ", forward=" + this.forward + ", message=" + this.pendingMsg + "]";
        }
    }
}

