/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteEvents;
import org.apache.ignite.IgniteMessaging;
import org.apache.ignite.IgniteServices;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.ClusterMetricsSnapshot;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteComputeImpl;
import org.apache.ignite.internal.IgniteEventsImpl;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgniteMessagingImpl;
import org.apache.ignite.internal.IgniteServicesImpl;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.cluster.ClusterGroupEx;
import org.apache.ignite.internal.executor.GridExecutorService;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.jetbrains.annotations.Nullable;

public class ClusterGroupAdapter
implements ClusterGroupEx,
Externalizable {
    private static final long serialVersionUID = 0L;
    protected transient GridKernalContext ctx;
    private transient IgniteComputeImpl compute;
    private transient IgniteMessagingImpl messaging;
    private transient IgniteEvents evts;
    private transient IgniteServices svcs;
    private String igniteInstanceName;
    protected UUID subjId;
    protected IgnitePredicate<ClusterNode> p;
    private Set<UUID> ids;
    private volatile transient ClusterGroupState state;

    public ClusterGroupAdapter() {
    }

    protected ClusterGroupAdapter(@Nullable GridKernalContext ctx, @Nullable UUID subjId, @Nullable IgnitePredicate<ClusterNode> p) {
        if (ctx != null) {
            this.setKernalContext(ctx);
        }
        this.subjId = subjId;
        this.p = p;
        this.ids = null;
    }

    protected ClusterGroupAdapter(@Nullable GridKernalContext ctx, @Nullable UUID subjId, Set<UUID> ids) {
        if (ctx != null) {
            this.setKernalContext(ctx);
        }
        assert (ids != null);
        this.subjId = subjId;
        this.ids = ids;
        this.p = F.nodeForNodeIds(ids);
    }

    private ClusterGroupAdapter(@Nullable GridKernalContext ctx, @Nullable UUID subjId, @Nullable IgnitePredicate<ClusterNode> p, Set<UUID> ids) {
        if (ctx != null) {
            this.setKernalContext(ctx);
        }
        this.subjId = subjId;
        this.p = p;
        this.ids = ids;
        if (p == null && ids != null) {
            this.p = F.nodeForNodeIds(ids);
        }
    }

    protected void guard() {
        assert (this.ctx != null);
        this.ctx.gateway().readLock();
    }

    protected void unguard() {
        assert (this.ctx != null);
        this.ctx.gateway().readUnlock();
    }

    public void setKernalContext(GridKernalContext ctx) {
        assert (ctx != null);
        assert (this.ctx == null);
        this.ctx = ctx;
        this.igniteInstanceName = ctx.igniteInstanceName();
    }

    @Override
    public final Ignite ignite() {
        assert (this.ctx != null);
        this.guard();
        try {
            IgniteEx igniteEx = this.ctx.grid();
            return igniteEx;
        }
        finally {
            this.unguard();
        }
    }

    public final IgniteCompute compute() {
        if (this.compute == null) {
            assert (this.ctx != null);
            this.compute = new IgniteComputeImpl(this.ctx, this, this.subjId);
        }
        return this.compute;
    }

    public final IgniteMessaging message() {
        if (this.messaging == null) {
            assert (this.ctx != null);
            this.messaging = new IgniteMessagingImpl(this.ctx, this, false);
        }
        return this.messaging;
    }

    public final IgniteEvents events() {
        if (this.evts == null) {
            assert (this.ctx != null);
            this.evts = new IgniteEventsImpl(this.ctx, this, false);
        }
        return this.evts;
    }

    public IgniteServices services() {
        if (this.svcs == null) {
            assert (this.ctx != null);
            this.svcs = new IgniteServicesImpl(this.ctx, this, false);
        }
        return this.svcs;
    }

    public ExecutorService executorService() {
        assert (this.ctx != null);
        return new GridExecutorService(this, this.ctx);
    }

    @Override
    public final ClusterMetrics metrics() {
        this.guard();
        try {
            if (this.nodes().isEmpty()) {
                throw U.convertException(U.emptyTopologyException());
            }
            ClusterMetricsSnapshot clusterMetricsSnapshot = new ClusterMetricsSnapshot(this);
            return clusterMetricsSnapshot;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public Collection<ClusterNode> nodes() {
        return Collections.unmodifiableCollection(this.ensureLastTopologyState().nodes);
    }

    protected Collection<ClusterNode> resolveCurrentNodes() {
        assert (Thread.holdsLock(this));
        if (this.ids != null) {
            if (this.ids.isEmpty()) {
                return Collections.emptyList();
            }
            if (this.ids.size() == 1) {
                ClusterNode node = this.ctx.discovery().node(F.first(this.ids));
                return node != null ? Collections.singleton(node) : Collections.emptySet();
            }
            ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>(this.ids.size());
            for (UUID id : this.ids) {
                ClusterNode node = this.ctx.discovery().node(id);
                if (node == null) continue;
                nodes.add(node);
            }
            nodes.trimToSize();
            return nodes;
        }
        Collection<ClusterNode> all = this.p instanceof DaemonFilter ? F.concat(false, this.ctx.discovery().daemonNodes(), this.ctx.discovery().allNodes()) : this.ctx.discovery().allNodes();
        return this.p != null ? F.view(all, this.p) : all;
    }

    @Override
    public Collection<String> hostNames() {
        HashSet<String> res = new HashSet<String>();
        for (ClusterNode node : this.nodes()) {
            res.addAll(node.hostNames());
        }
        return Collections.unmodifiableSet(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ClusterNode node(UUID id) {
        A.notNull(id, "id");
        this.guard();
        try {
            if (this.ids != null) {
                ClusterNode clusterNode = this.ids.contains(id) ? this.ctx.discovery().node(id) : null;
                return clusterNode;
            }
            ClusterNode node = this.ctx.discovery().node(id);
            ClusterNode clusterNode = node != null && (this.p == null || this.p.apply(node)) ? node : null;
            return clusterNode;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public ClusterNode node() {
        return F.first(this.nodes());
    }

    @Override
    public IgnitePredicate<ClusterNode> predicate() {
        return this.p != null ? this.p : F.alwaysTrue();
    }

    @Override
    public ClusterGroup forPredicate(IgnitePredicate<ClusterNode> p) {
        A.notNull(p, "p");
        this.guard();
        try {
            if (p != null) {
                this.ctx.resource().injectGeneric(p);
            }
            ClusterGroupAdapter clusterGroupAdapter = new ClusterGroupAdapter(this.ctx, this.subjId, this.p != null ? F.and(p, this.p) : p);
            return clusterGroupAdapter;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public final ClusterGroup forAttribute(String name, @Nullable Object val) {
        A.notNull(name, "n");
        return this.forPredicate(new AttributeFilter(name, val));
    }

    @Override
    public ClusterGroup forServers() {
        return this.forPredicate(new AttributeFilter("org.apache.ignite.cache.client", false));
    }

    @Override
    public ClusterGroup forClients() {
        return this.forPredicate(new AttributeFilter("org.apache.ignite.cache.client", true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ClusterGroup forNode(ClusterNode node, ClusterNode ... nodes) {
        A.notNull(node, "node");
        this.guard();
        try {
            Set<UUID> nodeIds;
            if (F.isEmpty(nodes)) {
                nodeIds = this.contains(node) ? Collections.singleton(node.id()) : Collections.emptySet();
            } else {
                nodeIds = U.newHashSet(nodes.length + 1);
                for (ClusterNode n : nodes) {
                    if (!this.contains(n)) continue;
                    nodeIds.add(n.id());
                }
                if (this.contains(node)) {
                    nodeIds.add(node.id());
                }
            }
            ClusterGroupAdapter clusterGroupAdapter = new ClusterGroupAdapter(this.ctx, this.subjId, nodeIds);
            return clusterGroupAdapter;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ClusterGroup forNodes(Collection<? extends ClusterNode> nodes) {
        A.notEmpty(nodes, "nodes");
        this.guard();
        try {
            HashSet<UUID> nodeIds = U.newHashSet(nodes.size());
            for (ClusterNode clusterNode : nodes) {
                if (!this.contains(clusterNode)) continue;
                nodeIds.add(clusterNode.id());
            }
            ClusterGroupAdapter clusterGroupAdapter = new ClusterGroupAdapter(this.ctx, this.subjId, nodeIds);
            return clusterGroupAdapter;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ClusterGroup forNodeId(UUID id, UUID ... ids) {
        A.notNull(id, "id");
        this.guard();
        try {
            Set<UUID> nodeIds;
            if (F.isEmpty(ids)) {
                nodeIds = this.contains(id) ? Collections.singleton(id) : Collections.emptySet();
            } else {
                nodeIds = U.newHashSet(ids.length + 1);
                for (UUID id0 : ids) {
                    if (!this.contains(id)) continue;
                    nodeIds.add(id0);
                }
                if (this.contains(id)) {
                    nodeIds.add(id);
                }
            }
            ClusterGroupAdapter clusterGroupAdapter = new ClusterGroupAdapter(this.ctx, this.subjId, nodeIds);
            return clusterGroupAdapter;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ClusterGroup forNodeIds(Collection<UUID> ids) {
        A.notEmpty(ids, "ids");
        this.guard();
        try {
            HashSet<UUID> nodeIds = U.newHashSet(ids.size());
            for (UUID id : ids) {
                if (!this.contains(id)) continue;
                nodeIds.add(id);
            }
            ClusterGroupAdapter clusterGroupAdapter = new ClusterGroupAdapter(this.ctx, this.subjId, nodeIds);
            return clusterGroupAdapter;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public final ClusterGroup forOthers(ClusterNode node, ClusterNode ... nodes) {
        A.notNull(node, "node");
        return this.forOthers(F.concat(false, node.id(), F.nodeIds(Arrays.asList(nodes))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClusterGroup forOthers(ClusterGroup grp) {
        A.notNull(grp, "grp");
        if (this.ids != null) {
            this.guard();
            try {
                HashSet<UUID> nodeIds = U.newHashSet(this.ids.size());
                for (UUID id : this.ids) {
                    ClusterNode n = this.node(id);
                    if (n == null || grp.predicate().apply(n)) continue;
                    nodeIds.add(id);
                }
                ClusterGroupAdapter clusterGroupAdapter = new ClusterGroupAdapter(this.ctx, this.subjId, nodeIds);
                return clusterGroupAdapter;
            }
            finally {
                this.unguard();
            }
        }
        return this.forPredicate(F.not(grp.predicate()));
    }

    @Override
    public final ClusterGroup forRemotes() {
        return this.forOthers(Collections.singleton(this.ctx.localNodeId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterGroup forOthers(Collection<UUID> excludeIds) {
        assert (excludeIds != null);
        if (this.ids != null) {
            this.guard();
            try {
                HashSet<UUID> nodeIds = U.newHashSet(this.ids.size());
                for (UUID id : this.ids) {
                    if (excludeIds.contains(id)) continue;
                    nodeIds.add(id);
                }
                ClusterGroupAdapter clusterGroupAdapter = new ClusterGroupAdapter(this.ctx, this.subjId, nodeIds);
                return clusterGroupAdapter;
            }
            finally {
                this.unguard();
            }
        }
        return this.forPredicate(new OthersFilter(excludeIds));
    }

    private void checkDaemon() throws IllegalStateException {
        if (this.ctx.isDaemon()) {
            throw new IllegalStateException("Not applicable for the daemon node.");
        }
    }

    @Override
    public final ClusterGroup forCacheNodes(String cacheName) {
        CU.validateCacheName(cacheName);
        this.checkDaemon();
        return this.forPredicate(new CachesFilter(cacheName, true, true, true));
    }

    @Override
    public final ClusterGroup forDataNodes(String cacheName) {
        CU.validateCacheName(cacheName);
        this.checkDaemon();
        return this.forPredicate(new CachesFilter(cacheName, true, false, false));
    }

    @Override
    public final ClusterGroup forClientNodes(String cacheName) {
        CU.validateCacheName(cacheName);
        this.checkDaemon();
        return this.forPredicate(new CachesFilter(cacheName, false, true, true));
    }

    @Override
    public ClusterGroup forCacheNodes(String cacheName, boolean affNodes, boolean nearNodes, boolean clientNodes) {
        CU.validateCacheName(cacheName);
        this.checkDaemon();
        return this.forPredicate(new CachesFilter(cacheName, affNodes, nearNodes, clientNodes));
    }

    @Override
    public final ClusterGroup forHost(ClusterNode node) {
        A.notNull(node, "node");
        String macs = (String)node.attribute("org.apache.ignite.macs");
        assert (macs != null);
        return this.forAttribute("org.apache.ignite.macs", macs);
    }

    @Override
    public final ClusterGroup forHost(String host, String ... hosts) {
        A.notNull(host, "host");
        return this.forPredicate(new HostsFilter(host, hosts));
    }

    @Override
    public final ClusterGroup forDaemons() {
        return this.forPredicate(new DaemonFilter());
    }

    @Override
    public final ClusterGroup forRandom() {
        if (!F.isEmpty(this.ids)) {
            return this.forNodeId(F.rand(this.ids), new UUID[0]);
        }
        Collection<ClusterNode> nodes = this.nodes();
        if (nodes.isEmpty()) {
            return new ClusterGroupAdapter(this.ctx, null, Collections.emptySet());
        }
        return this.forNode(F.rand(nodes), new ClusterNode[0]);
    }

    @Override
    public ClusterGroup forOldest() {
        return new AgeClusterGroup(this, true);
    }

    @Override
    public ClusterGroup forYoungest() {
        return new AgeClusterGroup(this, false);
    }

    @Override
    public ClusterGroupEx forSubjectId(UUID subjId) {
        if (subjId == null) {
            return this;
        }
        this.guard();
        try {
            ClusterGroupAdapter clusterGroupAdapter = this.ids != null ? new ClusterGroupAdapter(this.ctx, subjId, this.ids) : new ClusterGroupAdapter(this.ctx, subjId, this.p);
            return clusterGroupAdapter;
        }
        finally {
            this.unguard();
        }
    }

    private boolean contains(ClusterNode n) {
        assert (n != null);
        return this.ids != null ? this.ids.contains(n.id()) : this.p == null || this.p.apply(n);
    }

    private boolean contains(UUID id) {
        assert (id != null);
        if (this.ids != null) {
            return this.ids.contains(id);
        }
        ClusterNode n = this.ctx.discovery().node(id);
        return n != null && (this.p == null || this.p.apply(n));
    }

    protected final ClusterGroupState ensureLastTopologyState() {
        ClusterGroupState state = this.state;
        GridDiscoveryManager discoMgr = this.ctx.discovery();
        long lastTopVer = discoMgr.topologyVersion();
        long startTime = discoMgr.gridStartTime();
        if (state == null || state.lastTopVer < lastTopVer || state.startTime != startTime) {
            return this.resetState();
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized ClusterGroupState resetState() {
        this.guard();
        try {
            ClusterGroupState state = this.state;
            GridDiscoveryManager discoMgr = this.ctx.discovery();
            long lastTopVer = discoMgr.topologyVersion();
            long startTime = discoMgr.gridStartTime();
            if (state != null && state.lastTopVer == lastTopVer && state.startTime == startTime) {
                ClusterGroupState clusterGroupState = state;
                return clusterGroupState;
            }
            Collection<ClusterNode> nodes = this.resolveCurrentNodes();
            ClusterGroupState clusterGroupState = this.state = new ClusterGroupState(nodes, lastTopVer, startTime);
            return clusterGroupState;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.igniteInstanceName);
        U.writeUuid(out, this.subjId);
        out.writeBoolean(this.ids != null);
        if (this.ids != null) {
            out.writeObject(this.ids);
        } else {
            out.writeObject(this.p);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.igniteInstanceName = U.readString(in);
        this.subjId = U.readUuid(in);
        if (in.readBoolean()) {
            this.ids = (Set)in.readObject();
        } else {
            this.p = (IgnitePredicate)in.readObject();
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            IgniteKernal g = IgnitionEx.localIgnite();
            return this.ids != null ? new ClusterGroupAdapter(g.context(), this.subjId, this.ids) : new ClusterGroupAdapter(g.context(), this.subjId, this.p);
        }
        catch (IllegalStateException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
    }

    private static class GroupPredicate
    implements IgnitePredicate<ClusterNode> {
        private static final long serialVersionUID = 0L;
        private final ClusterGroup grp;
        private final IgnitePredicate<ClusterNode> p;

        public GroupPredicate(ClusterGroup grp, IgnitePredicate<ClusterNode> p) {
            this.grp = grp;
            this.p = p;
        }

        @Override
        public boolean apply(ClusterNode node) {
            A.notNull(node, "node is null");
            return this.grp.predicate().apply(node) && this.p.apply(node);
        }

        public String toString() {
            return this.getClass().getName() + " [grp='" + this.grp.getClass().getName() + "', p='" + this.p.getClass().getName() + "']";
        }
    }

    private static class AgeClusterGroup
    extends ClusterGroupAdapter {
        private static final long serialVersionUID = 0L;
        private boolean isOldest;
        private volatile IgnitePredicate<ClusterNode> ageP;

        public AgeClusterGroup() {
        }

        private AgeClusterGroup(ClusterGroupAdapter parent, boolean isOldest) {
            super(parent.ctx, parent.subjId, parent.p, parent.ids);
            this.isOldest = isOldest;
        }

        protected Set<ClusterNode> resolveCurrentNodes() {
            ClusterNode node;
            Collection<ClusterNode> nodes = super.resolveCurrentNodes();
            ClusterNode clusterNode = node = this.isOldest ? U.oldest(nodes, null) : U.youngest(nodes, null);
            if (node == null) {
                this.ageP = F.alwaysFalse();
                return Collections.emptySet();
            }
            this.ageP = F.nodeForNodes(node);
            return Collections.singleton(node);
        }

        @Override
        public Collection<ClusterNode> nodes() {
            this.guard();
            try {
                ClusterNode node = F.first(this.ensureLastTopologyState().nodes);
                if (node != null) {
                    node = this.ctx.discovery().node(node.id());
                }
                Set<ClusterNode> set = node == null ? Collections.emptySet() : Collections.singleton(node);
                return set;
            }
            finally {
                this.unguard();
            }
        }

        @Override
        public IgnitePredicate<ClusterNode> predicate() {
            this.ensureLastTopologyState();
            return this.ageP;
        }

        @Override
        public ClusterGroup forPredicate(IgnitePredicate<ClusterNode> p) {
            A.notNull(p, "p");
            this.guard();
            try {
                if (p != null) {
                    this.ctx.resource().injectGeneric(p);
                }
                ClusterGroupAdapter clusterGroupAdapter = new ClusterGroupAdapter(this.ctx, this.subjId, new GroupPredicate(this, p));
                return clusterGroupAdapter;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            finally {
                this.unguard();
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeBoolean(this.isOldest);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.isOldest = in.readBoolean();
        }

        @Override
        protected Object readResolve() throws ObjectStreamException {
            ClusterGroupAdapter parent = (ClusterGroupAdapter)super.readResolve();
            return new AgeClusterGroup(parent, this.isOldest);
        }
    }

    private static class OthersFilter
    implements IgnitePredicate<ClusterNode> {
        private static final long serialVersionUID = 0L;
        private final Collection<UUID> nodeIds;

        private OthersFilter(Collection<UUID> nodeIds) {
            this.nodeIds = nodeIds;
        }

        @Override
        public boolean apply(ClusterNode n) {
            return !this.nodeIds.contains(n.id());
        }
    }

    private static class DaemonFilter
    implements IgnitePredicate<ClusterNode> {
        private static final long serialVersionUID = 0L;

        private DaemonFilter() {
        }

        @Override
        public boolean apply(ClusterNode n) {
            return n.isDaemon();
        }
    }

    private static class HostsFilter
    implements IgnitePredicate<ClusterNode> {
        private static final long serialVersionUID = 0L;
        private final Collection<String> validHostNames = new HashSet<String>();

        private HostsFilter(String name, String ... names) {
            this.validHostNames.add(name);
            if (names != null && names.length > 0) {
                Collections.addAll(this.validHostNames, names);
            }
        }

        @Override
        public boolean apply(ClusterNode n) {
            for (String hostName : n.hostNames()) {
                if (!this.validHostNames.contains(hostName)) continue;
                return true;
            }
            return false;
        }
    }

    private static class AttributeFilter
    implements IgnitePredicate<ClusterNode> {
        private static final long serialVersionUID = 0L;
        private final String name;
        private final Object val;

        private AttributeFilter(String name, Object val) {
            this.name = name;
            this.val = val;
        }

        @Override
        public boolean apply(ClusterNode n) {
            return this.val == null ? n.attributes().containsKey(this.name) : this.val.equals(n.attribute(this.name));
        }
    }

    private static class CachesFilter
    implements IgnitePredicate<ClusterNode> {
        private static final long serialVersionUID = 0L;
        private final String cacheName;
        private boolean affNodes;
        private boolean nearNodes;
        private boolean clients;
        @IgniteInstanceResource
        private transient Ignite ignite;

        private CachesFilter(String cacheName, boolean affNodes, boolean nearNodes, boolean clients) {
            this.cacheName = cacheName;
            this.affNodes = affNodes;
            this.nearNodes = nearNodes;
            this.clients = clients;
        }

        @Override
        public boolean apply(ClusterNode n) {
            GridDiscoveryManager disco = ((IgniteKernal)this.ignite).context().discovery();
            if (this.affNodes && disco.cacheAffinityNode(n, this.cacheName)) {
                return true;
            }
            if (!this.affNodes && disco.cacheAffinityNode(n, this.cacheName)) {
                return false;
            }
            if (this.nearNodes && disco.cacheNearNode(n, this.cacheName)) {
                return true;
            }
            return this.clients && disco.cacheClientNode(n, this.cacheName);
        }
    }

    private static class ClusterGroupState {
        public final Collection<ClusterNode> nodes;
        public final long lastTopVer;
        public final long startTime;

        public ClusterGroupState(Collection<ClusterNode> nodes, long lastTopVer, long startTime) {
            this.nodes = nodes;
            this.lastTopVer = lastTopVer;
            this.startTime = startTime;
        }
    }
}

