/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record;

import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class DataEntry {
    @GridToStringInclude
    protected int cacheId;
    protected KeyCacheObject key;
    @Nullable
    protected CacheObject val;
    @GridToStringInclude
    protected GridCacheOperation op;
    @GridToStringInclude
    protected GridCacheVersion nearXidVer;
    @GridToStringInclude
    protected GridCacheVersion writeVer;
    protected long expireTime;
    @GridToStringInclude
    protected int partId;
    @GridToStringInclude
    protected long partCnt;

    private DataEntry() {
    }

    public DataEntry(int cacheId, KeyCacheObject key, @Nullable CacheObject val, GridCacheOperation op, GridCacheVersion nearXidVer, GridCacheVersion writeVer, long expireTime, int partId, long partCnt) {
        this.cacheId = cacheId;
        this.key = key;
        this.val = val;
        this.op = op;
        this.nearXidVer = nearXidVer;
        this.writeVer = writeVer;
        this.expireTime = expireTime;
        this.partId = partId;
        this.partCnt = partCnt;
        assert (op == GridCacheOperation.READ || op == GridCacheOperation.CREATE || op == GridCacheOperation.UPDATE || op == GridCacheOperation.DELETE) : "Only READ, CREATE, UPDATE and DELETE operations should be stored in WAL [op=" + (Object)((Object)op) + ']';
    }

    public int cacheId() {
        return this.cacheId;
    }

    public KeyCacheObject key() {
        return this.key;
    }

    public CacheObject value() {
        return this.val;
    }

    public GridCacheOperation op() {
        return this.op;
    }

    public GridCacheVersion nearXidVersion() {
        return this.nearXidVer;
    }

    public GridCacheVersion writeVersion() {
        return this.writeVer;
    }

    public int partitionId() {
        return this.partId;
    }

    public long partitionCounter() {
        return this.partCnt;
    }

    public DataEntry partitionCounter(long partCnt) {
        this.partCnt = partCnt;
        return this;
    }

    public long expireTime() {
        return this.expireTime;
    }

    public String toString() {
        return S.toString(DataEntry.class, this);
    }
}

